/*
 * Decompiled with CFR 0.152.
 */
package es.eucm.eadventure.editor.gui.elementpanels.macro;

import es.eucm.eadventure.common.gui.TC;
import es.eucm.eadventure.editor.control.Controller;
import es.eucm.eadventure.editor.control.controllers.macro.MacroListDataControl;
import es.eucm.eadventure.editor.control.tools.macro.RenameMacroTool;
import es.eucm.eadventure.editor.gui.elementpanels.general.tables.StringCellRendererEditor;
import javax.swing.JTable;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;

public class MacrosTable
extends JTable {
    private static final long serialVersionUID = 1L;
    protected MacroListDataControl dataControl;

    public MacrosTable(MacroListDataControl macroListDataControl) {
        this.dataControl = macroListDataControl;
        this.setModel(new MacrosTableModel());
        this.getColumnModel().setColumnSelectionAllowed(false);
        this.setDragEnabled(false);
        this.putClientProperty("terminateEditOnFocusLost", Boolean.TRUE);
        this.getColumnModel().getColumn(0).setCellEditor(new StringCellRendererEditor());
        this.getColumnModel().getColumn(0).setCellRenderer(new StringCellRendererEditor());
        this.getSelectionModel().setSelectionMode(0);
        this.setRowHeight(20);
        this.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                MacrosTable.this.setRowHeight(20);
                if (MacrosTable.this.getSelectedRow() != -1) {
                    MacrosTable.this.setRowHeight(MacrosTable.this.getSelectedRow(), 26);
                }
            }
        });
        this.setSize(200, 150);
    }

    private class MacrosTableModel
    extends AbstractTableModel {
        private static final long serialVersionUID = 1L;

        private MacrosTableModel() {
        }

        @Override
        public int getColumnCount() {
            return 1;
        }

        @Override
        public int getRowCount() {
            return MacrosTable.this.dataControl.getMacros().size();
        }

        @Override
        public Object getValueAt(int n, int n2) {
            if (n2 == 0) {
                return MacrosTable.this.dataControl.getMacros().get(n).getId();
            }
            return null;
        }

        @Override
        public String getColumnName(int n) {
            if (n == 0) {
                return TC.get((String)"MacrosList.ID");
            }
            return "";
        }

        @Override
        public void setValueAt(Object object, int n, int n2) {
            if (n2 == 0) {
                Controller.getInstance().addTool(new RenameMacroTool(MacrosTable.this.dataControl.getMacros().get(n), (String)object));
            }
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            return MacrosTable.this.getSelectedRow() == n;
        }
    }
}

