/*
 * Decompiled with CFR 0.152.
 */
package es.eucm.eadventure.editor.gui.elementpanels.item;

import es.eucm.eadventure.common.gui.TC;
import es.eucm.eadventure.editor.control.controllers.item.ItemDataControl;
import es.eucm.eadventure.editor.gui.elementpanels.ElementPanel;
import es.eucm.eadventure.editor.gui.elementpanels.PanelTab;
import es.eucm.eadventure.editor.gui.elementpanels.general.ActionsListPanel;
import es.eucm.eadventure.editor.gui.elementpanels.item.ItemDocPanel;
import es.eucm.eadventure.editor.gui.elementpanels.item.ItemLooksPanel;
import javax.swing.JComponent;

public class ItemPanel
extends ElementPanel {
    private static final long serialVersionUID = 1L;

    public ItemPanel(ItemDataControl itemDataControl) {
        this.addTab(new ItemLooksPanelTab(itemDataControl));
        this.addTab(new ItemDocPanelTab(itemDataControl));
        this.addTab(new ActionsPanelTab(itemDataControl));
    }

    private class ActionsPanelTab
    extends PanelTab {
        private ItemDataControl itemDataControl;

        public ActionsPanelTab(ItemDataControl itemDataControl) {
            super(TC.get((String)"Item.ActionsPanelTitle"), itemDataControl.getActionsList());
            this.itemDataControl = itemDataControl;
        }

        @Override
        protected JComponent getTabComponent() {
            return new ActionsListPanel(this.itemDataControl.getActionsList());
        }
    }

    private class ItemLooksPanelTab
    extends PanelTab {
        private ItemDataControl itemDataControl;

        public ItemLooksPanelTab(ItemDataControl itemDataControl) {
            super(TC.get((String)"Item.LookPanelTitle"), itemDataControl);
            this.itemDataControl = itemDataControl;
        }

        @Override
        protected JComponent getTabComponent() {
            return new ItemLooksPanel(this.itemDataControl);
        }
    }

    private class ItemDocPanelTab
    extends PanelTab {
        private ItemDataControl itemDataControl;

        public ItemDocPanelTab(ItemDataControl itemDataControl) {
            super(TC.get((String)"Item.DocPanelTitle"), itemDataControl);
            this.itemDataControl = itemDataControl;
        }

        @Override
        protected JComponent getTabComponent() {
            return new ItemDocPanel(this.itemDataControl);
        }
    }
}

