/*
 * Decompiled with CFR 0.152.
 */
package es.eucm.eadventure.editor.gui.elementpanels.item;

import es.eucm.eadventure.common.data.Described;
import es.eucm.eadventure.common.data.Detailed;
import es.eucm.eadventure.common.data.Documented;
import es.eucm.eadventure.common.data.Named;
import es.eucm.eadventure.common.gui.TC;
import es.eucm.eadventure.editor.control.Controller;
import es.eucm.eadventure.editor.control.controllers.item.ItemDataControl;
import es.eucm.eadventure.editor.control.tools.generic.ChangeBooleanValueTool;
import es.eucm.eadventure.editor.control.tools.listeners.DescriptionChangeListener;
import es.eucm.eadventure.editor.control.tools.listeners.DetailedDescriptionChangeListener;
import es.eucm.eadventure.editor.control.tools.listeners.DocumentationChangeListener;
import es.eucm.eadventure.editor.control.tools.listeners.NameChangeListener;
import es.eucm.eadventure.editor.gui.Updateable;
import es.eucm.eadventure.editor.gui.auxiliar.components.JFiller;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;

public class ItemDocPanel
extends JPanel
implements Updateable {
    private static final long serialVersionUID = 4556146180537102976L;
    private JTextArea documentationTextArea;
    private JTextField nameTextField;
    private JTextField descriptionTextField;
    private JTextField detailedDescriptionTextField;
    private JCheckBox returnsWhenDraggedCheckBox;
    private ItemDataControl itemDataControl;

    public ItemDocPanel(ItemDataControl itemDataControl) {
        this.itemDataControl = itemDataControl;
        this.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.3;
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridLayout());
        this.documentationTextArea = new JTextArea(itemDataControl.getDocumentation(), 4, 0);
        this.documentationTextArea.setLineWrap(true);
        this.documentationTextArea.setWrapStyleWord(true);
        this.documentationTextArea.getDocument().addDocumentListener(new DocumentationChangeListener(this.documentationTextArea, (Documented)itemDataControl.getContent()));
        jPanel.add(new JScrollPane(this.documentationTextArea, 22, 31));
        jPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), TC.get((String)"Item.Documentation")));
        this.add((Component)jPanel, gridBagConstraints);
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weighty = 0.0;
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new GridLayout());
        this.nameTextField = new JTextField(itemDataControl.getName());
        this.nameTextField.getDocument().addDocumentListener(new NameChangeListener(this.nameTextField, (Named)itemDataControl.getContent()));
        jPanel2.add(this.nameTextField);
        jPanel2.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), TC.get((String)"Item.Name")));
        this.add((Component)jPanel2, gridBagConstraints);
        gridBagConstraints.gridy = 2;
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new GridLayout());
        this.descriptionTextField = new JTextField(itemDataControl.getBriefDescription());
        this.descriptionTextField.getDocument().addDocumentListener(new DescriptionChangeListener(this.descriptionTextField, (Described)itemDataControl.getContent()));
        jPanel3.add(this.descriptionTextField);
        jPanel3.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), TC.get((String)"Item.Description")));
        this.add((Component)jPanel3, gridBagConstraints);
        gridBagConstraints.gridy = 3;
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout(new GridLayout());
        this.detailedDescriptionTextField = new JTextField(itemDataControl.getDetailedDescription());
        this.detailedDescriptionTextField.getDocument().addDocumentListener(new DetailedDescriptionChangeListener(this.detailedDescriptionTextField, (Detailed)itemDataControl.getContent()));
        jPanel4.add(this.detailedDescriptionTextField);
        jPanel4.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), TC.get((String)"Item.DetailedDescription")));
        this.add((Component)jPanel4, gridBagConstraints);
        gridBagConstraints.gridy = 4;
        this.returnsWhenDraggedCheckBox = new JCheckBox(TC.get((String)"Item.ReturnsWhenDragged"));
        this.returnsWhenDraggedCheckBox.setSelected(itemDataControl.isReturnsWhenDragged());
        this.returnsWhenDraggedCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Controller.getInstance().addTool(new ChangeBooleanValueTool(ItemDocPanel.this.itemDataControl, ((JCheckBox)actionEvent.getSource()).isSelected(), "isReturnsWhenDragged", "setReturnsWhenDragged"));
            }
        });
        this.add((Component)this.returnsWhenDraggedCheckBox, gridBagConstraints);
        gridBagConstraints.gridy = 5;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.5;
        this.add((Component)new JFiller(), gridBagConstraints);
    }

    @Override
    public boolean updateFields() {
        return false;
    }
}

