/*
 * Decompiled with CFR 0.152.
 */
package es.eucm.eadventure.editor.gui.elementpanels.globalstate;

import es.eucm.eadventure.common.gui.TC;
import es.eucm.eadventure.editor.control.Controller;
import es.eucm.eadventure.editor.control.controllers.globalstate.GlobalStateListDataControl;
import es.eucm.eadventure.editor.control.tools.globalstate.RenameGlobalStateTool;
import es.eucm.eadventure.editor.gui.elementpanels.general.tables.StringCellRendererEditor;
import javax.swing.JTable;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;

public class GlobalStatesTable
extends JTable {
    private static final long serialVersionUID = 1L;
    protected GlobalStateListDataControl dataControl;

    public GlobalStatesTable(GlobalStateListDataControl globalStateListDataControl) {
        this.dataControl = globalStateListDataControl;
        this.setModel(new BarriersTableModel());
        this.getColumnModel().setColumnSelectionAllowed(false);
        this.setDragEnabled(false);
        this.putClientProperty("terminateEditOnFocusLost", Boolean.TRUE);
        this.getColumnModel().getColumn(0).setCellEditor(new StringCellRendererEditor());
        this.getColumnModel().getColumn(0).setCellRenderer(new StringCellRendererEditor());
        this.getSelectionModel().setSelectionMode(0);
        this.setRowHeight(20);
        this.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                GlobalStatesTable.this.setRowHeight(20);
                if (GlobalStatesTable.this.getSelectedRow() != -1) {
                    GlobalStatesTable.this.setRowHeight(GlobalStatesTable.this.getSelectedRow(), 26);
                }
            }
        });
        this.setSize(200, 150);
    }

    private class BarriersTableModel
    extends AbstractTableModel {
        private static final long serialVersionUID = 1L;

        private BarriersTableModel() {
        }

        @Override
        public int getColumnCount() {
            return 1;
        }

        @Override
        public int getRowCount() {
            return GlobalStatesTable.this.dataControl.getGlobalStates().size();
        }

        @Override
        public Object getValueAt(int n, int n2) {
            if (n2 == 0) {
                return GlobalStatesTable.this.dataControl.getGlobalStates().get(n).getId();
            }
            return null;
        }

        @Override
        public String getColumnName(int n) {
            if (n == 0) {
                return TC.get((String)"GlobalStatesList.ID");
            }
            return "";
        }

        @Override
        public void setValueAt(Object object, int n, int n2) {
            if (n2 == 0) {
                Controller.getInstance().addTool(new RenameGlobalStateTool(GlobalStatesTable.this.dataControl.getGlobalStates().get(n), (String)object));
            }
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            return GlobalStatesTable.this.getSelectedRow() == n;
        }
    }
}

