/*
 * Decompiled with CFR 0.152.
 */
package es.eucm.eadventure.editor.gui.elementpanels.globalstate;

import es.eucm.eadventure.common.gui.TC;
import es.eucm.eadventure.editor.control.Controller;
import es.eucm.eadventure.editor.control.controllers.Searchable;
import es.eucm.eadventure.editor.control.controllers.globalstate.GlobalStateDataControl;
import es.eucm.eadventure.editor.control.controllers.globalstate.GlobalStateListDataControl;
import es.eucm.eadventure.editor.control.tools.globalstate.AddGlobalStateTool;
import es.eucm.eadventure.editor.control.tools.globalstate.DeleteGlobalStateTool;
import es.eucm.eadventure.editor.control.tools.globalstate.DuplicateGlobalStateTool;
import es.eucm.eadventure.editor.gui.DataControlsPanel;
import es.eucm.eadventure.editor.gui.Updateable;
import es.eucm.eadventure.editor.gui.auxiliar.components.JFiller;
import es.eucm.eadventure.editor.gui.elementpanels.general.TableScrollPane;
import es.eucm.eadventure.editor.gui.elementpanels.globalstate.GlobalStatePanel;
import es.eucm.eadventure.editor.gui.elementpanels.globalstate.GlobalStatesTable;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;

public class GlobalStatesListPanel
extends JPanel
implements DataControlsPanel,
Updateable {
    private static final long serialVersionUID = 1L;
    private static final int HORIZONTAL_SPLIT_POSITION = 100;
    private GlobalStateListDataControl dataControl;
    private JPanel globalStateInfoPanel;
    private JTable table;
    private JButton deleteButton;
    private JButton duplicateButton;

    public GlobalStatesListPanel(GlobalStateListDataControl globalStateListDataControl) {
        this.dataControl = globalStateListDataControl;
        this.setLayout(new BorderLayout());
        this.globalStateInfoPanel = new JPanel();
        this.globalStateInfoPanel.setLayout(new BorderLayout());
        JPanel jPanel = this.createTablePanel();
        JSplitPane jSplitPane = new JSplitPane(0, jPanel, this.globalStateInfoPanel);
        jSplitPane.setOneTouchExpandable(true);
        jSplitPane.setDividerLocation(100);
        jSplitPane.setContinuousLayout(true);
        jSplitPane.setResizeWeight(0.0);
        jSplitPane.setDividerSize(10);
        this.add((Component)jSplitPane, "Center");
    }

    private JPanel createTablePanel() {
        JPanel jPanel = new JPanel();
        this.table = new GlobalStatesTable(this.dataControl);
        TableScrollPane tableScrollPane = new TableScrollPane(this.table, 22, 31);
        tableScrollPane.setMinimumSize(new Dimension(0, 100));
        this.table.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                if (GlobalStatesListPanel.this.table.getSelectedRow() >= 0) {
                    GlobalStatesListPanel.this.deleteButton.setEnabled(true);
                    GlobalStatesListPanel.this.duplicateButton.setEnabled(true);
                } else {
                    GlobalStatesListPanel.this.deleteButton.setEnabled(false);
                    GlobalStatesListPanel.this.duplicateButton.setEnabled(false);
                }
                GlobalStatesListPanel.this.updateInfoPanel(GlobalStatesListPanel.this.table.getSelectedRow());
                GlobalStatesListPanel.this.deleteButton.repaint();
            }
        });
        JPanel jPanel2 = new JPanel();
        JButton jButton = new JButton(new ImageIcon("img/icons/addNode.png"));
        jButton.setContentAreaFilled(false);
        jButton.setMargin(new Insets(0, 0, 0, 0));
        jButton.setBorder(BorderFactory.createEmptyBorder());
        jButton.setToolTipText(TC.get((String)"GlobalStatesList.AddGlobalState"));
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                GlobalStatesListPanel.this.addGlobalState();
            }
        });
        this.deleteButton = new JButton(new ImageIcon("img/icons/deleteNode.png"));
        this.deleteButton.setContentAreaFilled(false);
        this.deleteButton.setMargin(new Insets(0, 0, 0, 0));
        this.deleteButton.setBorder(BorderFactory.createEmptyBorder());
        this.deleteButton.setToolTipText(TC.get((String)"GlobalStatesList.DeleteGlobalState"));
        this.deleteButton.setEnabled(false);
        this.deleteButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                GlobalStatesListPanel.this.deleteGlobalState();
            }
        });
        this.duplicateButton = new JButton(new ImageIcon("img/icons/duplicateNode.png"));
        this.duplicateButton.setContentAreaFilled(false);
        this.duplicateButton.setMargin(new Insets(0, 0, 0, 0));
        this.duplicateButton.setBorder(BorderFactory.createEmptyBorder());
        this.duplicateButton.setToolTipText(TC.get((String)"GlobalStatesList.DuplicateGlobalState"));
        this.duplicateButton.setEnabled(false);
        this.duplicateButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                GlobalStatesListPanel.this.duplicateGlobalState();
            }
        });
        jPanel2.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        jPanel2.add((Component)jButton, gridBagConstraints);
        gridBagConstraints.gridy = 1;
        jPanel2.add((Component)this.duplicateButton, gridBagConstraints);
        gridBagConstraints.gridy = 3;
        jPanel2.add((Component)this.deleteButton, gridBagConstraints);
        gridBagConstraints.gridy = 2;
        gridBagConstraints.weighty = 2.0;
        gridBagConstraints.fill = 3;
        jPanel2.add((Component)new JFiller(), gridBagConstraints);
        jPanel.setLayout(new BorderLayout());
        jPanel.add((Component)tableScrollPane, "Center");
        jPanel.add((Component)jPanel2, "East");
        return jPanel;
    }

    public void updateInfoPanel(int n) {
        this.globalStateInfoPanel.removeAll();
        if (n >= 0) {
            GlobalStateDataControl globalStateDataControl = this.dataControl.getGlobalStates().get(n);
            GlobalStatePanel globalStatePanel = new GlobalStatePanel(globalStateDataControl);
            this.globalStateInfoPanel.add(globalStatePanel);
        }
        this.globalStateInfoPanel.updateUI();
    }

    protected void addGlobalState() {
        Controller.getInstance().addTool(new AddGlobalStateTool(this.dataControl));
        ((AbstractTableModel)this.table.getModel()).fireTableDataChanged();
        this.table.changeSelection(this.dataControl.getGlobalStates().size() - 1, 0, false, false);
    }

    protected void duplicateGlobalState() {
        Controller.getInstance().addTool(new DuplicateGlobalStateTool(this.dataControl, this.table.getSelectedRow()));
        ((AbstractTableModel)this.table.getModel()).fireTableDataChanged();
        this.table.changeSelection(this.dataControl.getGlobalStates().size() - 1, 0, false, false);
    }

    protected void deleteGlobalState() {
        Controller.getInstance().addTool(new DeleteGlobalStateTool(this.dataControl, this.table.getSelectedRow()));
        this.table.clearSelection();
        ((AbstractTableModel)this.table.getModel()).fireTableDataChanged();
    }

    @Override
    public void setSelectedItem(List<Searchable> list) {
        if (list.size() > 0) {
            for (int i = 0; i < this.dataControl.getGlobalStates().size(); ++i) {
                if (this.dataControl.getGlobalStates().get(i) != list.get(list.size() - 1)) continue;
                this.table.changeSelection(i, i, false, false);
            }
        }
    }

    @Override
    public boolean updateFields() {
        int n = this.table.getSelectedRow();
        int n2 = this.table.getRowCount();
        if (this.table.getCellEditor() != null) {
            this.table.getCellEditor().cancelCellEditing();
        }
        ((AbstractTableModel)this.table.getModel()).fireTableDataChanged();
        if (n2 > 0 && n2 == this.dataControl.getGlobalStates().size() && n != -1 && n < this.table.getRowCount()) {
            this.table.changeSelection(n, 0, false, false);
            this.updateInfoPanel(this.table.getSelectedRow());
        }
        return true;
    }
}

