/*
 * Decompiled with CFR 0.152.
 */
package es.eucm.eadventure.editor.gui.elementpanels.general.tables;

import es.eucm.eadventure.common.gui.TC;
import es.eucm.eadventure.editor.control.controllers.scene.ExitDataControl;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractCellEditor;
import javax.swing.BorderFactory;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.JTable;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;

public class TransitionCellRendererEditor
extends AbstractCellEditor
implements TableCellEditor,
TableCellRenderer {
    private static final long serialVersionUID = 4870491701696223525L;
    private JComboBox combo;
    private ExitDataControl exit;
    private JSpinner spinner;

    @Override
    public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
        this.exit = (ExitDataControl)object;
        return this.comboPanel(jTable);
    }

    @Override
    public Object getCellEditorValue() {
        return this.exit;
    }

    @Override
    public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
        this.exit = (ExitDataControl)object;
        if (!bl) {
            switch (this.exit.getTransitionType()) {
                case 0: {
                    return new JLabel(TC.get((String)"Exit.NoTransition"));
                }
                case 1: {
                    return new JLabel(TC.get((String)"Exit.TopToBottom"));
                }
                case 2: {
                    return new JLabel(TC.get((String)"Exit.BottomToTop"));
                }
                case 3: {
                    return new JLabel(TC.get((String)"Exit.LeftToRight"));
                }
                case 4: {
                    return new JLabel(TC.get((String)"Exit.RightToLeft"));
                }
                case 5: {
                    return new JLabel(TC.get((String)"Exit.FadeIn"));
                }
            }
            return new JLabel("" + this.exit.getTransitionType());
        }
        return this.comboPanel(jTable);
    }

    private JPanel comboPanel(JTable jTable) {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        jPanel.setBorder(BorderFactory.createMatteBorder(2, 0, 2, 0, jTable.getSelectionBackground()));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        this.combo = new JComboBox();
        this.combo.addItem(this.makeObj(TC.get((String)"Exit.NoTransition")));
        this.combo.addItem(this.makeObj(TC.get((String)"Exit.TopToBottom")));
        this.combo.addItem(this.makeObj(TC.get((String)"Exit.BottomToTop")));
        this.combo.addItem(this.makeObj(TC.get((String)"Exit.LeftToRight")));
        this.combo.addItem(this.makeObj(TC.get((String)"Exit.RightToLeft")));
        this.combo.addItem(this.makeObj(TC.get((String)"Exit.FadeIn")));
        this.combo.setSelectedIndex(this.exit.getTransitionType());
        this.combo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TransitionCellRendererEditor.this.exit.setTransitionType(TransitionCellRendererEditor.this.combo.getSelectedIndex());
                if (TransitionCellRendererEditor.this.combo.getSelectedIndex() == 0) {
                    TransitionCellRendererEditor.this.spinner.setEnabled(false);
                } else {
                    TransitionCellRendererEditor.this.spinner.setEnabled(true);
                }
            }
        });
        SpinnerNumberModel spinnerNumberModel = new SpinnerNumberModel(this.exit.getTransitionTime(), Integer.valueOf(0), Integer.valueOf(5000), (Number)100);
        this.spinner = new JSpinner(spinnerNumberModel);
        this.spinner.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                if ((Integer)TransitionCellRendererEditor.this.spinner.getValue() == 900) {
                    TransitionCellRendererEditor.this.spinner.setValue(new Integer(0));
                } else if ((Integer)TransitionCellRendererEditor.this.spinner.getValue() == 100) {
                    TransitionCellRendererEditor.this.spinner.setValue(new Integer(1000));
                }
                TransitionCellRendererEditor.this.exit.setTransitionTime((Integer)TransitionCellRendererEditor.this.spinner.getValue());
            }
        });
        this.spinner.setEnabled(this.combo.getSelectedIndex() != 0);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 2.0;
        gridBagConstraints.fill = 2;
        jPanel.add((Component)this.combo, gridBagConstraints);
        ++gridBagConstraints.gridy;
        jPanel.add((Component)this.spinner, gridBagConstraints);
        return jPanel;
    }

    private Object makeObj(final String string) {
        return new Object(){

            public String toString() {
                return string;
            }
        };
    }
}

