/*
 * Decompiled with CFR 0.152.
 */
package es.eucm.eadventure.editor.gui.elementpanels.general.tables;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import javax.swing.AbstractCellEditor;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;

public class StringCellRendererEditor
extends AbstractCellEditor
implements TableCellEditor,
TableCellRenderer {
    private static final long serialVersionUID = 8128260157985286632L;
    private String value;
    private JTextField textField;

    @Override
    public Object getCellEditorValue() {
        return this.value;
    }

    @Override
    public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
        this.value = (String)object;
        return this.createPanel(bl, jTable);
    }

    private Component createPanel(boolean bl, JTable jTable) {
        JPanel jPanel = new JPanel();
        if (bl) {
            jPanel.setBorder(BorderFactory.createMatteBorder(2, 0, 2, 0, jTable.getSelectionBackground()));
        }
        this.textField = new JTextField(this.value);
        jPanel.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent focusEvent) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        if (!StringCellRendererEditor.this.textField.hasFocus()) {
                            StringCellRendererEditor.this.textField.selectAll();
                            StringCellRendererEditor.this.textField.requestFocusInWindow();
                        }
                    }
                });
            }

            @Override
            public void focusLost(FocusEvent focusEvent) {
            }
        });
        this.textField.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent focusEvent) {
            }

            @Override
            public void focusLost(FocusEvent focusEvent) {
                StringCellRendererEditor.this.stopCellEditing();
            }
        });
        this.textField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                StringCellRendererEditor.this.stopCellEditing();
            }
        });
        this.textField.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent documentEvent) {
            }

            @Override
            public void insertUpdate(DocumentEvent documentEvent) {
                StringCellRendererEditor.this.value = StringCellRendererEditor.this.textField.getText();
            }

            @Override
            public void removeUpdate(DocumentEvent documentEvent) {
                StringCellRendererEditor.this.value = StringCellRendererEditor.this.textField.getText();
            }
        });
        jPanel.setLayout(new BorderLayout());
        jPanel.add((Component)this.textField, "Center");
        return jPanel;
    }

    @Override
    public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
        this.value = (String)object;
        if (bl) {
            return this.createPanel(bl, jTable);
        }
        return new JLabel(this.value);
    }
}

