/*
 * Decompiled with CFR 0.152.
 */
package es.eucm.eadventure.editor.gui.elementpanels.general.tables;

import es.eucm.eadventure.common.data.Named;
import es.eucm.eadventure.common.gui.TC;
import es.eucm.eadventure.editor.control.Controller;
import es.eucm.eadventure.editor.control.controllers.general.ActionDataControl;
import es.eucm.eadventure.editor.control.controllers.general.CustomActionDataControl;
import es.eucm.eadventure.editor.control.tools.listeners.NameChangeListener;
import es.eucm.eadventure.editor.gui.editdialogs.AppearenceDialog;
import es.eucm.eadventure.editor.gui.editdialogs.ConditionsDialog;
import es.eucm.eadventure.editor.gui.editdialogs.EffectsDialog;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractButton;
import javax.swing.AbstractCellEditor;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.text.JTextComponent;

public class SmallActionCellRendererEditor
extends AbstractCellEditor
implements TableCellEditor,
TableCellRenderer {
    private static final long serialVersionUID = 8128260157985286632L;
    private ActionDataControl value;

    @Override
    public Object getCellEditorValue() {
        return this.value;
    }

    @Override
    public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
        this.value = (ActionDataControl)object;
        return this.createComponent();
    }

    @Override
    public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
        this.value = (ActionDataControl)object;
        if (jTable.getSelectedRow() == n) {
            return this.createComponent();
        }
        String string = this.getTypeText(this.value.getType());
        if (this.value.hasIdTarget()) {
            string = string + this.value.getIdTarget();
        }
        return new JLabel(string);
    }

    private Component createComponent() {
        JComponent jComponent;
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        jPanel.setBorder(BorderFactory.createLineBorder(Color.BLUE, 2));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        if (this.value.getType() == 230 || this.value.getType() == 250) {
            jComponent = new JTextField();
            ((JTextComponent)jComponent).setText(((CustomActionDataControl)this.value).getName());
            ((JTextComponent)jComponent).getDocument().addDocumentListener(new NameChangeListener((JTextComponent)jComponent, (Named)this.value.getContent()));
            jPanel.add((Component)jComponent, gridBagConstraints);
        } else {
            jPanel.add((Component)new JLabel(this.getTypeText(this.value.getType())), gridBagConstraints);
        }
        if (this.value.hasIdTarget()) {
            ++gridBagConstraints.gridy;
            jComponent = new JComboBox();
            jComponent = new JComboBox<String>(this.value.getElementsList());
            ((JComboBox)jComponent).setSelectedItem(this.value.getIdTarget());
            ((JComboBox)jComponent).addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    SmallActionCellRendererEditor.this.value.setIdTarget(((JComboBox)actionEvent.getSource()).getSelectedItem().toString());
                }
            });
            jPanel.add((Component)jComponent, gridBagConstraints);
        }
        if (this.value.getType() == 230 || this.value.getType() == 250) {
            ++gridBagConstraints.gridy;
            jComponent = new JButton(TC.get((String)"SmallAction.Appearence"));
            jComponent.setFocusable(false);
            ((AbstractButton)jComponent).addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    new AppearenceDialog(SmallActionCellRendererEditor.this.value);
                }
            });
            jPanel.add((Component)jComponent, gridBagConstraints);
        }
        ++gridBagConstraints.gridy;
        jComponent = new JButton(TC.get((String)"SmallAction.Conditions"));
        jComponent.setFocusable(false);
        ((AbstractButton)jComponent).addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                new ConditionsDialog(SmallActionCellRendererEditor.this.value.getConditions());
            }
        });
        jPanel.add((Component)jComponent, gridBagConstraints);
        ++gridBagConstraints.gridy;
        JButton jButton = new JButton(TC.get((String)"SmallAction.Effects"));
        jButton.setFocusable(false);
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                new EffectsDialog(SmallActionCellRendererEditor.this.value.getEffects());
            }
        });
        jPanel.add((Component)jButton, gridBagConstraints);
        ++gridBagConstraints.gridy;
        final JCheckBox jCheckBox = new JCheckBox(TC.get((String)"SmallAction.ActiveWhenConditionsArent"));
        jCheckBox.setToolTipText(TC.get((String)"SmallAction.ActiveWhenConditionsArent.ToolTip"));
        final JButton jButton2 = new JButton(TC.get((String)"SmallAction.EditNotEffects"));
        jCheckBox.setSelected(this.value.isActivatedNotEffects());
        jCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SmallActionCellRendererEditor.this.value.setActivatedNotEffects(jCheckBox.isSelected());
                jButton2.setEnabled(jCheckBox.isSelected());
            }
        });
        jCheckBox.setSelected(this.value.isActivatedNotEffects());
        jPanel.add((Component)jCheckBox, gridBagConstraints);
        ++gridBagConstraints.gridy;
        jButton2.setFocusable(false);
        jButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                new EffectsDialog(SmallActionCellRendererEditor.this.value.getNotEffectsController());
            }
        });
        jButton2.setEnabled(jCheckBox.isSelected());
        jPanel.add((Component)jButton2, gridBagConstraints);
        ++gridBagConstraints.gridy;
        final JCheckBox jCheckBox2 = new JCheckBox(TC.get((String)"SmallAction.NeedsGetTo"));
        jCheckBox2.setSelected(this.value.getNeedsGoTo());
        if (Controller.getInstance().isPlayTransparent()) {
            jCheckBox2.setEnabled(false);
        }
        jPanel.add((Component)jCheckBox2, gridBagConstraints);
        ++gridBagConstraints.gridy;
        SpinnerNumberModel spinnerNumberModel = new SpinnerNumberModel(this.value.getKeepDistance(), 0, 100, 5);
        final JSpinner jSpinner = new JSpinner(spinnerNumberModel);
        if (Controller.getInstance().isPlayTransparent()) {
            jSpinner.setEnabled(false);
        }
        jPanel.add((Component)jSpinner, gridBagConstraints);
        jCheckBox2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SmallActionCellRendererEditor.this.value.setNeedsGoTo(jCheckBox2.isSelected());
                jSpinner.setEnabled(jCheckBox2.isSelected());
            }
        });
        jSpinner.setEnabled(this.value.getNeedsGoTo());
        jSpinner.addChangeListener(new KeepDistanceSpinnerListener(jSpinner));
        return jPanel;
    }

    private String getTypeText(int n) {
        String string = "";
        switch (n) {
            case 21: {
                string = TC.get((String)"ActionsList.ExamineAction");
                break;
            }
            case 22: {
                string = TC.get((String)"ActionsList.GrabAction");
                break;
            }
            case 23: {
                string = TC.get((String)"ActionsList.UseAction");
                break;
            }
            case 230: {
                string = ((CustomActionDataControl)this.value).getName();
                break;
            }
            case 24: {
                string = TC.get((String)"ActionsList.UseWithAction", (String)"");
                break;
            }
            case 25: {
                string = TC.get((String)"ActionsList.GiveToAction", (String)"");
                break;
            }
            case 250: {
                string = ((CustomActionDataControl)this.value).getName() + ": ";
                break;
            }
            case 231: {
                string = TC.get((String)"ActionsList.TalkToAction");
            }
        }
        return string;
    }

    private class KeepDistanceSpinnerListener
    implements ChangeListener {
        private JSpinner spinner;

        public KeepDistanceSpinnerListener(JSpinner jSpinner) {
            this.spinner = jSpinner;
        }

        @Override
        public void stateChanged(ChangeEvent changeEvent) {
            SmallActionCellRendererEditor.this.value.setKeepDistance((Integer)this.spinner.getModel().getValue());
        }
    }
}

