/*
 * Decompiled with CFR 0.152.
 */
package es.eucm.eadventure.editor.gui.elementpanels.general.tables;

import es.eucm.eadventure.common.gui.TC;
import es.eucm.eadventure.editor.control.Controller;
import es.eucm.eadventure.editor.control.controllers.DataControlWithResources;
import es.eucm.eadventure.editor.control.tools.structurepanel.RenameElementTool;
import es.eucm.eadventure.editor.gui.elementpanels.general.LooksPanel;
import es.eucm.eadventure.editor.gui.elementpanels.general.tables.ConditionsCellRendererEditor;
import es.eucm.eadventure.editor.gui.elementpanels.general.tables.InfoHeaderRenderer;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;

public class ResourcesTable
extends JTable {
    private static final long serialVersionUID = 1L;
    protected DataControlWithResources dataControl;
    protected LooksPanel looksPanel;

    public ResourcesTable(DataControlWithResources dataControlWithResources, LooksPanel looksPanel) {
        this.looksPanel = looksPanel;
        this.dataControl = dataControlWithResources;
        this.setModel(new ElementsTableModel());
        this.getColumnModel().setColumnSelectionAllowed(false);
        this.setDragEnabled(false);
        this.getColumnModel().getColumn(0).setHeaderRenderer(new InfoHeaderRenderer("general/Appearence.html"));
        this.getColumnModel().getColumn(1).setHeaderRenderer(new InfoHeaderRenderer("general/Conditions.html"));
        this.getColumnModel().getColumn(1).setCellRenderer(new ConditionsCellRendererEditor());
        this.getColumnModel().getColumn(1).setCellEditor(new ConditionsCellRendererEditor());
        this.getSelectionModel().setSelectionMode(0);
        this.setSize(200, 150);
    }

    public void resetModel() {
        this.setModel(new ElementsTableModel());
        this.getColumnModel().getColumn(0).setHeaderRenderer(new InfoHeaderRenderer("general/Appearence.html"));
        this.getColumnModel().getColumn(1).setHeaderRenderer(new InfoHeaderRenderer("general/Conditions.html"));
        this.getColumnModel().getColumn(1).setCellRenderer(new ConditionsCellRendererEditor());
        this.getColumnModel().getColumn(1).setCellEditor(new ConditionsCellRendererEditor());
        this.getSelectionModel().setSelectionMode(0);
        ((AbstractTableModel)this.getModel()).fireTableDataChanged();
    }

    public int getSelectedIndex() {
        return this.getSelectedRow();
    }

    public void setSelectedIndex(int n) {
        this.getSelectionModel().setSelectionInterval(n, n);
    }

    private class ElementsTableModel
    extends AbstractTableModel {
        private static final long serialVersionUID = 1L;

        private ElementsTableModel() {
        }

        @Override
        public int getColumnCount() {
            return 2;
        }

        @Override
        public int getRowCount() {
            return ResourcesTable.this.dataControl.getResourcesCount();
        }

        @Override
        public Object getValueAt(int n, int n2) {
            if (n2 == 0) {
                String string = ResourcesTable.this.dataControl.getResources().get(n).getName();
                if (string == null || string.equals("")) {
                    string = "No name";
                }
                if (ResourcesTable.this.getSelectedRow() != n) {
                    return TC.get((String)"ResourcesList.ResourcesBlockNumber") + (n + 1) + ": " + string;
                }
                return string;
            }
            if (n2 == 1) {
                if (ResourcesTable.this.dataControl.getResources().size() == 1) {
                    return null;
                }
                return ResourcesTable.this.dataControl.getResources().get(n).getConditions();
            }
            return null;
        }

        @Override
        public String getColumnName(int n) {
            if (n == 0) {
                return TC.get((String)"ResourcesList.ResourcesBlock");
            }
            if (n == 1) {
                return TC.get((String)"ResourcesList.Conditions");
            }
            return "";
        }

        @Override
        public void setValueAt(Object object, int n, int n2) {
            if (n2 == 0) {
                Controller.getInstance().addTool(new RenameElementTool(ResourcesTable.this.dataControl.getResources().get(n), (String)object));
            }
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            return ResourcesTable.this.getSelectedRow() == n;
        }
    }
}

