/*
 * Decompiled with CFR 0.152.
 */
package es.eucm.eadventure.editor.gui.elementpanels.general.tables;

import es.eucm.eadventure.common.gui.TC;
import es.eucm.eadventure.editor.control.controllers.AssetsController;
import es.eucm.eadventure.editor.control.controllers.DataControl;
import es.eucm.eadventure.editor.gui.structurepanel.StructureControl;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractCellEditor;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;

public abstract class ResizeableCellRenderer
extends AbstractCellEditor
implements TableCellEditor,
TableCellRenderer {
    private static final long serialVersionUID = 8128260157985286632L;
    protected DataControl value;
    private int size = 1;
    protected String name;
    protected Image image;

    protected JPanel createPanel() {
        int n;
        if (this.image == null) {
            this.image = AssetsController.getImage("img/assets/EmptyImage.png");
        }
        if (this.size == 2 && this.image.getHeight(null) > 160) {
            n = (int)((double)((float)this.image.getWidth(null) / (float)this.image.getHeight(null)) * 160.0);
            this.image = this.image.getScaledInstance(n, 160, 2);
        }
        if (this.size == 1 && this.image.getHeight(null) > 60) {
            n = (int)((double)((float)this.image.getWidth(null) / (float)this.image.getHeight(null)) * 60.0);
            this.image = this.image.getScaledInstance(n, 60, 2);
        }
        ImageIcon imageIcon = new ImageIcon(this.image);
        JButton jButton = new JButton(TC.get((String)"GeneralText.Edit"));
        jButton.addActionListener(new EditButtonActionListener(this.value));
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        if (this.size == 1 || this.size == 2) {
            jPanel.add((Component)new JLabel(this.name), "North");
            jPanel.add((Component)new JLabel(imageIcon), "Center");
            jPanel.add((Component)jButton, "South");
        } else if (this.size == 0) {
            jPanel.add((Component)new JLabel(this.name), "Center");
            jPanel.add((Component)jButton, "East");
        }
        jPanel.setBackground(Color.WHITE);
        return jPanel;
    }

    @Override
    public Object getCellEditorValue() {
        return null;
    }

    public void setSize(int n) {
        this.size = n;
    }

    public int getSize() {
        return this.size;
    }

    private class EditButtonActionListener
    implements ActionListener {
        private DataControl dataControl;

        public EditButtonActionListener(DataControl dataControl) {
            this.dataControl = dataControl;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            StructureControl.getInstance().changeDataControl(this.dataControl);
        }
    }
}

