/*
 * Decompiled with CFR 0.152.
 */
package es.eucm.eadventure.editor.gui.elementpanels.general.tables;

import es.eucm.eadventure.editor.control.controllers.DataControl;
import java.util.List;
import javax.swing.table.AbstractTableModel;

public class ResizableTableModel
extends AbstractTableModel {
    private static final long serialVersionUID = 1L;
    private List<DataControl> list;
    private int size = 1;

    public ResizableTableModel(List<DataControl> list, int n) {
        this.list = list;
        this.size = n;
    }

    @Override
    public int getColumnCount() {
        if (this.size == 0) {
            return 1;
        }
        if (this.size == 1) {
            return 4;
        }
        if (this.size == 2) {
            return 2;
        }
        return 2;
    }

    @Override
    public int getRowCount() {
        if (this.size == 0) {
            return this.list.size();
        }
        if (this.size == 1) {
            return this.list.size() / 4 + (this.list.size() % 4 > 0 ? 1 : 0);
        }
        if (this.size == 2) {
            return this.list.size() / 2 + this.list.size() % 2;
        }
        return 0;
    }

    @Override
    public Object getValueAt(int n, int n2) {
        if (this.size == 2 && n * 2 + n2 < this.list.size()) {
            return this.list.get(n * 2 + n2);
        }
        if (this.size == 1 && n * 4 + n2 < this.list.size()) {
            return this.list.get(n * 4 + n2);
        }
        if (this.size == 0) {
            return this.list.get(n);
        }
        return null;
    }

    @Override
    public boolean isCellEditable(int n, int n2) {
        return true;
    }

    public void setSize(int n) {
        this.size = n;
    }
}

