/*
 * Decompiled with CFR 0.152.
 */
package es.eucm.eadventure.editor.gui.elementpanels.general.tables;

import es.eucm.eadventure.common.gui.TC;
import es.eucm.eadventure.editor.control.Controller;
import es.eucm.eadventure.editor.control.controllers.scene.ExitDataControl;
import es.eucm.eadventure.editor.gui.editdialogs.PlayerPositionDialog;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractCellEditor;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;

public class NextSceneCellRendererEditor
extends AbstractCellEditor
implements TableCellEditor,
TableCellRenderer {
    private static final long serialVersionUID = 4870491701696223525L;
    private Object[] items;
    private Object selectedItem;
    private JComboBox combo;
    private ExitDataControl exit;
    private JButton editPosition;
    private JCheckBox hasPosition;

    public NextSceneCellRendererEditor(Object[] objectArray) {
        this.items = objectArray;
    }

    @Override
    public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
        this.exit = (ExitDataControl)object;
        this.selectedItem = this.exit.getNextSceneId();
        return this.comboPanel(jTable);
    }

    @Override
    public Object getCellEditorValue() {
        return this.exit;
    }

    @Override
    public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
        this.exit = (ExitDataControl)object;
        this.selectedItem = this.exit.getNextSceneId();
        if (!bl) {
            return new JLabel((String)this.selectedItem);
        }
        return this.comboPanel(jTable);
    }

    private JPanel comboPanel(JTable jTable) {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        this.combo = new JComboBox<Object>(this.items);
        this.combo.setSelectedItem(this.selectedItem);
        this.combo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                NextSceneCellRendererEditor.this.selectedItem = NextSceneCellRendererEditor.this.combo.getSelectedItem();
                NextSceneCellRendererEditor.this.exit.setNextSceneId((String)NextSceneCellRendererEditor.this.selectedItem);
                if (NextSceneCellRendererEditor.this.hasPosition != null && NextSceneCellRendererEditor.this.editPosition != null) {
                    NextSceneCellRendererEditor.this.hasPosition.setEnabled(Controller.getInstance().getIdentifierSummary().isScene(NextSceneCellRendererEditor.this.exit.getNextSceneId()));
                    NextSceneCellRendererEditor.this.editPosition.setEnabled(NextSceneCellRendererEditor.this.hasPosition.isEnabled() && NextSceneCellRendererEditor.this.exit.hasDestinyPosition());
                    NextSceneCellRendererEditor.this.hasPosition.setSelected(NextSceneCellRendererEditor.this.exit.hasDestinyPosition());
                }
            }
        });
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 2.0;
        gridBagConstraints.fill = 2;
        jPanel.add((Component)this.combo, gridBagConstraints);
        if (!Controller.getInstance().isPlayTransparent()) {
            this.hasPosition = new JCheckBox(TC.get((String)"NextSceneCell.UsePosition"));
            this.hasPosition.addActionListener(new DestinyPositionCheckBoxListener());
            this.hasPosition.setEnabled(Controller.getInstance().getIdentifierSummary().isScene(this.exit.getNextSceneId()));
            this.hasPosition.setSelected(this.exit.hasDestinyPosition());
            this.editPosition = new JButton(TC.get((String)"NextSceneCell.EditDestinyPosition"));
            this.editPosition.addActionListener(new DestinyPositionButtonListener());
            this.editPosition.setEnabled(this.hasPosition.isEnabled() && this.exit.hasDestinyPosition());
            ++gridBagConstraints.gridy;
            jPanel.add((Component)this.hasPosition, gridBagConstraints);
            ++gridBagConstraints.gridy;
            jPanel.add((Component)this.editPosition, gridBagConstraints);
        }
        jPanel.setBorder(BorderFactory.createMatteBorder(2, 2, 2, 0, jTable.getSelectionBackground()));
        return jPanel;
    }

    private class DestinyPositionCheckBoxListener
    implements ActionListener {
        private DestinyPositionCheckBoxListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            NextSceneCellRendererEditor.this.exit.toggleDestinyPosition();
            NextSceneCellRendererEditor.this.editPosition.setEnabled(NextSceneCellRendererEditor.this.exit.hasDestinyPosition());
        }
    }

    private class DestinyPositionButtonListener
    implements ActionListener {
        private DestinyPositionButtonListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            PlayerPositionDialog playerPositionDialog = new PlayerPositionDialog(NextSceneCellRendererEditor.this.selectedItem.toString(), NextSceneCellRendererEditor.this.exit.getDestinyPositionX(), NextSceneCellRendererEditor.this.exit.getDestinyPositionY());
            NextSceneCellRendererEditor.this.exit.setDestinyPosition(playerPositionDialog.getPositionX(), playerPositionDialog.getPositionY());
        }
    }
}

