/*
 * Decompiled with CFR 0.152.
 */
package es.eucm.eadventure.editor.gui.elementpanels.general.tables;

import es.eucm.eadventure.editor.gui.editdialogs.HelpDialog;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;

public class InfoHeaderRenderer
extends JPanel
implements TableCellRenderer {
    private static final long serialVersionUID = 3777807533524838812L;
    private JButton infoButton;
    private MouseListener old = null;
    private String helpPath;

    public InfoHeaderRenderer() {
        this((String)null);
    }

    public InfoHeaderRenderer(String string) {
        this.helpPath = string;
        this.setLayout(new GridBagLayout());
    }

    @Override
    public Component getTableCellRendererComponent(final JTable jTable, Object object, boolean bl, boolean bl2, int n, final int n2) {
        this.removeAll();
        this.setBorder(BorderFactory.createMatteBorder(0, 0, 1, 1, Color.DARK_GRAY));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        JLabel jLabel = new JLabel(object.toString());
        jLabel.setFont(jLabel.getFont().deriveFont(1));
        this.add((Component)jLabel, gridBagConstraints);
        if (this.helpPath != null) {
            this.infoButton = new JButton(new ImageIcon("img/icons/information.png"));
            this.infoButton.setContentAreaFilled(false);
            this.infoButton.setMargin(new Insets(0, 0, 0, 0));
            this.infoButton.setBorder(BorderFactory.createEmptyBorder());
            gridBagConstraints.gridx = 1;
            this.add((Component)this.infoButton, gridBagConstraints);
            JTableHeader jTableHeader = jTable.getTableHeader();
            if (this.old != null) {
                jTableHeader.removeMouseListener(this.old);
            }
            this.old = new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent mouseEvent) {
                    int n = mouseEvent.getX();
                    int n22 = mouseEvent.getY();
                    n -= InfoHeaderRenderer.this.infoButton.getX();
                    n22 -= InfoHeaderRenderer.this.infoButton.getY();
                    for (int i = 0; i < n2; ++i) {
                        n -= jTable.getColumnModel().getColumn(i).getWidth();
                    }
                    if (InfoHeaderRenderer.this.infoButton.contains(n, n22)) {
                        new HelpDialog(InfoHeaderRenderer.this.helpPath);
                    }
                }
            };
            jTableHeader.addMouseListener(this.old);
        }
        return this;
    }
}

