/*
 * Decompiled with CFR 0.152.
 */
package es.eucm.eadventure.editor.gui.elementpanels.general.tables;

import es.eucm.eadventure.common.gui.TC;
import es.eucm.eadventure.editor.control.Controller;
import es.eucm.eadventure.editor.control.controllers.AssetsController;
import es.eucm.eadventure.editor.control.controllers.general.ExitLookDataControl;
import es.eucm.eadventure.editor.control.tools.generic.ChangeStringValueTool;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractButton;
import javax.swing.AbstractCellEditor;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;

public class ExitLooksCellRendererEditor
extends AbstractCellEditor
implements TableCellEditor,
TableCellRenderer {
    private static final long serialVersionUID = 8128260157985286632L;
    private ExitLookDataControl value;
    private JLabel label = null;
    private String tooltip;
    private JPanel panel;
    private GridBagConstraints c;

    @Override
    public Object getCellEditorValue() {
        return this.value;
    }

    @Override
    public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
        this.value = object != null ? (ExitLookDataControl)object : null;
        return this.newPanel(bl, jTable);
    }

    @Override
    public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
        if (!bl) {
            if (object != null) {
                this.value = (ExitLookDataControl)object;
                String string = this.value.getCustomizedText() != null ? this.value.getCustomizedText() : "";
                ImageIcon imageIcon = new ImageIcon();
                if (this.value.isCursorCustomized()) {
                    Image image = AssetsController.getImage(this.value.getCustomizedCursor());
                    imageIcon.setImage(image);
                } else {
                    Image image = AssetsController.getImage(Controller.getInstance().getDefaultExitCursorPath());
                    imageIcon.setImage(image);
                }
                return new JLabel(string, imageIcon, 2);
            }
            this.value = null;
            return new JLabel("");
        }
        this.value = object != null ? (ExitLookDataControl)object : null;
        return this.newPanel(bl, jTable);
    }

    private JPanel newPanel(boolean bl, JTable jTable) {
        Object object;
        this.panel = new JPanel();
        this.panel.setLayout(new GridBagLayout());
        this.c = new GridBagConstraints();
        final JTextField jTextField = new JTextField();
        jTextField.setText(this.value.getCustomizedText() != null ? this.value.getCustomizedText() : "");
        jTextField.setEnabled(bl);
        jTextField.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent documentEvent) {
            }

            @Override
            public void insertUpdate(DocumentEvent documentEvent) {
                ChangeStringValueTool changeStringValueTool = new ChangeStringValueTool(ExitLooksCellRendererEditor.this.value, jTextField.getText(), "getCustomizedText", "setExitText");
                Controller.getInstance().addTool(changeStringValueTool);
            }

            @Override
            public void removeUpdate(DocumentEvent documentEvent) {
                ChangeStringValueTool changeStringValueTool = new ChangeStringValueTool(ExitLooksCellRendererEditor.this.value, jTextField.getText(), "getCustomizedText", "setExitText");
                Controller.getInstance().addTool(changeStringValueTool);
            }
        });
        ImageIcon imageIcon = new ImageIcon("img/icons/deleteContent.png");
        JButton jButton = new JButton(imageIcon);
        jButton.setPreferredSize(new Dimension(20, 20));
        jButton.setMaximumSize(new Dimension(20, 20));
        jButton.setToolTipText(TC.get((String)"Resources.DeleteAsset"));
        ImageIcon imageIcon2 = new ImageIcon();
        if (this.value.isCursorCustomized()) {
            object = AssetsController.getImage(this.value.getCustomizedCursor());
            this.tooltip = this.value.getCustomizedCursor();
            imageIcon2.setImage((Image)object);
        } else {
            object = AssetsController.getImage(Controller.getInstance().getDefaultExitCursorPath());
            this.tooltip = Controller.getInstance().getDefaultExitCursorPath();
            imageIcon2.setImage((Image)object);
        }
        object = new JButton(TC.get((String)"Buttons.Select"));
        ((Component)object).setFocusable(false);
        ((AbstractButton)object).addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ExitLooksCellRendererEditor.this.value.editCursorPath();
                ImageIcon imageIcon = new ImageIcon();
                Image image = AssetsController.getImage(ExitLooksCellRendererEditor.this.value.getCustomizedCursor());
                ExitLooksCellRendererEditor.this.tooltip = ExitLooksCellRendererEditor.this.value.getCustomizedCursor();
                imageIcon.setImage(image);
                ExitLooksCellRendererEditor.this.panel.remove(ExitLooksCellRendererEditor.this.label);
                ExitLooksCellRendererEditor.this.label = new JLabel(imageIcon);
                ExitLooksCellRendererEditor.this.panel.add((Component)ExitLooksCellRendererEditor.this.label, ExitLooksCellRendererEditor.this.c);
                ExitLooksCellRendererEditor.this.panel.validate();
            }
        });
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (ExitLooksCellRendererEditor.this.value.isCursorCustomized()) {
                    Controller.getInstance().addTool(new ChangeStringValueTool(ExitLooksCellRendererEditor.this.value, null, "getCustomizedCursor", "setCursorPath"));
                    Image image = AssetsController.getImage(Controller.getInstance().getDefaultExitCursorPath());
                    ExitLooksCellRendererEditor.this.tooltip = Controller.getInstance().getDefaultExitCursorPath();
                    ImageIcon imageIcon = new ImageIcon(image);
                    ExitLooksCellRendererEditor.this.panel.remove(ExitLooksCellRendererEditor.this.label);
                    ExitLooksCellRendererEditor.this.label = new JLabel(imageIcon);
                    ExitLooksCellRendererEditor.this.panel.add((Component)ExitLooksCellRendererEditor.this.label, ExitLooksCellRendererEditor.this.c);
                    ExitLooksCellRendererEditor.this.panel.validate();
                }
            }
        });
        this.c.gridx = 0;
        this.c.gridy = 0;
        this.panel.add((Component)object, this.c);
        this.c.gridx = 2;
        this.panel.add((Component)jButton, this.c);
        this.c.gridx = 1;
        this.c.weightx = 2.0;
        this.c.weighty = 2.0;
        this.c.fill = 1;
        this.label = new JLabel(imageIcon2);
        this.label.setToolTipText(this.tooltip);
        this.panel.add((Component)this.label, this.c);
        this.panel.validate();
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        jPanel.add((Component)jTextField, "North");
        jPanel.add((Component)this.panel, "Center");
        jPanel.setBorder(BorderFactory.createMatteBorder(2, 0, 2, 0, jTable.getSelectionBackground()));
        return jPanel;
    }
}

