/*
 * Decompiled with CFR 0.152.
 */
package es.eucm.eadventure.editor.gui.elementpanels.general.tables;

import es.eucm.eadventure.common.gui.TC;
import es.eucm.eadventure.editor.control.controllers.ConditionsController;
import es.eucm.eadventure.editor.gui.editdialogs.ConditionsDialog;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractCellEditor;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;

public class ConditionsCellRendererEditor
extends AbstractCellEditor
implements TableCellEditor,
TableCellRenderer {
    private static final long serialVersionUID = 8128260157985286632L;
    public static final int NO_ICON = 0;
    public static final int ICON_SMALL = 1;
    public static final int ICON_MEDIUM = 2;
    public static final int ICON_LARGE = 3;
    private boolean useText;
    private int iconSize;
    private ConditionsController value;

    public ConditionsCellRendererEditor() {
        this.useText = false;
        this.iconSize = 1;
    }

    public ConditionsCellRendererEditor(boolean bl, int n) {
        this.useText = bl;
        this.iconSize = n;
    }

    @Override
    public Object getCellEditorValue() {
        return this.value;
    }

    @Override
    public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
        if (object == null) {
            return null;
        }
        this.value = (ConditionsController)object;
        return this.createButton(bl, jTable);
    }

    @Override
    public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
        if (object == null) {
            return null;
        }
        this.value = (ConditionsController)object;
        return this.createButton(bl, jTable);
    }

    private Icon createIcon() {
        ImageIcon imageIcon = null;
        boolean bl = false;
        if (this.value != null) {
            ConditionsController conditionsController = this.value;
            boolean bl2 = bl = !conditionsController.isEmpty();
        }
        if (this.iconSize == 1) {
            imageIcon = bl ? new ImageIcon("img/icons/conditions-16x16.png") : new ImageIcon("img/icons/no-conditions-16x16.png");
        }
        if (this.iconSize == 2) {
            imageIcon = bl ? new ImageIcon("img/icons/conditions-24x24.png") : new ImageIcon("img/icons/no-conditions-24x24.png");
        }
        if (this.iconSize == 3) {
            imageIcon = bl ? new ImageIcon("img/icons/conditions-32x32.png") : new ImageIcon("img/icons/no-conditions-32x32.png");
        }
        return imageIcon;
    }

    private Component createButton(boolean bl, JTable jTable) {
        JPanel jPanel = new JPanel();
        jPanel.setOpaque(false);
        if (bl) {
            jPanel.setBorder(BorderFactory.createMatteBorder(2, 0, 2, 0, jTable.getSelectionBackground()));
        }
        JButton jButton = null;
        String string = null;
        if (this.useText) {
            string = TC.get((String)"GeneralText.EditConditions");
        }
        Icon icon = this.createIcon();
        if (string != null && icon != null) {
            jButton = new JButton(string, icon);
            jButton.setToolTipText(string);
        } else if (string != null) {
            jButton = new JButton(string);
            jButton.setToolTipText(string);
        } else if (icon != null) {
            jButton = new JButton(icon);
            jButton.setContentAreaFilled(false);
            jButton.setOpaque(false);
        }
        jButton.setFocusable(false);
        jButton.setEnabled(bl);
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                new ConditionsDialog(ConditionsCellRendererEditor.this.value);
                ((JButton)actionEvent.getSource()).setIcon(ConditionsCellRendererEditor.this.createIcon());
            }
        });
        jPanel.setLayout(new BorderLayout());
        jPanel.add((Component)jButton, "Center");
        return jPanel;
    }
}

