/*
 * Decompiled with CFR 0.152.
 */
package es.eucm.eadventure.editor.gui.elementpanels.general.tables;

import es.eucm.eadventure.common.gui.TC;
import es.eucm.eadventure.editor.control.Controller;
import es.eucm.eadventure.editor.control.controllers.general.ActionDataControl;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractCellEditor;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.JTable;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;

public class ActionDetailsCellRendererEditor
extends AbstractCellEditor
implements TableCellEditor,
TableCellRenderer {
    private static final long serialVersionUID = 8128260157985286632L;
    private ActionDataControl value;

    @Override
    public Object getCellEditorValue() {
        return this.value;
    }

    @Override
    public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
        this.value = (ActionDataControl)object;
        return this.createComponent(bl, jTable);
    }

    @Override
    public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
        this.value = (ActionDataControl)object;
        return this.createComponent(bl, jTable);
    }

    private Component createComponent(boolean bl, JTable jTable) {
        JPanel jPanel = new JPanel();
        jPanel.setBackground(jTable.getBackground());
        if (bl) {
            jPanel.setBorder(BorderFactory.createMatteBorder(2, 0, 2, 0, jTable.getSelectionBackground()));
        }
        jPanel.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        SpinnerNumberModel spinnerNumberModel = new SpinnerNumberModel(this.value.getKeepDistance(), 0, 100, 5);
        final JSpinner jSpinner = new JSpinner(spinnerNumberModel);
        final JCheckBox jCheckBox = new JCheckBox("");
        jCheckBox.setSelected(this.value.getNeedsGoTo());
        jCheckBox.setOpaque(false);
        jCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ActionDetailsCellRendererEditor.this.value.setNeedsGoTo(jCheckBox.isSelected());
                jSpinner.setEnabled(jCheckBox.isSelected());
            }
        });
        jPanel.add((Component)jCheckBox, gridBagConstraints);
        ++gridBagConstraints.gridx;
        if (bl) {
            jSpinner.setEnabled(this.value.getNeedsGoTo());
            jSpinner.addChangeListener(new KeepDistanceSpinnerListener(jSpinner));
            jPanel.add((Component)jSpinner, gridBagConstraints);
        } else {
            jPanel.add((Component)new JLabel("" + this.value.getKeepDistance()), gridBagConstraints);
        }
        if (Controller.getInstance().isPlayTransparent()) {
            jPanel.removeAll();
            jPanel.add(new JLabel(TC.get((String)"ActionsList.NotRelevant")));
        }
        return jPanel;
    }

    private class KeepDistanceSpinnerListener
    implements ChangeListener {
        private JSpinner spinner;

        public KeepDistanceSpinnerListener(JSpinner jSpinner) {
            this.spinner = jSpinner;
        }

        @Override
        public void stateChanged(ChangeEvent changeEvent) {
            ActionDetailsCellRendererEditor.this.value.setKeepDistance((Integer)this.spinner.getModel().getValue());
        }
    }
}

