/*
 * Decompiled with CFR 0.152.
 */
package es.eucm.eadventure.editor.gui.elementpanels.general.tables;

import es.eucm.eadventure.common.data.Named;
import es.eucm.eadventure.common.gui.TC;
import es.eucm.eadventure.editor.control.controllers.general.ActionDataControl;
import es.eucm.eadventure.editor.control.controllers.general.CustomActionDataControl;
import es.eucm.eadventure.editor.control.tools.listeners.NameChangeListener;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractCellEditor;
import javax.swing.BorderFactory;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.text.JTextComponent;

public class ActionCellRendererEditor
extends AbstractCellEditor
implements TableCellEditor,
TableCellRenderer {
    private static final long serialVersionUID = 8128260157985286632L;
    private ActionDataControl value;

    @Override
    public Object getCellEditorValue() {
        return this.value;
    }

    @Override
    public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
        this.value = (ActionDataControl)object;
        return this.createComponent(bl, jTable);
    }

    @Override
    public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
        this.value = (ActionDataControl)object;
        if (jTable.getSelectedRow() == n) {
            return this.createComponent(bl, jTable);
        }
        String string = this.getTypeText(this.value.getType());
        if (this.value.hasIdTarget()) {
            string = string + this.value.getIdTarget();
        }
        return new JLabel(string);
    }

    private Component createComponent(boolean bl, JTable jTable) {
        JComponent jComponent;
        JPanel jPanel = new JPanel();
        jPanel.setBackground(jTable.getBackground());
        if (bl) {
            jPanel.setBorder(BorderFactory.createMatteBorder(2, 2, 2, 0, jTable.getSelectionBackground()));
        }
        if (!this.value.hasIdTarget() && this.value.getType() != 230) {
            jPanel.setLayout(new BorderLayout());
            jPanel.add((Component)new JLabel(this.getTypeText(this.value.getType())), "Center");
            return jPanel;
        }
        jPanel.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        if (this.value.getType() == 230 || this.value.getType() == 250) {
            jComponent = new JTextField();
            ((JTextComponent)jComponent).setText(((CustomActionDataControl)this.value).getName());
            ((JTextComponent)jComponent).getDocument().addDocumentListener(new NameChangeListener((JTextComponent)jComponent, (Named)this.value.getContent()));
            jPanel.add((Component)jComponent, gridBagConstraints);
        } else {
            jPanel.add((Component)new JLabel(this.getTypeText(this.value.getType())), gridBagConstraints);
        }
        ++gridBagConstraints.gridy;
        if (this.value.hasIdTarget()) {
            jComponent = new JComboBox();
            jComponent = new JComboBox<String>(this.value.getElementsList());
            ((JComboBox)jComponent).setSelectedItem(this.value.getIdTarget());
            jComponent.setFocusable(false);
            ((JComboBox)jComponent).addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    ActionCellRendererEditor.this.value.setIdTarget(((JComboBox)actionEvent.getSource()).getSelectedItem().toString());
                }
            });
            jPanel.add((Component)jComponent, gridBagConstraints);
        }
        return jPanel;
    }

    private String getTypeText(int n) {
        String string = "";
        switch (n) {
            case 21: {
                string = TC.get((String)"ActionsList.ExamineAction");
                break;
            }
            case 22: {
                string = TC.get((String)"ActionsList.GrabAction");
                break;
            }
            case 23: {
                string = TC.get((String)"ActionsList.UseAction");
                break;
            }
            case 230: {
                string = ((CustomActionDataControl)this.value).getName();
                break;
            }
            case 24: {
                string = TC.get((String)"ActionsList.UseWithAction", (String)"");
                break;
            }
            case 25: {
                string = TC.get((String)"ActionsList.GiveToAction", (String)"");
                break;
            }
            case 250: {
                string = ((CustomActionDataControl)this.value).getName() + ": ";
                break;
            }
            case 231: {
                string = TC.get((String)"ActionsList.TalkToAction");
                break;
            }
            case 251: {
                string = TC.get((String)"ActionsList.DragToAction", (String)"");
            }
        }
        return string;
    }
}

