/*
 * Decompiled with CFR 0.152.
 */
package es.eucm.eadventure.editor.gui.elementpanels.general;

import es.eucm.eadventure.common.gui.TC;
import es.eucm.eadventure.editor.control.controllers.general.ActionsListDataControl;
import es.eucm.eadventure.editor.gui.Updateable;
import es.eucm.eadventure.editor.gui.elementpanels.general.ActionsListPanel;
import es.eucm.eadventure.editor.gui.elementpanels.general.tables.SmallActionsTable;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;

public class SmallActionsListPanel
extends ActionsListPanel
implements Updateable {
    private static final long serialVersionUID = 1L;

    public SmallActionsListPanel(ActionsListDataControl actionsListDataControl) {
        super(actionsListDataControl);
        this.dataControl = actionsListDataControl;
        this.setLayout(new BorderLayout());
        this.table = new SmallActionsTable(this.dataControl);
        this.table.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                SmallActionsListPanel.this.updateSelectedAction();
            }
        });
        this.add((Component)new JScrollPane(this.table, 22, 31), "Center");
        JPanel jPanel = new JPanel();
        JButton jButton = new JButton(new ImageIcon("img/icons/addNode.png"));
        jButton.setContentAreaFilled(false);
        jButton.setMargin(new Insets(0, 0, 0, 0));
        jButton.setBorder(BorderFactory.createEmptyBorder());
        jButton.setToolTipText(TC.get((String)"ItemReferenceTable.AddParagraph"));
        jButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                JPopupMenu jPopupMenu = SmallActionsListPanel.this.getAddChildPopupMenu();
                jPopupMenu.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
            }
        });
        this.deleteButton = new JButton(new ImageIcon("img/icons/deleteNode.png"));
        this.deleteButton.setContentAreaFilled(false);
        this.deleteButton.setMargin(new Insets(0, 0, 0, 0));
        this.deleteButton.setBorder(BorderFactory.createEmptyBorder());
        this.deleteButton.setToolTipText(TC.get((String)"ItemReferenceTable.Delete"));
        this.deleteButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SmallActionsListPanel.this.delete();
            }
        });
        this.deleteButton.setEnabled(false);
        this.moveUpButton = new JButton(new ImageIcon("img/icons/moveNodeUp.png"));
        this.moveUpButton.setContentAreaFilled(false);
        this.moveUpButton.setMargin(new Insets(0, 0, 0, 0));
        this.moveUpButton.setBorder(BorderFactory.createEmptyBorder());
        this.moveUpButton.setToolTipText(TC.get((String)"ItemReferenceTable.MoveUp"));
        this.moveUpButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SmallActionsListPanel.this.moveUp();
            }
        });
        this.moveUpButton.setEnabled(false);
        this.moveDownButton = new JButton(new ImageIcon("img/icons/moveNodeDown.png"));
        this.moveDownButton.setContentAreaFilled(false);
        this.moveDownButton.setMargin(new Insets(0, 0, 0, 0));
        this.moveDownButton.setBorder(BorderFactory.createEmptyBorder());
        this.moveDownButton.setToolTipText(TC.get((String)"ItemReferenceTable.MoveDown"));
        this.moveDownButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SmallActionsListPanel.this.moveDown();
            }
        });
        this.moveDownButton.setEnabled(false);
        jPanel.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        jPanel.add((Component)jButton, gridBagConstraints);
        ++gridBagConstraints.gridx;
        jPanel.add((Component)this.deleteButton, gridBagConstraints);
        ++gridBagConstraints.gridx;
        jPanel.add((Component)this.moveUpButton, gridBagConstraints);
        ++gridBagConstraints.gridx;
        jPanel.add((Component)this.moveDownButton, gridBagConstraints);
        this.add((Component)jPanel, "South");
    }

    private void updateSelectedAction() {
        int n = this.table.getSelectedRow();
        if (n != -1) {
            this.deleteButton.setEnabled(true);
            this.moveUpButton.setEnabled(this.dataControl.getActions().size() > 1 && n > 0);
            this.moveDownButton.setEnabled(this.dataControl.getActions().size() > 1 && n < this.table.getRowCount() - 1);
        } else {
            this.deleteButton.setEnabled(false);
            this.moveUpButton.setEnabled(false);
            this.moveDownButton.setEnabled(false);
        }
    }

    @Override
    public boolean updateFields() {
        int n = this.table.getSelectedRow();
        int n2 = this.table.getRowCount();
        ((AbstractTableModel)this.table.getModel()).fireTableDataChanged();
        if (n2 == this.table.getRowCount() && n != -1) {
            this.table.changeSelection(n, 0, false, false);
            if (this.table.getEditorComponent() != null) {
                this.table.editCellAt(n, this.table.getEditingColumn());
            }
        }
        return true;
    }
}

