/*
 * Decompiled with CFR 0.152.
 */
package es.eucm.eadventure.editor.gui.elementpanels.general;

import es.eucm.eadventure.common.auxiliar.File;
import es.eucm.eadventure.common.data.animation.Animation;
import es.eucm.eadventure.common.data.animation.ImageLoaderFactory;
import es.eucm.eadventure.common.gui.TC;
import es.eucm.eadventure.editor.control.controllers.AssetsController;
import es.eucm.eadventure.editor.control.controllers.EditorImageLoader;
import es.eucm.eadventure.editor.control.controllers.general.ResourcesDataControl;
import es.eucm.eadventure.editor.control.writer.AnimationWriter;
import es.eucm.eadventure.editor.gui.displaydialogs.AnimationDialog;
import es.eucm.eadventure.editor.gui.displaydialogs.AudioDialog;
import es.eucm.eadventure.editor.gui.displaydialogs.EditImageDialog;
import es.eucm.eadventure.editor.gui.displaydialogs.SelectImageDialog;
import es.eucm.eadventure.editor.gui.displaydialogs.SlidesDialog;
import es.eucm.eadventure.editor.gui.displaydialogs.VideoDialog;
import es.eucm.eadventure.editor.gui.editdialogs.animationeditdialog.AnimationEditDialog;
import es.eucm.eadventure.editor.gui.elementpanels.general.LooksPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.geom.AffineTransform;
import java.awt.image.AffineTransformOp;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import javax.imageio.ImageIO;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class ResourcesPanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    private static final int MAX_SPACE = 0;
    private ResourcesDataControl resourcesDataControl;
    private JTextField[] assetFields;
    private JButton[] viewButtons;
    private LooksPanel previewUpdater;
    private GridBagConstraints c;
    List<JPanel> assetPanels;
    private int selectedIndex = 0;

    public ResourcesPanel(ResourcesDataControl resourcesDataControl) {
        this.resourcesDataControl = resourcesDataControl;
        this.assetPanels = new ArrayList<JPanel>();
        int n = resourcesDataControl.getAssetGroupCount();
        if (n == 1) {
            this.createSingleGroupPanel();
        } else {
            this.createMultiGroupPanel();
        }
    }

    public ResourcesPanel(ResourcesDataControl resourcesDataControl, int n) {
        this.selectedIndex = n;
        this.resourcesDataControl = resourcesDataControl;
        this.assetPanels = new ArrayList<JPanel>();
        int n2 = resourcesDataControl.getAssetGroupCount();
        if (n2 == 1) {
            this.createSingleGroupPanel();
        } else {
            this.createMultiGroupPanel();
        }
    }

    private void createMultiGroupPanel() {
        this.setLayout(new GridBagLayout());
        this.c = new GridBagConstraints();
        this.c.insets = new Insets(2, 4, 2, 4);
        this.c.fill = 2;
        this.c.weightx = 1.0;
        this.c.weighty = 0.0;
        this.c.gridy = 0;
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        jPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), TC.get((String)"Resources.ResourcesGroup")));
        final JComboBox<String> jComboBox = new JComboBox<String>();
        for (int i = 0; i < this.resourcesDataControl.getAssetGroupCount(); ++i) {
            jComboBox.addItem(this.resourcesDataControl.getGroupInfo(i));
        }
        jComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ResourcesPanel.this.setSelectedGroup(jComboBox.getSelectedIndex());
            }
        });
        jPanel.add(jComboBox, "Center");
        this.add((Component)jPanel, this.c);
        jComboBox.setSelectedIndex(this.selectedIndex);
        this.setSelectedGroup(this.selectedIndex);
    }

    protected void setSelectedGroup(int n) {
        this.selectedIndex = n;
        ImageIcon imageIcon = new ImageIcon("img/icons/deleteContent.png");
        while (!this.assetPanels.isEmpty()) {
            this.remove(this.assetPanels.get(0));
            this.assetPanels.remove(0);
        }
        int n2 = this.resourcesDataControl.getGroupAssetCount(n);
        this.assetFields = new JTextField[n2];
        this.viewButtons = new JButton[n2];
        this.c.fill = 2;
        this.c.weightx = 1.0;
        this.c.gridy = 2;
        this.c.weighty = 0.0;
        for (int i = 0; i < n2; ++i) {
            int n3 = this.resourcesDataControl.getAssetIndex(n, i);
            JPanel jPanel = new JPanel();
            jPanel.setLayout(new GridBagLayout());
            jPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), this.resourcesDataControl.getAssetDescription(n3)));
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.insets = new Insets(2, 2, 2, 2);
            gridBagConstraints.fill = 0;
            gridBagConstraints.weightx = 0.0;
            gridBagConstraints.weighty = 0.0;
            JButton jButton = new JButton(imageIcon);
            jButton.addActionListener(new DeleteContentButtonListener(n3, i));
            jButton.setPreferredSize(new Dimension(20, 20));
            jButton.setToolTipText(TC.get((String)"Resources.DeleteAsset"));
            jPanel.add((Component)jButton, gridBagConstraints);
            this.assetFields[i] = new JTextField(0);
            this.assetFields[i].setText(this.resourcesDataControl.getAssetPath(n3));
            this.assetFields[i].setEditable(false);
            gridBagConstraints.gridx = 1;
            gridBagConstraints.fill = 2;
            gridBagConstraints.weightx = 1.0;
            jPanel.add((Component)this.assetFields[i], gridBagConstraints);
            JButton jButton2 = new JButton(TC.get((String)"Resources.Select"));
            jButton2.addActionListener(new ExamineButtonListener(n3, i));
            gridBagConstraints.gridx = 2;
            gridBagConstraints.fill = 0;
            gridBagConstraints.weightx = 0.0;
            jPanel.add((Component)jButton2, gridBagConstraints);
            if (this.resourcesDataControl.getAssetCategory(n3) == 1) {
                JButton jButton3 = new JButton(TC.get((String)"Resources.Create") + "/" + TC.get((String)"Resources.Edit"));
                jButton3.addActionListener(new EditButtonListener(n3, i));
                ++gridBagConstraints.gridx;
                jPanel.add(jButton3);
            }
            this.viewButtons[i] = new JButton(this.getPreviewText(n3));
            this.viewButtons[i].setEnabled(this.resourcesDataControl.getAssetPath(n3) != null);
            this.viewButtons[i].addActionListener(new ViewButtonListener(n3));
            ++gridBagConstraints.gridx;
            jPanel.add((Component)this.viewButtons[i], gridBagConstraints);
            ++this.c.gridy;
            this.add((Component)jPanel, this.c);
            this.assetPanels.add(jPanel);
        }
        ++this.c.gridy;
        this.c.fill = 1;
        this.c.weightx = 1.0;
        this.c.weighty = 1.0;
        if (this.previewUpdater != null) {
            this.previewUpdater.updateResources(n);
        }
        this.updateUI();
    }

    private void createSingleGroupPanel() {
        ImageIcon imageIcon = new ImageIcon("img/icons/deleteContent.png");
        this.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(2, 4, 2, 4);
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weighty = 0.0;
        int n = this.resourcesDataControl.getAssetCount();
        this.assetFields = new JTextField[n];
        this.viewButtons = new JButton[n];
        for (int i = 0; i < n; ++i) {
            JButton jButton;
            JPanel jPanel = new JPanel();
            jPanel.setLayout(new GridBagLayout());
            jPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), this.resourcesDataControl.getAssetDescription(i)));
            GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
            gridBagConstraints2.insets = new Insets(2, 2, 2, 2);
            gridBagConstraints2.fill = 0;
            gridBagConstraints2.weightx = 0.0;
            gridBagConstraints2.weighty = 0.0;
            JButton jButton2 = new JButton(imageIcon);
            jButton2.addActionListener(new DeleteContentButtonListener(i, i));
            jButton2.setPreferredSize(new Dimension(20, 20));
            jButton2.setToolTipText(TC.get((String)"Resources.DeleteAsset"));
            jPanel.add((Component)jButton2, gridBagConstraints2);
            this.assetFields[i] = new JTextField(0);
            this.assetFields[i].setText(this.resourcesDataControl.getAssetPath(i));
            this.assetFields[i].setEditable(false);
            gridBagConstraints2.gridx = 1;
            gridBagConstraints2.fill = 2;
            gridBagConstraints2.weightx = 1.0;
            jPanel.add((Component)this.assetFields[i], gridBagConstraints2);
            JButton jButton3 = new JButton(TC.get((String)"Resources.Select"));
            jButton3.addActionListener(new ExamineButtonListener(i, i));
            gridBagConstraints2.gridx = 2;
            gridBagConstraints2.fill = 0;
            gridBagConstraints2.weightx = 0.0;
            jPanel.add((Component)jButton3, gridBagConstraints2);
            if (this.resourcesDataControl.getAssetCategory(i) == 1) {
                jButton = new JButton(TC.get((String)"Resources.Create") + "/" + TC.get((String)"Resources.Edit"));
                jButton.addActionListener(new EditButtonListener(i, i));
                ++gridBagConstraints2.gridx;
                jPanel.add((Component)jButton, gridBagConstraints2);
            } else if (this.resourcesDataControl.isIconFromImage(i)) {
                jButton = new JButton(TC.get((String)"Resources.CreateIcon"));
                jButton.addActionListener(new CreateIconButtonListener(i));
                ++gridBagConstraints2.gridx;
                jPanel.add((Component)jButton, gridBagConstraints2);
            }
            this.viewButtons[i] = new JButton(this.getPreviewText(i));
            this.viewButtons[i].setEnabled(this.resourcesDataControl.getAssetPath(i) != null);
            this.viewButtons[i].addActionListener(new ViewButtonListener(i));
            ++gridBagConstraints2.gridx;
            jPanel.add((Component)this.viewButtons[i], gridBagConstraints2);
            ++gridBagConstraints.gridy;
            this.add((Component)jPanel, gridBagConstraints);
        }
        ++gridBagConstraints.gridy;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
    }

    private String getPreviewText(int n) {
        String string = null;
        switch (this.resourcesDataControl.getAssetCategory(n)) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 9: 
            case 11: {
                string = TC.get((String)"Resources.ViewAsset");
                break;
            }
            case 4: {
                string = TC.get((String)"Resources.PlayAsset");
                break;
            }
            case 5: {
                string = TC.get((String)"Resources.PlayVideoAsset");
            }
        }
        return string;
    }

    public LooksPanel getPreviewUpdater() {
        return this.previewUpdater;
    }

    public void setPreviewUpdater(LooksPanel looksPanel) {
        this.previewUpdater = looksPanel;
    }

    public int getSelectedIndex() {
        return this.selectedIndex;
    }

    private class ViewButtonListener
    implements ActionListener {
        private int assetIndex;

        public ViewButtonListener(int n) {
            this.assetIndex = n;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            int n = ResourcesPanel.this.resourcesDataControl.getAssetCategory(this.assetIndex);
            String string = ResourcesPanel.this.resourcesDataControl.getAssetPath(this.assetIndex);
            switch (n) {
                case 0: 
                case 2: 
                case 3: 
                case 9: 
                case 11: {
                    new EditImageDialog(ResourcesPanel.this.resourcesDataControl, this.assetIndex);
                    break;
                }
                case 1: {
                    if (ResourcesPanel.this.resourcesDataControl.getAssetFilter(this.assetIndex) == 1 && !string.endsWith(".eaa")) {
                        new SlidesDialog(string);
                        break;
                    }
                    new AnimationDialog(string);
                    break;
                }
                case 4: {
                    new AudioDialog(string);
                    break;
                }
                case 5: {
                    new VideoDialog(string);
                }
            }
        }
    }

    private class CreateIconButtonListener
    implements ActionListener {
        private int assetIndex;

        public CreateIconButtonListener(int n) {
            this.assetIndex = n;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            String string = ResourcesPanel.this.resourcesDataControl.getAssetPath(ResourcesPanel.this.resourcesDataControl.getOriginalImage(this.assetIndex));
            if (string != null && !string.equals("")) {
                String[] stringArray = string.split("/");
                String string2 = stringArray[stringArray.length - 1];
                string2 = "icon_" + string2.substring(0, string2.length() - 4);
                String string3 = AssetsController.TempFileGenerator.generateTempFileOverwriteExisting(string2, "png");
                Image image = AssetsController.getImage(string);
                BufferedImage bufferedImage = new BufferedImage(image.getWidth(null), image.getHeight(null), 6);
                bufferedImage.getGraphics().drawImage(image, 0, 0, image.getWidth(null), image.getHeight(null), null);
                BufferedImage bufferedImage2 = new BufferedImage(80, 48, 6);
                int n = image.getWidth(null);
                int n2 = image.getHeight(null);
                int n3 = 80;
                int n4 = (int)((float)n2 / (float)n * 80.0f);
                if (n4 > 48) {
                    n4 = 48;
                    n3 = (int)((float)n / (float)n2 * 48.0f);
                }
                Graphics2D graphics2D = (Graphics2D)bufferedImage2.getGraphics();
                System.out.println("" + n3 + " x " + n4);
                int n5 = (80 - n3) / 2;
                int n6 = (48 - n4) / 2;
                float f = (float)n3 / (float)n;
                AffineTransform affineTransform = AffineTransform.getScaleInstance(f, f);
                AffineTransformOp affineTransformOp = new AffineTransformOp(affineTransform, 3);
                graphics2D.drawImage(bufferedImage, affineTransformOp, n5, n6);
                graphics2D.finalize();
                File file = new File(string3);
                try {
                    ImageIO.write((RenderedImage)bufferedImage2, "png", (java.io.File)file);
                }
                catch (IOException iOException) {
                    return;
                }
                ResourcesPanel.this.resourcesDataControl.setAssetPath(string3, this.assetIndex);
                ResourcesPanel.this.assetFields[this.assetIndex].setText(ResourcesPanel.this.resourcesDataControl.getAssetPath(this.assetIndex));
            }
        }
    }

    private class EditButtonListener
    implements ActionListener {
        private int assetIndex;
        private int fieldIndex;

        public EditButtonListener(int n, int n2) {
            this.assetIndex = n;
            this.fieldIndex = n2;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (ResourcesPanel.this.resourcesDataControl.getAssetPath(this.assetIndex) != null && ResourcesPanel.this.resourcesDataControl.getAssetPath(this.assetIndex).toLowerCase().endsWith(".eaa") && !ResourcesPanel.this.resourcesDataControl.getAssetPath(this.assetIndex).equals("assets/special/EmptyAnimation")) {
                new AnimationEditDialog(ResourcesPanel.this.resourcesDataControl.getAssetPath(this.assetIndex), null);
            } else {
                File file;
                String string = null;
                String string2 = "anim" + new Random().nextInt(1000);
                if (ResourcesPanel.this.resourcesDataControl.getAssetPath(this.assetIndex) != null) {
                    file = ResourcesPanel.this.resourcesDataControl.getAssetPath(this.assetIndex).split("/");
                    string2 = file[((String[])file).length - 1];
                    string = AssetsController.TempFileGenerator.generateTempFileOverwriteExisting(string2, "eaa");
                } else {
                    string2 = JOptionPane.showInputDialog(null, TC.get((String)"Animation.AskFilename"), TC.get((String)"Animation.AskFilenameTitle"), 3);
                    if (string2 != null && string2.length() > 0) {
                        string = AssetsController.TempFileGenerator.generateTempFileOverwriteExisting(string2, "eaa");
                    }
                }
                if (string != null) {
                    file = new File(string);
                    file.create();
                    AnimationWriter.writeAnimation(string, new Animation(string2, (ImageLoaderFactory)new EditorImageLoader()));
                    Animation animation = new Animation(string2, (ImageLoaderFactory)new EditorImageLoader());
                    animation.setDocumentation(ResourcesPanel.this.resourcesDataControl.getAssetDescription(this.assetIndex));
                    if (ResourcesPanel.this.resourcesDataControl.getAssetPath(this.assetIndex) != null) {
                        ResourcesDataControl.framesFromImages(animation, ResourcesPanel.this.resourcesDataControl.getAssetPath(this.assetIndex));
                        AnimationWriter.writeAnimation(string, animation);
                    }
                    ResourcesPanel.this.resourcesDataControl.setAssetPath(string, this.assetIndex);
                    new AnimationEditDialog(ResourcesPanel.this.resourcesDataControl.getAssetPath(this.assetIndex), animation);
                }
            }
            ResourcesPanel.this.assetFields[this.fieldIndex].setText(ResourcesPanel.this.resourcesDataControl.getAssetPath(this.assetIndex));
            ResourcesPanel.this.viewButtons[this.fieldIndex].setEnabled(ResourcesPanel.this.resourcesDataControl.getAssetPath(this.assetIndex) != null);
            if (ResourcesPanel.this.previewUpdater != null) {
                ResourcesPanel.this.previewUpdater.updateResources();
            }
        }
    }

    private class ExamineButtonListener
    implements ActionListener {
        private int assetIndex;
        private int fieldIndex;

        public ExamineButtonListener(int n, int n2) {
            this.assetIndex = n;
            this.fieldIndex = n2;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            ResourcesPanel.this.resourcesDataControl.editAssetPath(this.assetIndex);
            ResourcesPanel.this.assetFields[this.fieldIndex].setText(ResourcesPanel.this.resourcesDataControl.getAssetPath(this.assetIndex));
            int n = ResourcesPanel.this.resourcesDataControl.getAssetCategory(this.assetIndex);
            String string = ResourcesPanel.this.resourcesDataControl.getAssetPath(this.assetIndex);
            switch (n) {
                case 0: {
                    BufferedImage bufferedImage = (BufferedImage)AssetsController.getImage(string);
                    if (bufferedImage.getHeight() <= 600 && bufferedImage.getWidth() >= 800) break;
                    JOptionPane.showMessageDialog(null, TC.get((String)"SelectImageDialog.Message"), "Info", -1);
                    new SelectImageDialog(string);
                }
            }
            ResourcesPanel.this.viewButtons[this.fieldIndex].setEnabled(ResourcesPanel.this.resourcesDataControl.getAssetPath(this.assetIndex) != null);
            if (ResourcesPanel.this.previewUpdater != null) {
                ResourcesPanel.this.previewUpdater.updateResources();
            }
        }
    }

    private class DeleteContentButtonListener
    implements ActionListener {
        private int assetIndex;
        private int fieldIndex;

        public DeleteContentButtonListener(int n, int n2) {
            this.assetIndex = n;
            this.fieldIndex = n2;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            ResourcesPanel.this.resourcesDataControl.deleteAssetPath(this.assetIndex);
            ResourcesPanel.this.assetFields[this.fieldIndex].setText(null);
            ResourcesPanel.this.viewButtons[this.fieldIndex].setEnabled(false);
            if (ResourcesPanel.this.previewUpdater != null) {
                ResourcesPanel.this.previewUpdater.updateResources();
            }
        }
    }
}

