/*
 * Decompiled with CFR 0.152.
 */
package es.eucm.eadventure.editor.gui.elementpanels.general;

import es.eucm.eadventure.common.gui.TC;
import es.eucm.eadventure.editor.control.config.ResizeableListConfigData;
import es.eucm.eadventure.editor.control.controllers.DataControl;
import es.eucm.eadventure.editor.gui.elementpanels.general.tables.ResizableTableModel;
import es.eucm.eadventure.editor.gui.elementpanels.general.tables.ResizeableCellRenderer;
import es.eucm.eadventure.editor.gui.structurepanel.StructureControl;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.List;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;

public class ResizeableListPanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    private ResizeableCellRenderer renderer;
    private ResizableTableModel model;
    private JTable informationTable;
    private String name = "";
    private List<DataControl> dataControlList;

    public ResizeableListPanel(List<DataControl> list, ResizeableCellRenderer resizeableCellRenderer, String string) {
        this.dataControlList = list;
        this.renderer = resizeableCellRenderer;
        this.name = string;
        this.createPanel();
    }

    private void createPanel() {
        this.setLayout(new BorderLayout());
        JPanel jPanel = new JPanel();
        JButton jButton = new JButton(new ImageIcon("img/icons/size0.png"));
        jButton.setToolTipText(TC.get((String)"ResizeableListPanel.Size0ToolTip"));
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ResizeableListPanel.this.changeSize(0);
            }
        });
        jPanel.add(jButton);
        JButton jButton2 = new JButton(new ImageIcon("img/icons/size1.png"));
        jButton2.setToolTipText(TC.get((String)"ResizeableListPanel.Size1ToolTip"));
        jButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ResizeableListPanel.this.changeSize(1);
            }
        });
        jPanel.add(jButton2);
        JButton jButton3 = new JButton(new ImageIcon("img/icons/size2.png"));
        jButton3.setToolTipText(TC.get((String)"ResizeableListPanel.Size2ToolTip"));
        jButton3.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ResizeableListPanel.this.changeSize(2);
            }
        });
        jPanel.add(jButton3);
        this.add((Component)jPanel, "North");
        int n = ResizeableListConfigData.getSize(this.name);
        this.model = new ResizableTableModel(this.dataControlList, n);
        this.renderer.setSize(n);
        this.informationTable = new JTable(this.model);
        this.informationTable.addMouseListener(new InformationTableMouseListener());
        for (int i = 0; i < this.model.getColumnCount(); ++i) {
            this.informationTable.getColumnModel().getColumn(i).setCellRenderer(this.renderer);
            this.informationTable.getColumnModel().getColumn(i).setCellEditor(this.renderer);
        }
        if (n == 0) {
            this.informationTable.setRowHeight(20);
        }
        if (n == 1) {
            this.informationTable.setRowHeight(100);
        }
        if (n == 2) {
            this.informationTable.setRowHeight(200);
        }
        this.informationTable.setTableHeader(null);
        this.add((Component)new JScrollPane(this.informationTable, 22, 31), "Center");
    }

    private void changeSize(int n) {
        this.renderer.setSize(n);
        this.model.setSize(n);
        this.model.fireTableStructureChanged();
        for (int i = 0; i < this.model.getColumnCount(); ++i) {
            this.informationTable.getColumnModel().getColumn(i).setCellRenderer(this.renderer);
            this.informationTable.getColumnModel().getColumn(i).setCellEditor(this.renderer);
        }
        if (n == 0) {
            this.informationTable.setRowHeight(20);
        }
        if (n == 1) {
            this.informationTable.setRowHeight(100);
        }
        if (n == 2) {
            this.informationTable.setRowHeight(200);
        }
        ResizeableListConfigData.setSize(this.name, n);
    }

    private class InformationTableMouseListener
    extends MouseAdapter {
        private InformationTableMouseListener() {
        }

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
            if (mouseEvent.getClickCount() == 2) {
                JTable jTable = (JTable)mouseEvent.getSource();
                int n = jTable.rowAtPoint(mouseEvent.getPoint());
                int n2 = jTable.columnAtPoint(mouseEvent.getPoint());
                int n3 = 1;
                if (ResizeableListPanel.this.renderer.getSize() == 1) {
                    n3 = 4;
                } else if (ResizeableListPanel.this.renderer.getSize() == 2) {
                    n3 = 2;
                }
                int n4 = n * n3 + n2;
                if (n4 < ResizeableListPanel.this.dataControlList.size()) {
                    DataControl dataControl = (DataControl)ResizeableListPanel.this.dataControlList.get(n4);
                    StructureControl.getInstance().changeDataControl(dataControl);
                }
            }
        }
    }
}

