/*
 * Decompiled with CFR 0.152.
 */
package es.eucm.eadventure.editor.gui.elementpanels.general;

import es.eucm.eadventure.common.gui.TC;
import es.eucm.eadventure.editor.control.Controller;
import es.eucm.eadventure.editor.control.controllers.general.NextSceneDataControl;
import es.eucm.eadventure.editor.control.controllers.scene.SceneDataControl;
import es.eucm.eadventure.editor.control.controllers.scene.ScenesListDataControl;
import es.eucm.eadventure.editor.gui.auxiliar.components.JFiller;
import es.eucm.eadventure.editor.gui.editdialogs.ConditionsDialog;
import es.eucm.eadventure.editor.gui.editdialogs.EffectsDialog;
import es.eucm.eadventure.editor.gui.editdialogs.PlayerPositionDialog;
import es.eucm.eadventure.editor.gui.elementpanels.general.ExitLookPanel;
import es.eucm.eadventure.editor.gui.structurepanel.StructureControl;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.JTabbedPane;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class NextScenePanel
extends JTabbedPane {
    private static final long serialVersionUID = 1L;
    private NextSceneDataControl nextSceneDataControl;
    private JComboBox scenesComboBox;
    private JCheckBox destinyPositionCheckBox;
    private JButton destinyPositionButton;
    private JSpinner spinner;
    private JComboBox transitionCombo;

    public NextScenePanel(NextSceneDataControl nextSceneDataControl) {
        JPanel jPanel = new JPanel();
        this.nextSceneDataControl = nextSceneDataControl;
        jPanel.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.fill = 2;
        gridBagConstraints2.gridx = 0;
        gridBagConstraints2.gridy = 0;
        gridBagConstraints2.weightx = 1.0;
        this.scenesComboBox = new JComboBox<String>(Controller.getInstance().getIdentifierSummary().getGeneralSceneIds());
        this.scenesComboBox.setSelectedItem(nextSceneDataControl.getNextSceneId());
        this.scenesComboBox.addActionListener(new NextSceneComboBoxListener());
        jPanel2.add((Component)this.scenesComboBox, gridBagConstraints2);
        ImageIcon imageIcon = new ImageIcon("img/icons/moveNodeRight.png");
        JButton jButton = new JButton(imageIcon);
        jButton.setPreferredSize(new Dimension(20, 20));
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ScenesListDataControl scenesListDataControl = Controller.getInstance().getSelectedChapterDataControl().getScenesList();
                for (SceneDataControl sceneDataControl : scenesListDataControl.getScenes()) {
                    if (!sceneDataControl.getId().equals(NextScenePanel.this.nextSceneDataControl.getNextSceneId())) continue;
                    StructureControl.getInstance().changeDataControl(sceneDataControl);
                }
            }
        });
        gridBagConstraints2.gridx = 1;
        gridBagConstraints2.weightx = 0.1;
        jPanel2.add((Component)jButton, gridBagConstraints2);
        jPanel2.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), TC.get((String)"NextScene.NextSceneId")));
        jPanel.add((Component)jPanel2, gridBagConstraints);
        gridBagConstraints.gridy = 1;
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new GridLayout(0, 1));
        this.destinyPositionCheckBox = new JCheckBox(TC.get((String)"NextScene.UseDestinyPosition"), nextSceneDataControl.hasDestinyPosition());
        this.destinyPositionCheckBox.setEnabled(Controller.getInstance().getIdentifierSummary().isScene(nextSceneDataControl.getNextSceneId()));
        this.destinyPositionCheckBox.addActionListener(new DestinyPositionCheckBoxListener());
        this.destinyPositionButton = new JButton(TC.get((String)"NextScene.EditDestinyPosition"));
        this.destinyPositionButton.setEnabled(nextSceneDataControl.hasDestinyPosition());
        this.destinyPositionButton.addActionListener(new DestinyPositionButtonListener());
        if (!Controller.getInstance().isPlayTransparent()) {
            jPanel3.add(this.destinyPositionCheckBox);
            jPanel3.add(this.destinyPositionButton);
            jPanel3.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), TC.get((String)"NextScene.DestinyPosition")));
        }
        jPanel.add((Component)jPanel3, gridBagConstraints);
        gridBagConstraints.gridy = 2;
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout(new GridLayout());
        JButton jButton2 = new JButton(TC.get((String)"GeneralText.EditConditions"));
        jButton2.addActionListener(new ConditionsButtonListener());
        jPanel4.add(jButton2);
        jPanel4.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), TC.get((String)"NextScene.Conditions")));
        jPanel.add((Component)jPanel4, gridBagConstraints);
        gridBagConstraints.gridy = 3;
        JPanel jPanel5 = new JPanel();
        jPanel5.setLayout(new GridLayout());
        JButton jButton3 = new JButton(TC.get((String)"GeneralText.EditEffects"));
        jButton3.addActionListener(new EffectsButtonListener());
        jPanel5.add(jButton3);
        jPanel5.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), TC.get((String)"NextScene.Effects")));
        jPanel.add((Component)jPanel5, gridBagConstraints);
        gridBagConstraints.gridy = 4;
        JPanel jPanel6 = new JPanel();
        jPanel6.setLayout(new GridLayout());
        JButton jButton4 = new JButton(TC.get((String)"GeneralText.EditPostEffects"));
        jButton4.addActionListener(new PostEffectsButtonListener());
        jPanel6.add(jButton4);
        jPanel6.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), TC.get((String)"NextScene.PostEffects")));
        jPanel.add((Component)jPanel6, gridBagConstraints);
        gridBagConstraints.gridy = 5;
        JPanel jPanel7 = new JPanel();
        jPanel7.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), TC.get((String)"NextScene.Transition")));
        String[] stringArray = new String[]{TC.get((String)"NextScene.NoTransition"), TC.get((String)"NextScene.TopToBottom"), TC.get((String)"NextScene.BottomToTop"), TC.get((String)"NextScene.LeftToRight"), TC.get((String)"NextScene.RightToLeft"), TC.get((String)"NextScene.FadeIn")};
        this.transitionCombo = new JComboBox<String>(stringArray);
        this.transitionCombo.setSelectedIndex(nextSceneDataControl.getTransitionType());
        this.transitionCombo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                NextScenePanel.this.comboModified();
            }
        });
        jPanel7.add(this.transitionCombo);
        JPanel jPanel8 = new JPanel();
        jPanel8.add(new JLabel(TC.get((String)"Animation.Duration") + ": "));
        SpinnerNumberModel spinnerNumberModel = new SpinnerNumberModel(nextSceneDataControl.getTransitionTime(), Integer.valueOf(0), Integer.valueOf(5000), (Number)100);
        this.spinner = new JSpinner(spinnerNumberModel);
        this.spinner.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                NextScenePanel.this.spinnerModified();
            }
        });
        jPanel8.add(this.spinner);
        jPanel7.add(jPanel8);
        jPanel.add((Component)jPanel7, gridBagConstraints);
        ++gridBagConstraints.gridy;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        jPanel.add((Component)new JFiller(), gridBagConstraints);
        this.insertTab(TC.get((String)"NextScene.Title"), null, jPanel, TC.get((String)"NextScene.Title"), 0);
        this.insertTab(TC.get((String)"NextScene.AdvancedOptions"), null, new ExitLookPanel(nextSceneDataControl.getExitLookDataController()), TC.get((String)"NextScene.AdvancedOptions"), 1);
    }

    protected void comboModified() {
        this.nextSceneDataControl.setTransitionType(this.transitionCombo.getSelectedIndex());
    }

    protected void spinnerModified() {
        this.nextSceneDataControl.setTransitionTime((Integer)this.spinner.getValue());
    }

    private class PostEffectsButtonListener
    implements ActionListener {
        private PostEffectsButtonListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            new EffectsDialog(NextScenePanel.this.nextSceneDataControl.getPostEffects());
        }
    }

    private class EffectsButtonListener
    implements ActionListener {
        private EffectsButtonListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            new EffectsDialog(NextScenePanel.this.nextSceneDataControl.getEffects());
        }
    }

    private class ConditionsButtonListener
    implements ActionListener {
        private ConditionsButtonListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            new ConditionsDialog(NextScenePanel.this.nextSceneDataControl.getConditions());
        }
    }

    private class DestinyPositionButtonListener
    implements ActionListener {
        private DestinyPositionButtonListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            PlayerPositionDialog playerPositionDialog = new PlayerPositionDialog(NextScenePanel.this.scenesComboBox.getSelectedItem().toString(), NextScenePanel.this.nextSceneDataControl.getDestinyPositionX(), NextScenePanel.this.nextSceneDataControl.getDestinyPositionY());
            NextScenePanel.this.nextSceneDataControl.setDestinyPosition(playerPositionDialog.getPositionX(), playerPositionDialog.getPositionY());
        }
    }

    private class DestinyPositionCheckBoxListener
    implements ActionListener {
        private DestinyPositionCheckBoxListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            NextScenePanel.this.nextSceneDataControl.toggleDestinyPosition();
            NextScenePanel.this.destinyPositionButton.setEnabled(NextScenePanel.this.nextSceneDataControl.hasDestinyPosition());
        }
    }

    private class NextSceneComboBoxListener
    implements ActionListener {
        private NextSceneComboBoxListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            NextScenePanel.this.nextSceneDataControl.setNextSceneId(NextScenePanel.this.scenesComboBox.getSelectedItem().toString());
            if (Controller.getInstance().getIdentifierSummary().isScene(NextScenePanel.this.scenesComboBox.getSelectedItem().toString())) {
                NextScenePanel.this.destinyPositionCheckBox.setEnabled(true);
            } else {
                NextScenePanel.this.destinyPositionCheckBox.setEnabled(false);
                if (NextScenePanel.this.nextSceneDataControl.hasDestinyPosition()) {
                    NextScenePanel.this.nextSceneDataControl.toggleDestinyPosition();
                    NextScenePanel.this.destinyPositionCheckBox.setSelected(false);
                    NextScenePanel.this.destinyPositionButton.setEnabled(false);
                }
            }
        }
    }
}

