/*
 * Decompiled with CFR 0.152.
 */
package es.eucm.eadventure.editor.gui.elementpanels.general;

import es.eucm.eadventure.common.gui.TC;
import es.eucm.eadventure.editor.control.Controller;
import es.eucm.eadventure.editor.control.controllers.DataControl;
import es.eucm.eadventure.editor.control.controllers.DataControlWithResources;
import es.eucm.eadventure.editor.gui.Updateable;
import es.eucm.eadventure.editor.gui.auxiliar.components.JFiller;
import es.eucm.eadventure.editor.gui.elementpanels.general.ResourcesPanel;
import es.eucm.eadventure.editor.gui.elementpanels.general.tables.ResourcesTable;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;

public abstract class LooksPanel
extends JPanel
implements Updateable {
    private static final long serialVersionUID = 1L;
    private static final int HORIZONTAL_SPLIT_POSITION = 70;
    protected DataControlWithResources dataControl;
    protected JPanel lookPanel;
    protected GridBagConstraints cLook;
    protected ResourcesTable resourcesTable;
    protected JButton newResourcesBlock;
    protected JButton deleteResourcesBlock;
    protected JButton duplicateResourcesBlock;
    protected ResourcesPanel resourcesPanel;
    protected int selectedResourceGroup = 0;

    public LooksPanel(DataControlWithResources dataControlWithResources) {
        this.dataControl = dataControlWithResources;
        this.lookPanel = new JPanel();
        this.lookPanel.setLayout(new GridBagLayout());
        this.cLook = new GridBagConstraints();
        this.cLook.insets = new Insets(5, 5, 5, 5);
        this.cLook.fill = 2;
        this.cLook.weightx = 1.0;
        this.cLook.gridy = 0;
        this.cLook.weighty = 0.0;
        this.cLook.anchor = 21;
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridLayout());
        this.resourcesTable = new ResourcesTable(this.dataControl, this);
        this.resourcesTable.setSelectedIndex(-1);
        this.resourcesTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                if (LooksPanel.this.resourcesTable.getSelectedRow() >= 0) {
                    LooksPanel.this.updateResources();
                    LooksPanel.this.duplicateResourcesBlock.setEnabled(true);
                    if (LooksPanel.this.dataControl.getResourcesCount() > 1) {
                        LooksPanel.this.deleteResourcesBlock.setEnabled(true);
                    } else {
                        LooksPanel.this.deleteResourcesBlock.setEnabled(false);
                    }
                } else {
                    LooksPanel.this.duplicateResourcesBlock.setEnabled(false);
                }
            }
        });
        JScrollPane jScrollPane = new JScrollPane(this.resourcesTable, 22, 31);
        jScrollPane.setMinimumSize(new Dimension(0, 70));
        this.newResourcesBlock = new JButton(new ImageIcon("img/icons/addNode.png"));
        this.newResourcesBlock.setContentAreaFilled(false);
        this.newResourcesBlock.setMargin(new Insets(0, 0, 0, 0));
        this.newResourcesBlock.setBorder(BorderFactory.createEmptyBorder());
        this.newResourcesBlock.setToolTipText(TC.get((String)"ResourcesList.AddResourcesBlock"));
        this.newResourcesBlock.addActionListener(new NewButtonListener());
        this.deleteResourcesBlock = new JButton(new ImageIcon("img/icons/deleteNode.png"));
        this.deleteResourcesBlock.setContentAreaFilled(false);
        this.deleteResourcesBlock.setMargin(new Insets(0, 0, 0, 0));
        this.deleteResourcesBlock.setBorder(BorderFactory.createEmptyBorder());
        this.deleteResourcesBlock.setToolTipText(TC.get((String)"ResourcesList.DeleteResourcesBlock"));
        this.deleteResourcesBlock.setEnabled(false);
        this.deleteResourcesBlock.addActionListener(new DeleteButtonListener());
        this.duplicateResourcesBlock = new JButton(new ImageIcon("img/icons/duplicateNode.png"));
        this.duplicateResourcesBlock.setContentAreaFilled(false);
        this.duplicateResourcesBlock.setMargin(new Insets(0, 0, 0, 0));
        this.duplicateResourcesBlock.setBorder(BorderFactory.createEmptyBorder());
        this.duplicateResourcesBlock.setToolTipText(TC.get((String)"ResourcesList.DuplicateResourcesBlock"));
        this.duplicateResourcesBlock.setEnabled(false);
        this.duplicateResourcesBlock.addActionListener(new DuplicateButtonListener());
        JPanel jPanel2 = new JPanel();
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        jPanel3.add((Component)this.newResourcesBlock, gridBagConstraints);
        gridBagConstraints.gridy = 1;
        jPanel3.add((Component)this.duplicateResourcesBlock, gridBagConstraints);
        gridBagConstraints.gridy = 3;
        jPanel3.add((Component)this.deleteResourcesBlock, gridBagConstraints);
        gridBagConstraints.gridy = 2;
        gridBagConstraints.weighty = 2.0;
        gridBagConstraints.fill = 3;
        jPanel3.add((Component)new JFiller(), gridBagConstraints);
        jPanel2.setLayout(new BorderLayout());
        jPanel2.add((Component)jScrollPane, "Center");
        jPanel2.add((Component)jPanel3, "East");
        this.resourcesPanel = new ResourcesPanel(this.dataControl.getResources().get(this.dataControl.getSelectedResources()));
        this.resourcesPanel.setPreviewUpdater(this);
        this.cLook.gridy = 0;
        this.cLook.gridx = 0;
        this.cLook.gridwidth = 2;
        this.cLook.fill = 1;
        this.cLook.weightx = 1.0;
        this.cLook.weighty = 0.0;
        this.lookPanel.add((Component)this.resourcesPanel, this.cLook);
        this.cLook.gridy = 1;
        this.cLook.fill = 1;
        this.cLook.weighty = 1.0;
        this.cLook.weightx = 1.0;
        this.cLook.gridwidth = 2;
        this.createPreview();
        JSplitPane jSplitPane = new JSplitPane(0, jPanel2, this.lookPanel);
        jSplitPane.setOneTouchExpandable(true);
        jSplitPane.setDividerLocation(70);
        jSplitPane.setContinuousLayout(true);
        jSplitPane.setResizeWeight(0.0);
        jSplitPane.setDividerSize(10);
        if (this.resourcesTable.getRowCount() == 1) {
            jSplitPane.setDividerLocation(0);
        }
        this.setLayout(new BorderLayout());
        this.add((Component)jSplitPane, "Center");
        this.resourcesTable.setSelectedIndex(this.dataControl.getSelectedResources());
    }

    public abstract void updatePreview();

    protected abstract void createPreview();

    public void updateResources() {
        this.dataControl.setSelectedResources(this.resourcesTable.getSelectedIndex());
        this.updatePreview();
        this.lookPanel.remove(this.resourcesPanel);
        int n = this.resourcesPanel.getSelectedIndex();
        this.resourcesPanel = new ResourcesPanel(this.dataControl.getResources().get(this.dataControl.getSelectedResources()), n);
        this.resourcesPanel.setPreviewUpdater(this);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        this.lookPanel.add((Component)this.resourcesPanel, gridBagConstraints);
        this.resourcesPanel.repaint();
        this.resourcesPanel.updateUI();
    }

    public void updateResources(int n) {
        this.selectedResourceGroup = n;
        this.updatePreview();
    }

    @Override
    public boolean updateFields() {
        this.resourcesTable.setSelectedIndex(this.dataControl.getSelectedResources());
        this.updateResources();
        this.resourcesTable.resetModel();
        this.resourcesTable.setSelectedIndex(this.dataControl.getSelectedResources());
        return true;
    }

    private class NewButtonListener
    implements ActionListener {
        private NewButtonListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (LooksPanel.this.dataControl.addElement(34, null)) {
                LooksPanel.this.dataControl.setSelectedResources(LooksPanel.this.dataControl.getResourcesCount() - 1);
                LooksPanel.this.updateResources();
                ((AbstractTableModel)LooksPanel.this.resourcesTable.getModel()).fireTableDataChanged();
                LooksPanel.this.resourcesTable.changeSelection(LooksPanel.this.dataControl.getResourcesCount() - 1, 0, false, false);
            }
        }
    }

    private class DuplicateButtonListener
    implements ActionListener {
        private DuplicateButtonListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (LooksPanel.this.resourcesTable.getSelectedIndex() >= 0) {
                LooksPanel.this.dataControl.setSelectedResources(LooksPanel.this.resourcesTable.getSelectedIndex());
                int n = LooksPanel.this.dataControl.getSelectedResources();
                DataControl dataControl = LooksPanel.this.dataControl.getResources().get(n);
                if (LooksPanel.this.dataControl.duplicateResources(dataControl)) {
                    LooksPanel.this.dataControl.setSelectedResources(LooksPanel.this.dataControl.getResourcesCount() - 1);
                    LooksPanel.this.resourcesTable.setSelectedIndex(LooksPanel.this.dataControl.getResourcesCount() - 1);
                    LooksPanel.this.updateResources();
                    ((AbstractTableModel)LooksPanel.this.resourcesTable.getModel()).fireTableDataChanged();
                    LooksPanel.this.resourcesTable.changeSelection(LooksPanel.this.dataControl.getResourcesCount() - 1, 0, false, false);
                }
            }
        }
    }

    private class DeleteButtonListener
    implements ActionListener {
        private DeleteButtonListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            boolean bl = true;
            boolean bl2 = false;
            if (LooksPanel.this.dataControl.getResources().size() == 2) {
                bl = Controller.getInstance().askDeleteConditionsResourceBlock();
                bl2 = true;
            }
            if (bl) {
                if (LooksPanel.this.resourcesTable.getSelectedIndex() >= 0) {
                    LooksPanel.this.dataControl.setSelectedResources(LooksPanel.this.resourcesTable.getSelectedIndex());
                    int n = LooksPanel.this.dataControl.getSelectedResources();
                    DataControl dataControl = LooksPanel.this.dataControl.getResources().get(n);
                    if (LooksPanel.this.dataControl.deleteElement(dataControl, true)) {
                        LooksPanel.this.dataControl.setSelectedResources(0);
                        LooksPanel.this.resourcesTable.setSelectedIndex(0);
                        LooksPanel.this.updateResources();
                        LooksPanel.this.resourcesTable.updateUI();
                        ((AbstractTableModel)LooksPanel.this.resourcesTable.getModel()).fireTableDataChanged();
                        LooksPanel.this.resourcesTable.changeSelection(LooksPanel.this.dataControl.getResourcesCount() - 1, 0, false, false);
                    }
                }
                if (bl2 && !LooksPanel.this.dataControl.getResources().get(0).getConditions().isEmpty()) {
                    LooksPanel.this.dataControl.getResources().get(0).getConditions().clearConditions();
                }
            }
        }
    }
}

