/*
 * Decompiled with CFR 0.152.
 */
package es.eucm.eadventure.editor.gui.elementpanels.general;

import es.eucm.eadventure.common.gui.TC;
import es.eucm.eadventure.editor.control.controllers.general.ExitLookDataControl;
import es.eucm.eadventure.editor.gui.auxiliar.components.JFiller;
import es.eucm.eadventure.editor.gui.otherpanels.imagepanels.ImagePanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.JTextPane;

public class ExitLookPanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    private JCheckBox customizeText;
    private JCheckBox customizeCursor;
    private ImagePanel cursorPreviewPanel;
    private JTextField customizedText;
    private JTextField customizedCursorPath;
    private JButton editCursor;
    private JButton deleteCursor;
    private ExitLookDataControl dataControl;

    public ExitLookPanel(ExitLookDataControl exitLookDataControl) {
        this.dataControl = exitLookDataControl;
        JTextPane jTextPane = new JTextPane();
        jTextPane.setEditable(false);
        jTextPane.setBackground(this.getBackground());
        jTextPane.setText(TC.get((String)"ExitLook.HelpText"));
        JPanel jPanel = new JPanel();
        jPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), TC.get((String)"GeneralText.Information")));
        jPanel.setLayout(new BorderLayout());
        jPanel.add((Component)jTextPane, "Center");
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.2;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        this.customizeText = new JCheckBox(TC.get((String)"ExitLook.CustomizeText"));
        this.customizeText.setSelected(this.dataControl.isTextCustomized());
        this.customizeText.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ExitLookPanel.this.customizedText.setEditable(ExitLookPanel.this.customizeText.isSelected());
                if (!ExitLookPanel.this.customizeText.isSelected()) {
                    ExitLookPanel.this.dataControl.setExitText(null);
                    ExitLookPanel.this.customizedText.setText("");
                } else {
                    ExitLookPanel.this.dataControl.setExitText(ExitLookPanel.this.customizedText.getText());
                }
            }
        });
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weightx = 0.25;
        gridBagConstraints.fill = 2;
        jPanel2.add((Component)this.customizeText, gridBagConstraints);
        if (this.dataControl.isTextCustomized()) {
            this.customizedText = new JTextField(this.dataControl.getCustomizedText());
            this.customizedText.setEditable(true);
        } else {
            this.customizedText = new JTextField("");
            this.customizedText.setEditable(false);
        }
        this.customizedText.setBorder(BorderFactory.createEtchedBorder());
        this.customizedText.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent focusEvent) {
            }

            @Override
            public void focusLost(FocusEvent focusEvent) {
                if (ExitLookPanel.this.customizedText.isEditable()) {
                    ExitLookPanel.this.dataControl.setExitText(ExitLookPanel.this.customizedText.getText());
                }
            }
        });
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.weightx = 0.75;
        jPanel2.add((Component)this.customizedText, gridBagConstraints);
        jPanel2.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), TC.get((String)"ExitLook.TextPanelTitle")));
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new GridBagLayout());
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.2;
        gridBagConstraints.gridwidth = 5;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        this.customizeCursor = new JCheckBox(TC.get((String)"ExitLook.CustomizeCursor"));
        this.customizeCursor.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (!ExitLookPanel.this.customizeCursor.isSelected()) {
                    ExitLookPanel.this.dataControl.invalidCursor();
                    ExitLookPanel.this.cursorPreviewPanel.removeImage();
                    ExitLookPanel.this.editCursor.setEnabled(false);
                    ExitLookPanel.this.deleteCursor.setEnabled(false);
                    ExitLookPanel.this.customizedCursorPath.setText("");
                } else {
                    ExitLookPanel.this.editCursor.setEnabled(true);
                    if (ExitLookPanel.this.dataControl.isCursorCustomized()) {
                        ExitLookPanel.this.cursorPreviewPanel.loadImage(ExitLookPanel.this.dataControl.getCustomizedCursor());
                        ExitLookPanel.this.deleteCursor.setEnabled(true);
                        ExitLookPanel.this.customizedCursorPath.setText(ExitLookPanel.this.dataControl.getCustomizedCursor());
                    } else {
                        ExitLookPanel.this.deleteCursor.setEnabled(false);
                    }
                }
            }
        });
        this.editCursor = new JButton(TC.get((String)"Resources.Select"));
        this.editCursor.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ExitLookPanel.this.dataControl.editCursorPath();
                if (ExitLookPanel.this.dataControl.isCursorCustomized() && !ExitLookPanel.this.dataControl.getCustomizedCursor().equals(ExitLookPanel.this.customizedCursorPath.getText())) {
                    ExitLookPanel.this.customizedCursorPath.setText(ExitLookPanel.this.dataControl.getCustomizedCursor());
                    ExitLookPanel.this.cursorPreviewPanel.loadImage(ExitLookPanel.this.dataControl.getCustomizedCursor());
                    ExitLookPanel.this.deleteCursor.setEnabled(true);
                }
            }
        });
        ImageIcon imageIcon = new ImageIcon("img/icons/deleteContent.png");
        this.deleteCursor = new JButton(imageIcon);
        this.deleteCursor.setPreferredSize(new Dimension(20, 20));
        this.deleteCursor.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ExitLookPanel.this.dataControl.invalidCursor();
                ExitLookPanel.this.cursorPreviewPanel.removeImage();
                ExitLookPanel.this.deleteCursor.setEnabled(false);
                ExitLookPanel.this.customizedCursorPath.setText("");
            }
        });
        if (this.dataControl.isCursorCustomized()) {
            this.cursorPreviewPanel = new ImagePanel(this.dataControl.getCustomizedCursor());
            this.customizedCursorPath = new JTextField(this.dataControl.getCustomizedCursor());
            this.customizeCursor.setSelected(true);
            this.editCursor.setEnabled(true);
            this.deleteCursor.setEnabled(true);
        } else {
            this.cursorPreviewPanel = new ImagePanel();
            this.customizedCursorPath = new JTextField("");
            this.customizeCursor.setSelected(false);
            this.editCursor.setEnabled(false);
            this.deleteCursor.setEnabled(false);
        }
        this.customizedCursorPath.setEditable(false);
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.weighty = 1.0;
        this.cursorPreviewPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), TC.get((String)"Cursor.PreviewTitle")));
        jPanel3.add((Component)this.cursorPreviewPanel, gridBagConstraints);
        gridBagConstraints.gridx = 2;
        gridBagConstraints.weightx = 0.0;
        jPanel3.add((Component)this.customizeCursor, gridBagConstraints);
        gridBagConstraints.fill = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weighty = 0.0;
        jPanel3.add((Component)this.deleteCursor, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        jPanel3.add((Component)this.customizedCursorPath, gridBagConstraints);
        gridBagConstraints.gridx = 3;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.fill = 0;
        jPanel3.add((Component)this.editCursor, gridBagConstraints);
        jPanel3.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), TC.get((String)"ExitLook.CursorPanelTitle")));
        this.setLayout(new GridBagLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.5;
        this.add((Component)jPanel, gridBagConstraints);
        gridBagConstraints.anchor = 11;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weighty = 0.0;
        this.add((Component)jPanel2, gridBagConstraints);
        gridBagConstraints.gridy = 2;
        gridBagConstraints.weighty = 0.4;
        this.add((Component)jPanel3, gridBagConstraints);
        gridBagConstraints.gridy = 3;
        gridBagConstraints.weighty = 0.3;
        this.add((Component)new JFiller(), gridBagConstraints);
    }
}

