/*
 * Decompiled with CFR 0.152.
 */
package es.eucm.eadventure.editor.gui.elementpanels.general;

import es.eucm.eadventure.common.gui.TC;
import es.eucm.eadventure.editor.control.controllers.EffectsController;
import es.eucm.eadventure.editor.gui.Updateable;
import es.eucm.eadventure.editor.gui.auxiliar.components.JFiller;
import es.eucm.eadventure.editor.gui.elementpanels.general.TableScrollPane;
import es.eucm.eadventure.editor.gui.elementpanels.general.tables.ConditionsCellRendererEditor;
import es.eucm.eadventure.editor.gui.elementpanels.general.tables.EditEffectCellRenderEditor;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableCellRenderer;

public class EffectsPanel
extends JPanel
implements Updateable {
    private static final long serialVersionUID = 1L;
    private EffectsController effectsController;
    private JTable effectsTable;
    private JButton deleteButton;
    private JButton moveUpButton;
    private JButton moveDownButton;

    public EffectsPanel(EffectsController effectsController) {
        this.effectsController = effectsController;
        this.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), TC.get((String)"Effects.Title")));
        this.setLayout(new BorderLayout());
        this.effectsTable = new JTable(new EffectsTableModel());
        this.effectsTable.getColumnModel().getColumn(0).setMaxWidth(60);
        this.effectsTable.getColumnModel().getColumn(1).setCellRenderer(new TableCellRenderer(){

            @Override
            public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
                return (JPanel)object;
            }
        });
        this.effectsTable.getColumnModel().getColumn(2).setCellRenderer(new EditEffectCellRenderEditor(this.effectsTable));
        this.effectsTable.getColumnModel().getColumn(2).setCellEditor(new EditEffectCellRenderEditor(this.effectsTable));
        this.effectsTable.getColumnModel().getColumn(2).setMaxWidth(120);
        this.effectsTable.getColumnModel().getColumn(2).setMinWidth(120);
        this.effectsTable.getColumnModel().getColumn(2).setWidth(120);
        this.effectsTable.getColumnModel().getColumn(3).setCellRenderer(new ConditionsCellRendererEditor());
        this.effectsTable.getColumnModel().getColumn(3).setCellEditor(new ConditionsCellRendererEditor());
        this.effectsTable.getColumnModel().getColumn(3).setMaxWidth(120);
        this.effectsTable.getColumnModel().getColumn(3).setMinWidth(120);
        this.effectsTable.getColumnModel().getColumn(3).setWidth(120);
        this.effectsTable.setSelectionMode(0);
        this.effectsTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                EffectsPanel.this.effectsTable.setRowHeight(20);
                EffectsPanel.this.effectsTable.setRowHeight(EffectsPanel.this.effectsTable.getSelectedRow(), 25);
                EffectsPanel.this.updateButtons();
            }
        });
        TableScrollPane tableScrollPane = new TableScrollPane(this.effectsTable, 22, 30);
        this.add((Component)tableScrollPane, "Center");
        this.add((Component)this.createButtonsPanel(), "East");
    }

    private void updateButtons() {
        int n = this.effectsTable.getSelectedRow();
        if (n == -1) {
            this.deleteButton.setEnabled(false);
            this.moveUpButton.setEnabled(false);
            this.moveDownButton.setEnabled(false);
        } else {
            this.deleteButton.setEnabled(this.effectsController.getEffectCount() > 0);
            this.moveUpButton.setEnabled(n > 0);
            this.moveDownButton.setEnabled(n < this.effectsTable.getRowCount() - 1);
        }
    }

    private JPanel createButtonsPanel() {
        JPanel jPanel = new JPanel();
        JButton jButton = new JButton(new ImageIcon("img/icons/addNode.png"));
        jButton.setContentAreaFilled(false);
        jButton.setMargin(new Insets(0, 0, 0, 0));
        jButton.setBorder(BorderFactory.createEmptyBorder());
        jButton.setToolTipText(TC.get((String)"ItemReferenceTable.AddParagraph"));
        jButton.addActionListener(new AddEffectListener());
        this.deleteButton = new JButton(new ImageIcon("img/icons/deleteNode.png"));
        this.deleteButton.setContentAreaFilled(false);
        this.deleteButton.setMargin(new Insets(0, 0, 0, 0));
        this.deleteButton.setBorder(BorderFactory.createEmptyBorder());
        this.deleteButton.setToolTipText(TC.get((String)"ItemReferenceTable.Delete"));
        this.deleteButton.addActionListener(new DeleteEffectListener());
        this.deleteButton.setEnabled(false);
        this.moveUpButton = new JButton(new ImageIcon("img/icons/moveNodeUp.png"));
        this.moveUpButton.setContentAreaFilled(false);
        this.moveUpButton.setMargin(new Insets(0, 0, 0, 0));
        this.moveUpButton.setBorder(BorderFactory.createEmptyBorder());
        this.moveUpButton.setToolTipText(TC.get((String)"ItemReferenceTable.MoveUp"));
        this.moveUpButton.addActionListener(new MoveUpEffectListener());
        this.moveUpButton.setEnabled(false);
        this.moveDownButton = new JButton(new ImageIcon("img/icons/moveNodeDown.png"));
        this.moveDownButton.setContentAreaFilled(false);
        this.moveDownButton.setMargin(new Insets(0, 0, 0, 0));
        this.moveDownButton.setBorder(BorderFactory.createEmptyBorder());
        this.moveDownButton.setToolTipText(TC.get((String)"ItemReferenceTable.MoveDown"));
        this.moveDownButton.addActionListener(new MoveDownEffectListener());
        this.moveDownButton.setEnabled(false);
        jPanel.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        jPanel.add((Component)jButton, gridBagConstraints);
        ++gridBagConstraints.gridy;
        jPanel.add((Component)this.moveUpButton, gridBagConstraints);
        ++gridBagConstraints.gridy;
        jPanel.add((Component)this.moveDownButton, gridBagConstraints);
        ++gridBagConstraints.gridy;
        ++gridBagConstraints.gridy;
        jPanel.add((Component)this.deleteButton, gridBagConstraints);
        --gridBagConstraints.gridy;
        gridBagConstraints.fill = 3;
        gridBagConstraints.weighty = 1.0;
        jPanel.add((Component)new JFiller(), gridBagConstraints);
        return jPanel;
    }

    @Override
    public boolean updateFields() {
        this.updateButtons();
        this.effectsTable.updateUI();
        return true;
    }

    private class EffectsTableModel
    extends AbstractTableModel {
        private static final long serialVersionUID = 1L;

        private EffectsTableModel() {
        }

        @Override
        public int getColumnCount() {
            return 4;
        }

        @Override
        public int getRowCount() {
            return EffectsPanel.this.effectsController.getEffectCount();
        }

        @Override
        public String getColumnName(int n) {
            String string = "";
            if (n == 0) {
                string = TC.get((String)"Effects.EffectNumberColumnTitle");
            } else if (n == 1) {
                string = TC.get((String)"Effects.EffectDescriptionColumnTitle");
            } else if (n == 2) {
                string = TC.get((String)"ActionList.EditEffect");
            } else if (n == 3) {
                string = TC.get((String)"ActionsList.Conditions");
            }
            return string;
        }

        @Override
        public Object getValueAt(int n, int n2) {
            Object object = null;
            if (n2 == 0) {
                object = n + 1;
            } else if (n2 == 1) {
                JPanel jPanel = new JPanel();
                JLabel jLabel = new JLabel(EffectsPanel.this.effectsController.getEffectIcon(n));
                JLabel jLabel2 = new JLabel(EffectsPanel.this.effectsController.getEffectInfo(n));
                jPanel.setLayout(new BoxLayout(jPanel, 2));
                jPanel.add(jLabel);
                jPanel.add(jLabel2);
                jPanel.setOpaque(false);
                object = jPanel;
            } else if (n2 == 2) {
                object = EffectsPanel.this.effectsController;
            } else if (n2 == 3) {
                object = EffectsPanel.this.effectsController.getConditionController(n);
            }
            return object;
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            boolean bl = false;
            if (n2 == 2 || n2 == 3) {
                bl = true;
            }
            return bl && n == EffectsPanel.this.effectsTable.getSelectedRow();
        }
    }

    private class MoveDownEffectListener
    implements ActionListener {
        private MoveDownEffectListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            int n = EffectsPanel.this.effectsTable.getSelectedRow();
            if (n >= 0 && n < EffectsPanel.this.effectsTable.getRowCount() - 1 && EffectsPanel.this.effectsController.moveDownEffect(n)) {
                EffectsPanel.this.effectsTable.changeSelection(n + 1, n + 1, false, false);
                EffectsPanel.this.effectsTable.updateUI();
                EffectsPanel.this.updateButtons();
            }
        }
    }

    private class MoveUpEffectListener
    implements ActionListener {
        private MoveUpEffectListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            int n = EffectsPanel.this.effectsTable.getSelectedRow();
            if (n >= 0 && EffectsPanel.this.effectsController.moveUpEffect(n)) {
                EffectsPanel.this.effectsTable.changeSelection(n - 1, n - 1, false, false);
                EffectsPanel.this.effectsTable.updateUI();
                EffectsPanel.this.updateButtons();
            }
        }
    }

    private class DeleteEffectListener
    implements ActionListener {
        private DeleteEffectListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            int n = EffectsPanel.this.effectsTable.getSelectedRow();
            if (n >= 0) {
                EffectsPanel.this.effectsController.deleteEffect(n);
                EffectsPanel.this.effectsTable.updateUI();
                EffectsPanel.this.updateButtons();
            }
        }
    }

    private class AddEffectListener
    implements ActionListener {
        private AddEffectListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (EffectsPanel.this.effectsController.addEffect()) {
                EffectsPanel.this.effectsTable.getSelectionModel().setSelectionInterval(EffectsPanel.this.effectsTable.getRowCount() - 1, EffectsPanel.this.effectsTable.getRowCount() - 1);
                EffectsPanel.this.effectsTable.updateUI();
                EffectsPanel.this.updateButtons();
            }
        }
    }
}

