/*
 * Decompiled with CFR 0.152.
 */
package es.eucm.eadventure.editor.gui.elementpanels.general;

import es.eucm.eadventure.common.data.Described;
import es.eucm.eadventure.common.data.Titled;
import es.eucm.eadventure.common.gui.TC;
import es.eucm.eadventure.editor.control.Controller;
import es.eucm.eadventure.editor.control.controllers.general.ChapterDataControl;
import es.eucm.eadventure.editor.control.tools.listeners.DescriptionChangeListener;
import es.eucm.eadventure.editor.control.tools.listeners.TitleChangeListener;
import es.eucm.eadventure.editor.gui.auxiliar.components.JFiller;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;

public class ChapterInfoPanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    private ChapterDataControl chapterDataControl;
    private JTextField titleTextField;
    private JTextArea descriptionTextArea;
    private JButton selectAssessmentButton;
    private JButton deleteAssessmentButton;
    private JTextField assessmentPathTextField;
    private JButton selectAdaptationButton;
    private JButton deleteAdaptationButton;
    private JTextField adaptationPathTextField;
    private JComboBox initialSceneComboBox;

    public ChapterInfoPanel(ChapterDataControl chapterDataControl) {
        this.chapterDataControl = chapterDataControl;
        ImageIcon imageIcon = new ImageIcon("img/icons/deleteContent.png");
        String[] stringArray = Controller.getInstance().getIdentifierSummary().getGeneralSceneIds();
        this.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridLayout());
        this.titleTextField = new JTextField(chapterDataControl.getTitle());
        this.titleTextField.getDocument().addDocumentListener(new TitleChangeListener(this.titleTextField, (Titled)chapterDataControl.getContent()));
        jPanel.add(this.titleTextField);
        jPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), TC.get((String)"Chapter.ChapterTitle")));
        this.add((Component)jPanel, gridBagConstraints);
        gridBagConstraints.gridy = 1;
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new GridLayout());
        this.descriptionTextArea = new JTextArea(chapterDataControl.getDescription(), 4, 0);
        this.descriptionTextArea.setLineWrap(true);
        this.descriptionTextArea.setWrapStyleWord(true);
        this.descriptionTextArea.getDocument().addDocumentListener(new DescriptionChangeListener(this.descriptionTextArea, (Described)chapterDataControl.getContent()));
        jPanel2.add(new JScrollPane(this.descriptionTextArea, 22, 31));
        jPanel2.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), TC.get((String)"Chapter.Description")));
        this.add((Component)jPanel2, gridBagConstraints);
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new GridBagLayout());
        jPanel3.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), TC.get((String)"Chapter.AssessmentPath")));
        GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.insets = new Insets(4, 4, 4, 4);
        gridBagConstraints2.fill = 0;
        gridBagConstraints2.weightx = 0.0;
        gridBagConstraints2.weighty = 0.0;
        this.deleteAssessmentButton = new JButton(imageIcon);
        this.deleteAssessmentButton.addActionListener(new GeneralButtonListener());
        this.deleteAssessmentButton.setPreferredSize(new Dimension(20, 20));
        this.deleteAssessmentButton.setToolTipText(TC.get((String)"Resources.DeleteAsset"));
        jPanel3.add((Component)this.deleteAssessmentButton, gridBagConstraints2);
        gridBagConstraints2.gridx = 1;
        gridBagConstraints2.fill = 2;
        gridBagConstraints2.weightx = 1.0;
        String string = null;
        if (Controller.getInstance().getIdentifierSummary().isAssessmentProfileId(chapterDataControl.getAssessmentName())) {
            string = chapterDataControl.getAssessmentName();
        }
        this.assessmentPathTextField = new JTextField(string);
        this.assessmentPathTextField.setEditable(false);
        jPanel3.add((Component)this.assessmentPathTextField, gridBagConstraints2);
        gridBagConstraints2.gridx = 2;
        gridBagConstraints2.fill = 0;
        gridBagConstraints2.weightx = 0.0;
        this.selectAssessmentButton = new JButton(TC.get((String)"Resources.Select"));
        this.selectAssessmentButton.addActionListener(new GeneralButtonListener());
        jPanel3.add((Component)this.selectAssessmentButton, gridBagConstraints2);
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.add((Component)jPanel3, gridBagConstraints);
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout(new GridBagLayout());
        jPanel4.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), TC.get((String)"Chapter.AdaptationPath")));
        gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.insets = new Insets(4, 4, 4, 4);
        gridBagConstraints2.fill = 0;
        gridBagConstraints2.weightx = 0.0;
        gridBagConstraints2.weighty = 0.0;
        this.deleteAdaptationButton = new JButton(imageIcon);
        this.deleteAdaptationButton.addActionListener(new GeneralButtonListener());
        this.deleteAdaptationButton.setPreferredSize(new Dimension(20, 20));
        this.deleteAdaptationButton.setToolTipText(TC.get((String)"Resources.DeleteAsset"));
        jPanel4.add((Component)this.deleteAdaptationButton, gridBagConstraints2);
        gridBagConstraints2.gridx = 1;
        gridBagConstraints2.fill = 2;
        gridBagConstraints2.weightx = 1.0;
        String string2 = null;
        if (Controller.getInstance().getIdentifierSummary().isAdaptationProfileId(chapterDataControl.getAdaptationName())) {
            string2 = chapterDataControl.getAdaptationName();
        }
        this.adaptationPathTextField = new JTextField(string2);
        this.adaptationPathTextField.setEditable(false);
        jPanel4.add((Component)this.adaptationPathTextField, gridBagConstraints2);
        gridBagConstraints2.gridx = 2;
        gridBagConstraints2.fill = 0;
        gridBagConstraints2.weightx = 0.0;
        this.selectAdaptationButton = new JButton(TC.get((String)"Resources.Select"));
        this.selectAdaptationButton.addActionListener(new GeneralButtonListener());
        jPanel4.add((Component)this.selectAdaptationButton, gridBagConstraints2);
        gridBagConstraints.gridy = 3;
        this.add((Component)jPanel4, gridBagConstraints);
        JPanel jPanel5 = new JPanel();
        gridBagConstraints.gridy = 4;
        jPanel5.setLayout(new GridLayout());
        this.initialSceneComboBox = new JComboBox<String>(stringArray);
        this.initialSceneComboBox.setSelectedItem(chapterDataControl.getInitialScene());
        this.initialSceneComboBox.addActionListener(new InitialSceneComboBoxListener());
        jPanel5.add(this.initialSceneComboBox);
        jPanel5.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), TC.get((String)"Chapter.InitialScene")));
        this.add((Component)jPanel5, gridBagConstraints);
        gridBagConstraints.gridy = 5;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)new JFiller(), gridBagConstraints);
    }

    private class InitialSceneComboBoxListener
    implements ActionListener {
        private InitialSceneComboBoxListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            ChapterInfoPanel.this.chapterDataControl.setInitialScene(ChapterInfoPanel.this.initialSceneComboBox.getSelectedItem().toString());
        }
    }

    private class GeneralButtonListener
    implements ActionListener {
        private GeneralButtonListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (actionEvent.getSource().equals(ChapterInfoPanel.this.selectAssessmentButton)) {
                ChapterInfoPanel.this.chapterDataControl.setAssessmentPath(null);
                ChapterInfoPanel.this.assessmentPathTextField.setText(ChapterInfoPanel.this.chapterDataControl.getAssessmentName());
            } else if (actionEvent.getSource().equals(ChapterInfoPanel.this.selectAdaptationButton)) {
                ChapterInfoPanel.this.chapterDataControl.setAdaptationPath(null);
                ChapterInfoPanel.this.adaptationPathTextField.setText(ChapterInfoPanel.this.chapterDataControl.getAdaptationName());
            } else if (actionEvent.getSource().equals(ChapterInfoPanel.this.deleteAssessmentButton)) {
                ChapterInfoPanel.this.assessmentPathTextField.setText(null);
                ChapterInfoPanel.this.chapterDataControl.deleteAssessmentPath();
            } else if (actionEvent.getSource().equals(ChapterInfoPanel.this.deleteAdaptationButton)) {
                ChapterInfoPanel.this.adaptationPathTextField.setText(null);
                ChapterInfoPanel.this.chapterDataControl.deleteAdaptationPath();
            }
        }
    }
}

