/*
 * Decompiled with CFR 0.152.
 */
package es.eucm.eadventure.editor.gui.elementpanels.general;

import es.eucm.eadventure.common.gui.TC;
import es.eucm.eadventure.editor.control.Controller;
import es.eucm.eadventure.editor.control.controllers.Searchable;
import es.eucm.eadventure.editor.control.controllers.general.ActionDataControl;
import es.eucm.eadventure.editor.control.controllers.general.ActionsListDataControl;
import es.eucm.eadventure.editor.control.controllers.general.CustomActionDataControl;
import es.eucm.eadventure.editor.control.tools.general.actions.AddActionTool;
import es.eucm.eadventure.editor.control.tools.general.actions.DeleteActionTool;
import es.eucm.eadventure.editor.control.tools.general.actions.DuplicateActionTool;
import es.eucm.eadventure.editor.gui.DataControlsPanel;
import es.eucm.eadventure.editor.gui.Updateable;
import es.eucm.eadventure.editor.gui.auxiliar.components.JFiller;
import es.eucm.eadventure.editor.gui.elementpanels.general.ActionPropertiesPanel;
import es.eucm.eadventure.editor.gui.elementpanels.general.CustomActionPropertiesPanel;
import es.eucm.eadventure.editor.gui.elementpanels.general.TableScrollPane;
import es.eucm.eadventure.editor.gui.elementpanels.general.tables.ActionsTable;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;

public class ActionsListPanel
extends JPanel
implements DataControlsPanel,
Updateable {
    private static final long serialVersionUID = 1L;
    protected ActionsListDataControl dataControl;
    private JPanel actionPropertiesPanel;
    protected JButton deleteButton;
    protected JButton duplicateButton;
    protected JButton moveUpButton;
    protected JButton moveDownButton;
    protected JTable table;
    protected JPanel actionPanel;
    private static final int HORIZONTAL_SPLIT_POSITION = 140;

    public ActionsListPanel(ActionsListDataControl actionsListDataControl) {
        this.dataControl = actionsListDataControl;
        this.setLayout(new BorderLayout());
        this.actionPropertiesPanel = new JPanel();
        this.actionPropertiesPanel.setLayout(new BorderLayout());
        JPanel jPanel = this.createTablePanel();
        JSplitPane jSplitPane = new JSplitPane(0, jPanel, this.actionPropertiesPanel);
        jSplitPane.setOneTouchExpandable(true);
        jSplitPane.setDividerLocation(140);
        jSplitPane.setContinuousLayout(true);
        jSplitPane.setResizeWeight(0.5);
        jSplitPane.setDividerSize(10);
        this.add((Component)jSplitPane, "Center");
    }

    private JPanel createTablePanel() {
        JPanel jPanel = new JPanel(new BorderLayout());
        this.table = new ActionsTable(this.dataControl);
        jPanel.add((Component)new TableScrollPane(this.table, 22, 31), "Center");
        this.table.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                ActionsListPanel.this.updateSelectedAction();
            }
        });
        JPanel jPanel2 = new JPanel();
        JButton jButton = new JButton(new ImageIcon("img/icons/addNode.png"));
        jButton.setContentAreaFilled(false);
        jButton.setMargin(new Insets(0, 0, 0, 0));
        jButton.setBorder(BorderFactory.createEmptyBorder());
        jButton.setToolTipText(TC.get((String)"ItemReferenceTable.AddParagraph"));
        jButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                JPopupMenu jPopupMenu = ActionsListPanel.this.getAddChildPopupMenu();
                jPopupMenu.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
            }
        });
        this.deleteButton = new JButton(new ImageIcon("img/icons/deleteNode.png"));
        this.deleteButton.setContentAreaFilled(false);
        this.deleteButton.setMargin(new Insets(0, 0, 0, 0));
        this.deleteButton.setBorder(BorderFactory.createEmptyBorder());
        this.deleteButton.setToolTipText(TC.get((String)"ActionsList.Delete"));
        this.deleteButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ActionsListPanel.this.delete();
            }
        });
        this.deleteButton.setEnabled(false);
        this.duplicateButton = new JButton(new ImageIcon("img/icons/duplicateNode.png"));
        this.duplicateButton.setContentAreaFilled(false);
        this.duplicateButton.setMargin(new Insets(0, 0, 0, 0));
        this.duplicateButton.setBorder(BorderFactory.createEmptyBorder());
        this.duplicateButton.setToolTipText(TC.get((String)"ActionsList.Duplicate"));
        this.duplicateButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ActionsListPanel.this.duplicate();
            }
        });
        this.duplicateButton.setEnabled(false);
        this.moveUpButton = new JButton(new ImageIcon("img/icons/moveNodeUp.png"));
        this.moveUpButton.setContentAreaFilled(false);
        this.moveUpButton.setMargin(new Insets(0, 0, 0, 0));
        this.moveUpButton.setBorder(BorderFactory.createEmptyBorder());
        this.moveUpButton.setToolTipText(TC.get((String)"ItemReferenceTable.MoveUp"));
        this.moveUpButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ActionsListPanel.this.moveUp();
            }
        });
        this.moveUpButton.setEnabled(false);
        this.moveDownButton = new JButton(new ImageIcon("img/icons/moveNodeDown.png"));
        this.moveDownButton.setContentAreaFilled(false);
        this.moveDownButton.setMargin(new Insets(0, 0, 0, 0));
        this.moveDownButton.setBorder(BorderFactory.createEmptyBorder());
        this.moveDownButton.setToolTipText(TC.get((String)"ItemReferenceTable.MoveDown"));
        this.moveDownButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ActionsListPanel.this.moveDown();
            }
        });
        this.moveDownButton.setEnabled(false);
        jPanel2.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        jPanel2.add((Component)jButton, gridBagConstraints);
        gridBagConstraints.gridy = 1;
        jPanel2.add((Component)this.duplicateButton, gridBagConstraints);
        gridBagConstraints.gridy = 2;
        jPanel2.add((Component)this.moveUpButton, gridBagConstraints);
        gridBagConstraints.gridy = 3;
        jPanel2.add((Component)this.moveDownButton, gridBagConstraints);
        gridBagConstraints.gridy = 5;
        jPanel2.add((Component)this.deleteButton, gridBagConstraints);
        gridBagConstraints.gridy = 4;
        gridBagConstraints.weighty = 2.0;
        gridBagConstraints.fill = 3;
        jPanel2.add((Component)new JFiller(), gridBagConstraints);
        jPanel.add((Component)jPanel2, "East");
        return jPanel;
    }

    private void updateSelectedAction() {
        int n = this.table.getSelectedRow();
        this.actionPropertiesPanel.removeAll();
        if (n != -1 && n < this.dataControl.getActions().size()) {
            ActionDataControl actionDataControl = this.dataControl.getActions().get(n);
            if (actionDataControl instanceof CustomActionDataControl) {
                this.actionPanel = new CustomActionPropertiesPanel((CustomActionDataControl)actionDataControl);
                this.actionPropertiesPanel.add((Component)this.actionPanel, "Center");
            } else if (actionDataControl instanceof ActionDataControl) {
                this.actionPanel = new ActionPropertiesPanel(actionDataControl);
                this.actionPropertiesPanel.add((Component)this.actionPanel, "Center");
            }
            this.actionPropertiesPanel.updateUI();
            this.deleteButton.setEnabled(true);
            this.duplicateButton.setEnabled(true);
            this.moveUpButton.setEnabled(this.dataControl.getActions().size() > 1 && n > 0);
            this.moveDownButton.setEnabled(this.dataControl.getActions().size() > 1 && n < this.table.getRowCount() - 1);
        } else {
            this.actionPropertiesPanel.removeAll();
            this.actionPanel = null;
            this.actionPropertiesPanel.updateUI();
            this.deleteButton.setEnabled(false);
            this.duplicateButton.setEnabled(false);
            this.moveUpButton.setEnabled(false);
            this.moveDownButton.setEnabled(false);
        }
    }

    public JPopupMenu getAddChildPopupMenu() {
        JPopupMenu jPopupMenu = new JPopupMenu();
        for (final int n : this.dataControl.getAddableElements()) {
            JMenuItem jMenuItem = new JMenuItem(TC.get((String)("TreeNode.AddElement" + n)));
            jMenuItem.setEnabled(true);
            jMenuItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    Controller.getInstance().addTool(new AddActionTool(ActionsListPanel.this.dataControl, n));
                    ((AbstractTableModel)ActionsListPanel.this.table.getModel()).fireTableDataChanged();
                    ActionsListPanel.this.table.changeSelection(ActionsListPanel.this.table.getRowCount() - 1, ActionsListPanel.this.table.getRowCount() - 1, false, false);
                }
            });
            jPopupMenu.add(jMenuItem);
        }
        return jPopupMenu;
    }

    protected void duplicate() {
        Controller.getInstance().addTool(new DuplicateActionTool(this.dataControl, this.table.getSelectedRow()));
        ((AbstractTableModel)this.table.getModel()).fireTableDataChanged();
        this.table.changeSelection(this.dataControl.getActions().size() - 1, 0, false, false);
    }

    protected void delete() {
        Controller.getInstance().addTool(new DeleteActionTool(this.dataControl, this.table.getSelectedRow()));
        ((AbstractTableModel)this.table.getModel()).fireTableDataChanged();
    }

    protected void moveUp() {
        int n = this.table.getSelectedRow();
        this.table.clearSelection();
        this.dataControl.moveElementUp(this.dataControl.getActions().get(n));
        ((AbstractTableModel)this.table.getModel()).fireTableDataChanged();
        this.table.changeSelection(n - 1, n - 1, false, false);
        this.table.editCellAt(n + 1, 0);
    }

    protected void moveDown() {
        int n = this.table.getSelectedRow();
        this.table.clearSelection();
        this.dataControl.moveElementDown(this.dataControl.getActions().get(n));
        ((AbstractTableModel)this.table.getModel()).fireTableDataChanged();
        this.table.changeSelection(n + 1, n + 1, false, false);
        this.table.editCellAt(n + 1, 0);
    }

    @Override
    public void setSelectedItem(List<Searchable> list) {
        if (list.size() > 0) {
            for (int i = 0; i < this.dataControl.getActions().size(); ++i) {
                if (this.dataControl.getActions().get(i) != list.get(list.size() - 1)) continue;
                this.table.changeSelection(i, i, false, false);
            }
        }
    }

    @Override
    public boolean updateFields() {
        int n = 0;
        if (this.actionPanel instanceof CustomActionPropertiesPanel) {
            n = ((CustomActionPropertiesPanel)this.actionPanel).getSelectedIndex();
        }
        int n2 = this.table.getSelectedRow();
        int n3 = this.table.getRowCount();
        if (this.table.getCellEditor() != null) {
            this.table.getCellEditor().cancelCellEditing();
        }
        ((AbstractTableModel)this.table.getModel()).fireTableDataChanged();
        if (n3 == this.table.getRowCount() && n2 != -1) {
            this.table.changeSelection(n2, 0, false, false);
            boolean bl = false;
            if (this.actionPanel != null && this.actionPanel instanceof Updateable) {
                bl = ((Updateable)((Object)this.actionPanel)).updateFields();
            }
            if (!bl && this.actionPanel != null) {
                this.actionPropertiesPanel.removeAll();
                if (n2 != -1 && n2 < this.dataControl.getActions().size()) {
                    ActionDataControl actionDataControl = this.dataControl.getActions().get(n2);
                    if (actionDataControl instanceof CustomActionDataControl) {
                        this.actionPanel = new CustomActionPropertiesPanel((CustomActionDataControl)actionDataControl);
                        ((CustomActionPropertiesPanel)this.actionPanel).setSelectedIndex(n);
                        this.actionPropertiesPanel.add((Component)this.actionPanel, "Center");
                    } else if (actionDataControl instanceof ActionDataControl) {
                        this.actionPanel = new ActionPropertiesPanel(actionDataControl);
                        this.actionPropertiesPanel.add((Component)this.actionPanel, "Center");
                    }
                }
            }
        }
        return true;
    }
}

