/*
 * Decompiled with CFR 0.152.
 */
package es.eucm.eadventure.editor.gui.elementpanels.general;

import es.eucm.eadventure.common.data.Documented;
import es.eucm.eadventure.common.gui.TC;
import es.eucm.eadventure.editor.control.Controller;
import es.eucm.eadventure.editor.control.controllers.general.ActionDataControl;
import es.eucm.eadventure.editor.control.tools.generic.ChangeBooleanValueTool;
import es.eucm.eadventure.editor.control.tools.listeners.DocumentationChangeListener;
import es.eucm.eadventure.editor.gui.Updateable;
import es.eucm.eadventure.editor.gui.editdialogs.EffectsDialog;
import es.eucm.eadventure.editor.gui.editdialogs.effectdialogs.MacroReferenceEffectDialog;
import es.eucm.eadventure.editor.gui.elementpanels.general.ActionTypePanel;
import es.eucm.eadventure.editor.gui.elementpanels.general.EffectsPanel;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;

public class ActionPropertiesPanel
extends JPanel
implements ActionTypePanel,
Updateable {
    private static final long serialVersionUID = 1L;
    private JTextArea documentationTextArea;
    private ActionDataControl actionDataControl;
    private EffectsPanel effectsPanel;

    public ActionPropertiesPanel(ActionDataControl actionDataControl) {
        this.setLayout(new GridBagLayout());
        this.actionDataControl = actionDataControl;
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridLayout());
        this.documentationTextArea = new JTextArea(actionDataControl.getDocumentation(), 4, 0);
        this.documentationTextArea.setLineWrap(true);
        this.documentationTextArea.setWrapStyleWord(true);
        this.documentationTextArea.getDocument().addDocumentListener(new DocumentationChangeListener(this.documentationTextArea, (Documented)actionDataControl.getContent()));
        jPanel.add(new JScrollPane(this.documentationTextArea, 22, 31));
        jPanel.setMinimumSize(new Dimension(0, 108));
        jPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), TC.get((String)"Action.Documentation")));
        this.add((Component)jPanel, gridBagConstraints);
        ++gridBagConstraints.gridy;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        MacroReferenceEffectDialog.ID = null;
        this.effectsPanel = new EffectsPanel(actionDataControl.getEffects());
        this.add((Component)this.effectsPanel, gridBagConstraints);
        ++gridBagConstraints.gridy;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.ipady = -3;
        this.add((Component)this.editNotEffects(), gridBagConstraints);
    }

    private JPanel editNotEffects() {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        JPanel jPanel = new JPanel(new GridBagLayout());
        final JButton jButton = new JButton(TC.get((String)"Exit.EditNotEffects"));
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                new EffectsDialog(ActionPropertiesPanel.this.actionDataControl.getNotEffectsController());
            }
        });
        jButton.setEnabled(this.actionDataControl.isActivatedNotEffects());
        final JCheckBox jCheckBox = new JCheckBox(TC.get((String)"Action.ActiveWhenConditionsArent"));
        jCheckBox.setToolTipText(TC.get((String)"Action.ActiveWhenConditionsArent.ToolTip"));
        jCheckBox.setSelected(this.actionDataControl.isActivatedNotEffects());
        jCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Controller.getInstance().addTool(new ChangeBooleanValueTool(ActionPropertiesPanel.this.actionDataControl, jCheckBox.isSelected(), "isActivatedNotEffects", "setActivatedNotEffects"));
                jButton.setEnabled(jCheckBox.isSelected());
            }
        });
        jPanel.add((Component)jCheckBox, gridBagConstraints);
        ++gridBagConstraints.gridy;
        jPanel.add((Component)jButton, gridBagConstraints);
        return jPanel;
    }

    @Override
    public int getType() {
        return 0;
    }

    @Override
    public boolean updateFields() {
        return this.effectsPanel.updateFields();
    }
}

