/*
 * Decompiled with CFR 0.152.
 */
package es.eucm.eadventure.editor.gui.elementpanels.cutscene;

import es.eucm.eadventure.common.gui.TC;
import es.eucm.eadventure.editor.control.Controller;
import es.eucm.eadventure.editor.control.controllers.cutscene.CutsceneDataControl;
import es.eucm.eadventure.editor.control.tools.generic.ChangeStringValueTool;
import es.eucm.eadventure.editor.gui.Updateable;
import es.eucm.eadventure.editor.gui.editdialogs.EffectsDialog;
import es.eucm.eadventure.editor.gui.editdialogs.PlayerPositionDialog;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class NextScenePanel
extends JPanel
implements Updateable {
    private static final long serialVersionUID = 9164972283091760862L;
    private CutsceneDataControl dataControl;
    private JRadioButton returnToPrevious;
    private JRadioButton goToNewScene;
    private JRadioButton endChapter;
    private JComboBox nextSceneCombo;
    private JCheckBox usePosition;
    private JButton setPosition;
    private JButton editEffects;
    private JComboBox transition;
    private JSpinner timeSpinner;

    public NextScenePanel(CutsceneDataControl cutsceneDataControl) {
        this.dataControl = cutsceneDataControl;
        this.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), TC.get((String)"Cutscene.CutsceneEndReached")));
        this.returnToPrevious = new JRadioButton(TC.get((String)"Cutscene.ReturnToLastScene"));
        this.goToNewScene = new JRadioButton(TC.get((String)"Cutscene.GoToNextScene"));
        this.endChapter = new JRadioButton(TC.get((String)"Cutscene.ChapterEnd"));
        this.returnToPrevious.addActionListener(new ReturnToPreviousActionListener());
        this.goToNewScene.addActionListener(new GoToNewSceneActionListener());
        this.endChapter.addActionListener(new EndChapterActionListener());
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.returnToPrevious);
        buttonGroup.add(this.goToNewScene);
        buttonGroup.add(this.endChapter);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridLayout(1, 3));
        jPanel.add(this.returnToPrevious);
        jPanel.add(this.goToNewScene);
        jPanel.add(this.endChapter);
        this.setLayout(new BorderLayout());
        this.add((Component)jPanel, "North");
        JPanel jPanel2 = new JPanel();
        this.nextSceneCombo = new JComboBox<String>(Controller.getInstance().getIdentifierSummary().getGeneralSceneIds());
        this.nextSceneCombo.addActionListener(new NextSceneComboBoxListener());
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        this.usePosition = new JCheckBox(TC.get((String)"NextScene.UseDestinyPosition"));
        this.usePosition.addActionListener(new DestinyPositionCheckBoxListener());
        this.setPosition = new JButton(TC.get((String)"NextScene.EditDestinyPositionShort"));
        this.setPosition.addActionListener(new DestinyPositionButtonListener());
        jPanel3.add((Component)this.usePosition, gridBagConstraints);
        ++gridBagConstraints.gridx;
        jPanel3.add((Component)this.setPosition, gridBagConstraints);
        this.editEffects = new JButton(TC.get((String)"GeneralText.EditEffects"));
        this.editEffects.addActionListener(new EffectsButtonListener());
        JPanel jPanel4 = new JPanel();
        String[] stringArray = new String[]{TC.get((String)"NextScene.NoTransition"), TC.get((String)"NextScene.TopToBottom"), TC.get((String)"NextScene.BottomToTop"), TC.get((String)"NextScene.LeftToRight"), TC.get((String)"NextScene.RightToLeft"), TC.get((String)"NextScene.FadeIn")};
        this.transition = new JComboBox<String>(stringArray);
        this.transition.addActionListener(new TransitionComboChangeListener());
        SpinnerNumberModel spinnerNumberModel = new SpinnerNumberModel(0, 0, 5000, 100);
        this.timeSpinner = new JSpinner(spinnerNumberModel);
        this.timeSpinner.addChangeListener(new TransitionSpinnerChangeListener());
        jPanel4.add(new JLabel(TC.get((String)"NextScene.Transition")));
        jPanel4.add(this.transition);
        jPanel4.add(new JLabel(TC.get((String)"NextScene.TransitionTime")));
        jPanel4.add(this.timeSpinner);
        jPanel4.add(new JLabel("seg"));
        jPanel2.setLayout(new GridLayout(0, 1));
        JPanel jPanel5 = new JPanel();
        jPanel5.add(new JLabel(TC.get((String)"NextScene.NextSceneId")));
        jPanel5.add(this.nextSceneCombo);
        jPanel5.add(this.editEffects);
        jPanel2.add(jPanel5);
        if (!Controller.getInstance().isPlayTransparent()) {
            jPanel2.add(jPanel3);
        }
        jPanel2.add(jPanel4);
        this.add((Component)jPanel2, "Center");
        this.updateNextSceneInfo();
    }

    private void updateNextSceneInfo() {
        boolean bl = false;
        boolean bl2 = false;
        if (this.dataControl.getNext() == 1) {
            this.endChapter.setSelected(true);
        } else if (this.dataControl.getNext() == 0) {
            this.returnToPrevious.setSelected(true);
        } else {
            this.goToNewScene.setSelected(true);
            this.nextSceneCombo.setSelectedItem(this.dataControl.getNextSceneId());
            this.usePosition.setSelected(this.dataControl.hasDestinyPosition());
            this.transition.setSelectedIndex(this.dataControl.getTransitionType());
            this.timeSpinner.setValue(this.dataControl.getTransitionTime());
            bl = Controller.getInstance().getIdentifierSummary().isScene(this.dataControl.getNextSceneId());
            bl2 = bl && this.dataControl.hasDestinyPosition();
        }
        this.nextSceneCombo.setEnabled(this.goToNewScene.isSelected());
        this.usePosition.setEnabled(bl && this.goToNewScene.isSelected());
        this.setPosition.setEnabled(bl2 && this.goToNewScene.isSelected());
        this.editEffects.setEnabled(this.goToNewScene.isSelected());
        this.transition.setEnabled(this.goToNewScene.isSelected());
        this.timeSpinner.setEnabled(this.goToNewScene.isSelected());
        this.updateUI();
    }

    @Override
    public boolean updateFields() {
        this.updateNextSceneInfo();
        return true;
    }

    private class EndChapterActionListener
    implements ActionListener {
        private EndChapterActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (NextScenePanel.this.endChapter.isSelected()) {
                NextScenePanel.this.dataControl.setNext(1);
                NextScenePanel.this.updateNextSceneInfo();
            }
        }
    }

    private class GoToNewSceneActionListener
    implements ActionListener {
        private GoToNewSceneActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (NextScenePanel.this.goToNewScene.isSelected()) {
                NextScenePanel.this.dataControl.setNext(2);
                NextScenePanel.this.updateNextSceneInfo();
            }
        }
    }

    private class ReturnToPreviousActionListener
    implements ActionListener {
        private ReturnToPreviousActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (NextScenePanel.this.returnToPrevious.isSelected()) {
                NextScenePanel.this.dataControl.setNext(0);
                NextScenePanel.this.updateNextSceneInfo();
            }
        }
    }

    private class TransitionSpinnerChangeListener
    implements ChangeListener {
        private TransitionSpinnerChangeListener() {
        }

        @Override
        public void stateChanged(ChangeEvent changeEvent) {
            if ((Integer)NextScenePanel.this.timeSpinner.getValue() == 900) {
                NextScenePanel.this.timeSpinner.setValue(new Integer(0));
            } else if ((Integer)NextScenePanel.this.timeSpinner.getValue() == 100) {
                NextScenePanel.this.timeSpinner.setValue(new Integer(1000));
            }
            NextScenePanel.this.dataControl.setTransitionTime((Integer)NextScenePanel.this.timeSpinner.getValue());
        }
    }

    private class TransitionComboChangeListener
    implements ActionListener {
        private TransitionComboChangeListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            NextScenePanel.this.dataControl.setTransitionType(NextScenePanel.this.transition.getSelectedIndex());
        }
    }

    private class EffectsButtonListener
    implements ActionListener {
        private EffectsButtonListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            new EffectsDialog(NextScenePanel.this.dataControl.getEffects());
        }
    }

    private class DestinyPositionButtonListener
    implements ActionListener {
        private DestinyPositionButtonListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            PlayerPositionDialog playerPositionDialog = new PlayerPositionDialog(NextScenePanel.this.nextSceneCombo.getSelectedItem().toString(), NextScenePanel.this.dataControl.getDestinyPositionX(), NextScenePanel.this.dataControl.getDestinyPositionY());
            NextScenePanel.this.dataControl.setDestinyPosition(playerPositionDialog.getPositionX(), playerPositionDialog.getPositionY());
        }
    }

    private class DestinyPositionCheckBoxListener
    implements ActionListener {
        private DestinyPositionCheckBoxListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            NextScenePanel.this.dataControl.toggleDestinyPosition();
            NextScenePanel.this.updateNextSceneInfo();
        }
    }

    private class NextSceneComboBoxListener
    implements ActionListener {
        private NextSceneComboBoxListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            Controller.getInstance().addTool(new ChangeStringValueTool(NextScenePanel.this.dataControl, NextScenePanel.this.nextSceneCombo.getSelectedItem().toString(), "getNextSceneId", "setNextSceneId"));
            NextScenePanel.this.updateNextSceneInfo();
        }
    }
}

