/*
 * Decompiled with CFR 0.152.
 */
package es.eucm.eadventure.editor.gui.elementpanels.conversation.representation.graphicnode;

import es.eucm.eadventure.common.data.chapter.conversation.node.ConversationNodeView;
import es.eucm.eadventure.common.gui.TC;
import es.eucm.eadventure.editor.gui.elementpanels.conversation.representation.graphicnode.GraphicNode;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Polygon;

public class OptionGraphicNode
extends GraphicNode {
    public OptionGraphicNode(ConversationNodeView conversationNodeView, Point point) {
        super(conversationNodeView, point);
    }

    @Override
    public void drawNode(float f, Graphics graphics) {
        Point point = this.getPosition(f);
        int n = (int)(80.0f * f);
        Polygon polygon = this.getPolygon(n);
        polygon.translate(point.x - n / 2, point.y - n / 2);
        graphics.setColor(Color.GREEN);
        graphics.fillPolygon(polygon);
        graphics.setColor(Color.GRAY);
        graphics.drawPolygon(polygon);
        Point point2 = this.getTextPosition(point, f, n);
        graphics.setFont(new Font("Monospaced", 0, (int)(15.0f * f)));
        if (this.node.hasEffects()) {
            graphics.setColor(Color.BLACK);
            graphics.drawString(TC.get((String)"Effects.Title"), (int)point2.getX(), (int)point2.getY());
            point2.setLocation(point2.getX(), point2.getY() - (double)(15.0f * f));
        }
        if (this.selected) {
            graphics.setColor(Color.RED);
            Graphics2D graphics2D = (Graphics2D)graphics;
            graphics2D.setStroke(new BasicStroke((int)(4.0f * f)));
            graphics2D.drawPolygon(polygon);
            graphics2D.setStroke(new BasicStroke(1.0f));
        }
    }

    private Point getTextPosition(Point point, float f, int n) {
        Point point2 = new Point();
        point2.setLocation(point.getX(), point.getY() + (double)(n / 2) + (double)(5.0f * f));
        return point2;
    }

    @Override
    public boolean isInside(float f, Point point) {
        Point point2 = this.getPosition(f);
        int n = (int)(80.0f * f);
        Polygon polygon = this.getPolygon(n);
        polygon.translate(point2.x - n / 2, point2.y - n / 2);
        return polygon.contains(point);
    }

    private Polygon getPolygon(int n) {
        Polygon polygon = new Polygon();
        polygon.addPoint(-n / 4, n / 2);
        polygon.addPoint(n / 2, n);
        polygon.addPoint(n + n / 4, n / 2);
        polygon.addPoint(n / 2, 0);
        return polygon;
    }
}

