/*
 * Decompiled with CFR 0.152.
 */
package es.eucm.eadventure.editor.gui.elementpanels.conversation.representation.graphicnode;

import es.eucm.eadventure.common.data.chapter.conversation.node.ConversationNodeView;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Point;
import java.util.ArrayList;
import java.util.List;

public class GraphicNode {
    public static final int NODE_RADIUS = 40;
    public static final int NODE_DIAMETER = 80;
    public static final int NODE_SELECTED_RADIUS = 45;
    public static final int NODE_SELECTED_DIAMETER = 90;
    protected ConversationNodeView node;
    protected Point position;
    private List<GraphicNode> children;
    protected boolean selected;
    protected boolean selectedChild;

    public GraphicNode(ConversationNodeView conversationNodeView, Point point) {
        this.node = conversationNodeView;
        this.position = point;
        this.children = new ArrayList<GraphicNode>();
        this.selected = false;
    }

    public void addChild(GraphicNode graphicNode) {
        this.children.add(graphicNode);
    }

    public void removeAllChildren() {
        while (!this.children.isEmpty()) {
            this.children.remove(0);
        }
    }

    public ConversationNodeView getNode() {
        return this.node;
    }

    public int getChildCount() {
        return this.children.size();
    }

    public Point getChildPosition(float f, int n) {
        return this.children.get(n).getPosition(f);
    }

    public GraphicNode getChildNode(int n) {
        return this.children.get(n);
    }

    public Point getPosition(float f) {
        return new Point((int)((float)this.position.x * f), (int)((float)this.position.y * f));
    }

    public void moveNode(Point point) {
        this.position.x += point.x;
        this.position.y += point.y;
        if (this.position.x < 0) {
            this.position.x = 0;
        }
        if (this.position.y < 0) {
            this.position.y = 0;
        }
    }

    public boolean isInside(float f, Point point) {
        double d;
        Point point2 = this.getPosition(f);
        double d2 = point.getX() - point2.getX();
        return Math.sqrt(d2 * d2 + (d = point.getY() - point2.getY()) * d) <= (double)(40.0f * f);
    }

    public void drawNode(float f, Graphics graphics) {
        int n;
        int n2;
        int n3;
        if (this.selected) {
            n3 = (int)((this.position.getX() - 45.0) * (double)f);
            n2 = (int)((this.position.getY() - 45.0) * (double)f);
            n = (int)(90.0f * f);
            graphics.setColor(Color.RED);
            graphics.fillOval(n3, n2, n, n);
        }
        if (this.selectedChild) {
            n3 = (int)((this.position.getX() - 45.0) * (double)f);
            n2 = (int)((this.position.getY() - 45.0) * (double)f);
            n = (int)(90.0f * f);
            graphics.setColor(Color.BLUE);
            graphics.fillOval(n3, n2, n, n);
        }
        graphics.setColor(Color.BLACK);
        n3 = (int)((this.position.getX() - 40.0) * (double)f);
        n2 = (int)((this.position.getY() - 40.0) * (double)f);
        n = (int)(80.0f * f);
        graphics.fillOval(n3, n2, n, n);
    }

    public void setSelected(boolean bl) {
        this.selected = bl;
    }

    public void setSelectedChild(boolean bl) {
        this.selectedChild = bl;
    }
}

