/*
 * Decompiled with CFR 0.152.
 */
package es.eucm.eadventure.editor.gui.elementpanels.conversation.representation.graphicnode;

import es.eucm.eadventure.common.data.chapter.conversation.node.ConversationNodeView;
import es.eucm.eadventure.common.gui.TC;
import es.eucm.eadventure.editor.gui.elementpanels.conversation.representation.graphicnode.GraphicNode;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Polygon;

public class DialogueGraphicNode
extends GraphicNode {
    public DialogueGraphicNode(ConversationNodeView conversationNodeView, Point point) {
        super(conversationNodeView, point);
    }

    @Override
    public void drawNode(float f, Graphics graphics) {
        Graphics2D graphics2D;
        Point point = this.getPosition(f);
        int n = (int)(80.0f * f);
        Polygon polygon = this.getPolygon(n, this.node.isTerminal());
        polygon.translate(point.x - n / 2, point.y - n / 2);
        graphics.setColor(Color.GREEN);
        graphics.fillPolygon(polygon);
        Point point2 = this.getTextPosition(point, f, n, this.node.isTerminal());
        graphics.setFont(new Font("Monospaced", 0, (int)(15.0f * f)));
        if (this.node.hasEffects()) {
            graphics.setColor(Color.BLACK);
            graphics.drawString(TC.get((String)"Effects.Title"), (int)point2.getX(), (int)point2.getY());
            point2.setLocation(point2.getX(), point2.getY() - (double)(15.0f * f));
        }
        graphics.setColor(Color.GRAY);
        graphics.drawPolygon(polygon);
        if (this.selected) {
            graphics.setColor(Color.RED);
            graphics2D = (Graphics2D)graphics;
            graphics2D.setStroke(new BasicStroke((int)(4.0f * f)));
            graphics2D.drawPolygon(polygon);
            graphics2D.setStroke(new BasicStroke(1.0f));
        }
        if (this.selectedChild) {
            graphics.setColor(Color.BLUE);
            graphics2D = (Graphics2D)graphics;
            graphics2D.setStroke(new BasicStroke((int)(4.0f * f)));
            graphics2D.drawPolygon(polygon);
            graphics2D.setStroke(new BasicStroke(1.0f));
        }
    }

    @Override
    public boolean isInside(float f, Point point) {
        Point point2 = this.getPosition(f);
        int n = (int)(80.0f * f);
        Polygon polygon = this.getPolygon(n, this.node.isTerminal());
        polygon.translate(point2.x - n / 2, point2.y - n / 2);
        return polygon.contains(point);
    }

    private Polygon getPolygon(int n, boolean bl) {
        Polygon polygon = new Polygon();
        if (!bl) {
            int n2 = n - n / 6;
            polygon.addPoint(0, 0);
            polygon.addPoint(0, n2);
            polygon.addPoint(n / 8, n2 - n / 8);
            polygon.addPoint(n / 4, n2 - n / 6);
            polygon.addPoint(3 * n / 8, n2 - n / 8);
            polygon.addPoint(n / 2, n2);
            polygon.addPoint(n - 3 * n / 8, n2 + n / 8);
            polygon.addPoint(n - n / 4, n2 + n / 6);
            polygon.addPoint(n - n / 8, n2 + n / 8);
            polygon.addPoint(n, n2);
            polygon.addPoint(n, 0);
        } else {
            polygon.addPoint(n / 2, 0);
            polygon.addPoint(0, n / 2);
            polygon.addPoint(0, n);
            polygon.addPoint(n, n);
            polygon.addPoint(n, n / 2);
        }
        return polygon;
    }

    private Point getTextPosition(Point point, float f, int n, boolean bl) {
        Point point2 = new Point();
        if (!bl) {
            point2.setLocation(point.getX() + (double)(1.0f * f) - (double)(n / 2), point.getY() + (double)(n / 2) - (double)(n / 3) - (double)(1.0f * f));
        } else {
            point2.setLocation(point.getX() + (double)(1.0f * f) - (double)(n / 2), point.getY() + (double)(n / 2) - (double)(1.0f * f));
        }
        return point2;
    }
}

