/*
 * Decompiled with CFR 0.152.
 */
package es.eucm.eadventure.editor.gui.elementpanels.conversation.representation;

import es.eucm.eadventure.common.data.chapter.conversation.node.ConversationNodeView;
import es.eucm.eadventure.editor.control.Controller;
import es.eucm.eadventure.editor.control.config.ConversationConfigData;
import es.eucm.eadventure.editor.control.controllers.conversation.GraphConversationDataControl;
import es.eucm.eadventure.editor.gui.elementpanels.conversation.representation.graphicnode.DialogueGraphicNode;
import es.eucm.eadventure.editor.gui.elementpanels.conversation.representation.graphicnode.GraphicNode;
import es.eucm.eadventure.editor.gui.elementpanels.conversation.representation.graphicnode.InitialGraphicNode;
import es.eucm.eadventure.editor.gui.elementpanels.conversation.representation.graphicnode.OptionGraphicNode;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import java.util.ArrayList;
import java.util.List;

public class GraphicRepresentation {
    private static final int ARROW_SIZE = 15;
    private static final int CONVERSATION_MARGIN = 150;
    private static final int NORMAL = 0;
    private static final int MOUSE_DRAG = 1;
    private int state = 0;
    private GraphConversationDataControl graphConversationDataControl;
    private Dimension conversationSize;
    private Point upperLeftCorner;
    private Point lastPoint;
    private GraphicNode pickedNode;
    private int pickedNodeIndex;
    protected float scale = 1.0f;
    protected List<GraphicNode> graphicNodes;
    protected GraphicNode selectedNode;
    protected GraphicNode selectedChildNode;

    public GraphicRepresentation(GraphConversationDataControl graphConversationDataControl, Dimension dimension) {
        this.graphConversationDataControl = graphConversationDataControl;
        this.graphicNodes = new ArrayList<GraphicNode>();
        boolean bl = ConversationConfigData.isConversationConfig(graphConversationDataControl.getId());
        String string = graphConversationDataControl.getId();
        List<ConversationNodeView> list = graphConversationDataControl.getAllNodesViews();
        double d = (double)(list.size() * 80 * 2) / (Math.PI * 2);
        d = Math.max(50.0, d);
        int n = 50 + (int)d;
        int n2 = 150 + (int)d;
        if (bl) {
            n = ConversationConfigData.getNodeX(string, 0);
            n2 = ConversationConfigData.getNodeY(string, 0);
        } else {
            ConversationConfigData.setNodeX(string, 0, n);
            ConversationConfigData.setNodeY(string, 0, n2);
        }
        this.graphicNodes.add(new InitialGraphicNode(list.get(0), new Point(n, n2)));
        double d2 = 1.5707963267948966;
        for (int i = 1; i < list.size(); ++i) {
            ConversationNodeView conversationNodeView = list.get(i);
            int n3 = n + (int)(Math.cos(d2 += Math.PI * 2 / (double)(list.size() - 1) * (double)(i - 1) * Math.pow(-1.0, i - 1)) * d);
            int n4 = n2 - (int)(Math.sin(d2) * d);
            if (bl) {
                n3 = ConversationConfigData.getNodeX(string, i);
                n4 = ConversationConfigData.getNodeY(string, i);
            } else {
                ConversationConfigData.setNodeX(string, i, n3);
                ConversationConfigData.setNodeY(string, i, n4);
            }
            Point point = new Point(n3, n4);
            if (conversationNodeView.getType() == 0) {
                this.graphicNodes.add(new DialogueGraphicNode(conversationNodeView, point));
                continue;
            }
            if (conversationNodeView.getType() != 1) continue;
            this.graphicNodes.add(new OptionGraphicNode(conversationNodeView, point));
        }
        this.updateLinksBetweenNodes();
        this.updateConversationSize();
        if (!bl) {
            this.setContainerSize(dimension);
        }
    }

    public Dimension getConversationSize() {
        return this.conversationSize;
    }

    public ConversationNodeView getNodeInPosition(Point point) {
        ConversationNodeView conversationNodeView = null;
        for (int i = 0; i < this.graphicNodes.size() && conversationNodeView == null; ++i) {
            if (!this.graphicNodes.get(i).isInside(this.scale, point)) continue;
            conversationNodeView = this.graphicNodes.get(i).getNode();
        }
        return conversationNodeView;
    }

    public Point getPositionOfNode(ConversationNodeView conversationNodeView) {
        Point point = null;
        for (int i = 0; i < this.graphicNodes.size() && point == null; ++i) {
            if (this.graphicNodes.get(i).getNode() != conversationNodeView) continue;
            point = this.graphicNodes.get(i).getPosition(this.scale);
        }
        return point;
    }

    public void setContainerSize(Dimension dimension) {
        int n = dimension.getWidth() < this.conversationSize.getWidth() ? 0 : dimension.width / 2 - this.conversationSize.width / 2;
        int n2 = dimension.getHeight() < this.conversationSize.getHeight() ? 0 : dimension.height / 2 - this.conversationSize.height / 2;
        Point point = new Point(n - this.upperLeftCorner.x, n2 - this.upperLeftCorner.y);
        if (point.x != 0 || point.y != 0) {
            for (int i = 0; i < this.graphicNodes.size(); ++i) {
                this.graphicNodes.get(i).moveNode(point);
                String string = this.graphConversationDataControl.getId();
                ConversationConfigData.setNodePos(string, i, this.graphicNodes.get(i).getPosition(1.0f));
            }
        }
        this.upperLeftCorner.x = (int)((double)this.upperLeftCorner.x + point.getX());
        this.upperLeftCorner.y = (int)((double)this.upperLeftCorner.y + point.getY());
    }

    public void drawConversation(Graphics graphics) {
        GraphicNode graphicNode;
        int n;
        graphics.setColor(Color.BLACK);
        for (n = 0; n < this.graphicNodes.size(); ++n) {
            graphicNode = this.graphicNodes.get(n);
            graphics.setColor(Color.BLACK);
            for (int i = 0; i < graphicNode.getChildCount(); ++i) {
                Object object;
                Point point = graphicNode.getChildPosition(this.scale, i);
                if (this.graphicNodes.get(n) == this.selectedNode) {
                    graphics.setColor(Controller.generateColor(i));
                    if (graphicNode instanceof OptionGraphicNode) {
                        object = graphicNode.getNode().getLineText(i);
                        double d = graphicNode.getPosition(this.scale).getX();
                        double d2 = graphicNode.getPosition(this.scale).getY();
                        double d3 = point.getX();
                        double d4 = point.getY();
                        double d5 = Math.sqrt(Math.pow(d - d3, 2.0) + Math.pow(d2 - d4, 2.0));
                        double d6 = d - 80.0 * (d - d3) * (double)this.scale / d5;
                        double d7 = d2 - 80.0 * (d2 - d4) * (double)this.scale / d5;
                        if (((String)object).length() > 15) {
                            object = ((String)object).substring(0, 12) + "...";
                        }
                        graphics.drawString((String)object, (int)d6, (int)d7);
                    }
                } else if (graphicNode instanceof OptionGraphicNode && ((GraphicNode)(object = (OptionGraphicNode)graphicNode)).getChildNode(i) == this.selectedNode) {
                    String string = ((GraphicNode)object).getNode().getLineText(i);
                    double d = ((GraphicNode)object).getPosition(this.scale).getX();
                    double d8 = ((GraphicNode)object).getPosition(this.scale).getY();
                    double d9 = point.getX();
                    double d10 = point.getY();
                    double d11 = Math.sqrt(Math.pow(d - d9, 2.0) + Math.pow(d8 - d10, 2.0));
                    double d12 = d - 80.0 * (d - d9) * (double)this.scale / d11;
                    double d13 = d8 - 80.0 * (d8 - d10) * (double)this.scale / d11;
                    if (string.length() > 15) {
                        string = string.substring(0, 12) + "...";
                    }
                    graphics.drawString(string, (int)d12, (int)d13);
                }
                graphics.drawLine((int)graphicNode.getPosition(this.scale).getX(), (int)graphicNode.getPosition(this.scale).getY(), (int)point.getX(), (int)point.getY());
                this.drawArrow(graphics, graphicNode.getChildNode(i), graphicNode.getPosition(this.scale), point);
            }
        }
        for (n = 0; n < this.graphicNodes.size(); ++n) {
            graphicNode = this.graphicNodes.get(n);
            graphicNode.drawNode(this.scale, graphics);
        }
    }

    public void update() {
        ConversationNodeView conversationNodeView;
        int n;
        List<ConversationNodeView> list = this.graphConversationDataControl.getAllNodesViews();
        ArrayList<ConversationNodeView> arrayList = new ArrayList<ConversationNodeView>();
        ArrayList<GraphicNode> arrayList2 = new ArrayList<GraphicNode>();
        for (n = 0; n < list.size(); ++n) {
            arrayList2.add(null);
        }
        for (n = 0; n < list.size(); ++n) {
            int n2;
            conversationNodeView = list.get(n);
            GraphicNode graphicNode = null;
            for (n2 = 0; n2 < this.graphicNodes.size() && graphicNode == null; ++n2) {
                if (this.graphicNodes.get(n2).getNode() != conversationNodeView) continue;
                graphicNode = this.graphicNodes.get(n2);
            }
            if (graphicNode != null) {
                n2 = list.indexOf(conversationNodeView);
                arrayList2.set(n2, graphicNode);
                continue;
            }
            arrayList.add(conversationNodeView);
        }
        if (arrayList.size() > 0) {
            for (n = 0; n < arrayList.size(); ++n) {
                conversationNodeView = (ConversationNodeView)arrayList.get(n);
                int n3 = list.indexOf(conversationNodeView);
                Point point = this.getPositionOfOldestBrother(conversationNodeView);
                point.x += 100;
                if (point.x == Integer.MIN_VALUE || point.y == Integer.MIN_VALUE) {
                    point = this.getPositionOfFather(conversationNodeView);
                    point.y += 100;
                }
                ConversationConfigData.setNodePos(this.graphConversationDataControl.getId(), n3, point);
                if (conversationNodeView.getType() == 0) {
                    arrayList2.set(n3, new DialogueGraphicNode(conversationNodeView, point));
                    continue;
                }
                arrayList2.set(n3, new OptionGraphicNode(conversationNodeView, point));
            }
        }
        this.graphicNodes = arrayList2;
        this.updateLinksBetweenNodes();
        this.updateConversationSize();
    }

    private Point getPositionOfFather(ConversationNodeView conversationNodeView) {
        ConversationNodeView conversationNodeView2 = null;
        List<ConversationNodeView> list = this.graphConversationDataControl.getAllNodesViews();
        for (int i = 0; i < list.size() && conversationNodeView2 == null; ++i) {
            ConversationNodeView conversationNodeView3 = list.get(i);
            for (int j = 0; j < conversationNodeView3.getChildCount(); ++j) {
                if (conversationNodeView3.getChildView(j) != conversationNodeView) continue;
                conversationNodeView2 = conversationNodeView3;
            }
        }
        return new Point(this.graphicNodes.get(list.indexOf(conversationNodeView2)).getPosition(this.scale));
    }

    private Point getPositionOfOldestBrother(ConversationNodeView conversationNodeView) {
        ConversationNodeView conversationNodeView2 = null;
        List<ConversationNodeView> list = this.graphConversationDataControl.getAllNodesViews();
        for (int i = 0; i < list.size() && conversationNodeView2 == null; ++i) {
            ConversationNodeView conversationNodeView3 = list.get(i);
            for (int j = 0; j < conversationNodeView3.getChildCount(); ++j) {
                if (conversationNodeView3.getChildView(j) != conversationNodeView) continue;
                conversationNodeView2 = conversationNodeView3;
            }
        }
        Point point = new Point(Integer.MIN_VALUE, Integer.MIN_VALUE);
        if (conversationNodeView2 != null) {
            for (int i = 0; i < conversationNodeView2.getChildCount(); ++i) {
                if (conversationNodeView2.getChildView(i) == conversationNodeView) continue;
                ConversationNodeView conversationNodeView4 = conversationNodeView2.getChildView(i);
                if (this.graphicNodes.get((int)list.indexOf((Object)conversationNodeView4)).getPosition((float)this.scale).x <= point.x) continue;
                point = this.graphicNodes.get(list.indexOf(conversationNodeView4)).getPosition(this.scale);
            }
        }
        return (Point)point.clone();
    }

    public void mousePressed(Point point) {
        this.pickedNode = null;
        for (int i = this.graphicNodes.size() - 1; i >= 0 && this.pickedNode == null; --i) {
            if (!this.graphicNodes.get(i).isInside(this.scale, point)) continue;
            this.pickedNode = this.graphicNodes.get(i);
            this.pickedNodeIndex = i;
        }
        if (this.pickedNode != null && this.state == 0) {
            this.lastPoint = point;
            this.state = 1;
        }
    }

    public boolean mouseDragged(Point point) {
        boolean bl = false;
        if (this.state == 1) {
            Point point2 = new Point((int)((float)(point.x - this.lastPoint.x) / this.scale), (int)((float)(point.y - this.lastPoint.y) / this.scale));
            this.pickedNode.moveNode(point2);
            String string = this.graphConversationDataControl.getId();
            ConversationConfigData.setNodePos(string, this.pickedNodeIndex, this.pickedNode.getPosition(1.0f));
            this.lastPoint = point;
            bl = true;
        }
        return bl;
    }

    public boolean mouseReleased() {
        boolean bl = false;
        if (this.state == 1) {
            this.updateConversationSize();
            this.state = 0;
            bl = true;
        }
        return bl;
    }

    protected void drawArrow(Graphics graphics, GraphicNode graphicNode, Point point, Point point2) {
        double d = 0.0;
        double d2 = point.getX() - point2.getX();
        double d3 = point.getY() - point2.getY();
        if (d2 == 0.0 && d3 > 0.0) {
            d = 1.5707963267948966;
        }
        if (d2 == 0.0 && d3 < 0.0) {
            d = 4.71238898038469;
        }
        if (d2 > 0.0) {
            d = Math.atan(d3 / d2);
        }
        if (d2 < 0.0) {
            d = Math.atan(d3 / d2) + Math.PI;
        }
        int[] nArray = new int[3];
        int[] nArray2 = new int[3];
        boolean bl = false;
        int n = 0;
        while (!bl) {
            nArray[0] = (int)(point2.getX() + Math.cos(d) * (double)n * (double)this.scale);
            nArray2[0] = (int)(point2.getY() + Math.sin(d) * (double)n * (double)this.scale);
            if (!graphicNode.isInside(this.scale, new Point(nArray[0], nArray2[0]))) {
                bl = true;
                continue;
            }
            ++n;
        }
        nArray[1] = (int)((double)nArray[0] + Math.cos(d + 0.4) * 15.0 * (double)this.scale);
        nArray2[1] = (int)((double)nArray2[0] + Math.sin(d + 0.4) * 15.0 * (double)this.scale);
        nArray[2] = (int)((double)nArray[0] + Math.cos(d - 0.4) * 15.0 * (double)this.scale);
        nArray2[2] = (int)((double)nArray2[0] + Math.sin(d - 0.4) * 15.0 * (double)this.scale);
        graphics.fillPolygon(nArray, nArray2, 3);
    }

    public float getScale() {
        return this.scale;
    }

    public void setScale(float f) {
        this.scale = f;
    }

    public void setSelectedNode(ConversationNodeView conversationNodeView) {
        if (this.selectedNode != null) {
            this.selectedNode.setSelected(false);
        }
        this.selectedNode = null;
        for (GraphicNode graphicNode : this.graphicNodes) {
            if (graphicNode.getNode() != conversationNodeView) continue;
            this.selectedNode = graphicNode;
        }
        if (this.selectedNode != null) {
            this.selectedNode.setSelected(true);
        }
    }

    public Point getSelectedNodePosition() {
        if (this.selectedNode != null) {
            return this.selectedNode.getPosition(this.scale);
        }
        return null;
    }

    public void setSelectedChildNode(ConversationNodeView conversationNodeView) {
        if (this.selectedChildNode != null) {
            this.selectedChildNode.setSelectedChild(false);
        }
        this.selectedChildNode = null;
        for (GraphicNode graphicNode : this.graphicNodes) {
            if (graphicNode.getNode() != conversationNodeView) continue;
            this.selectedChildNode = graphicNode;
        }
        if (this.selectedChildNode != null) {
            this.selectedChildNode.setSelectedChild(true);
        }
    }

    private void updateLinksBetweenNodes() {
        List<ConversationNodeView> list = this.graphConversationDataControl.getAllNodesViews();
        for (int i = 0; i < this.graphicNodes.size(); ++i) {
            GraphicNode graphicNode = this.graphicNodes.get(i);
            ConversationNodeView conversationNodeView = list.get(i);
            graphicNode.removeAllChildren();
            for (int j = 0; j < conversationNodeView.getChildCount(); ++j) {
                int n = list.indexOf(conversationNodeView.getChildView(j));
                graphicNode.addChild(this.graphicNodes.get(n));
            }
        }
    }

    private void updateConversationSize() {
        int n;
        int n2 = Integer.MIN_VALUE;
        int n3 = Integer.MAX_VALUE;
        int n4 = Integer.MAX_VALUE;
        int n5 = Integer.MIN_VALUE;
        for (n = 0; n < this.graphicNodes.size(); ++n) {
            Point point = this.graphicNodes.get(n).getPosition(this.scale);
            n2 = Math.max(n2, point.x);
            n3 = Math.min(n3, point.x);
            n4 = Math.min(n4, point.y);
            n5 = Math.max(n5, point.y);
        }
        n = (n2 += 150) - (n3 -= 150);
        int n6 = (n5 += 150) - (n4 -= 150);
        this.conversationSize = new Dimension(n, n6);
        this.upperLeftCorner = new Point(n3, n4);
    }
}

