/*
 * Decompiled with CFR 0.152.
 */
package es.eucm.eadventure.editor.gui.elementpanels.conversation;

import es.eucm.eadventure.common.data.chapter.conversation.node.ConversationNodeView;
import es.eucm.eadventure.common.gui.TC;
import es.eucm.eadventure.editor.control.Controller;
import es.eucm.eadventure.editor.gui.auxiliar.components.TalkTextField;
import es.eucm.eadventure.editor.gui.elementpanels.conversation.LinesPanel;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import javax.swing.AbstractCellEditor;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.JTextPane;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;

public class TextLineCellRendererEditor
extends AbstractCellEditor
implements TableCellEditor,
TableCellRenderer {
    private static final long serialVersionUID = 8128260157985286632L;
    private String value;
    private JTextPane textPane;
    private LinesPanel linesPanel;

    public TextLineCellRendererEditor(LinesPanel linesPanel) {
        this.linesPanel = linesPanel;
    }

    @Override
    public Object getCellEditorValue() {
        return this.value;
    }

    @Override
    public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
        ConversationNodeView conversationNodeView = (ConversationNodeView)object;
        this.value = conversationNodeView.getLineText(n);
        Color color = this.getColor(conversationNodeView, n);
        this.textPane = new JTextPane();
        if (this.value.contains(TC.get((String)"ConversationLine.DefaultText") + "\n")) {
            this.value = this.value.substring(0, this.value.indexOf("\n"));
        }
        this.textPane.setText(this.value);
        this.textPane.setAutoscrolls(true);
        this.textPane.setForeground(color);
        this.textPane.setMaximumSize(new Dimension(300, 20));
        this.textPane.addFocusListener(new TextLineFocus());
        this.textPane.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent documentEvent) {
                TextLineCellRendererEditor.this.value = TextLineCellRendererEditor.this.textPane.getText();
            }

            @Override
            public void insertUpdate(DocumentEvent documentEvent) {
                TextLineCellRendererEditor.this.value = TextLineCellRendererEditor.this.textPane.getText();
            }

            @Override
            public void removeUpdate(DocumentEvent documentEvent) {
                TextLineCellRendererEditor.this.value = TextLineCellRendererEditor.this.textPane.getText();
            }
        });
        this.textPane.addKeyListener(new KeyListener(){

            @Override
            public void keyPressed(KeyEvent keyEvent) {
                if (keyEvent.getKeyCode() == 10) {
                    TextLineCellRendererEditor.this.value = TextLineCellRendererEditor.this.textPane.getText();
                    TextLineCellRendererEditor.this.stopCellEditing();
                    TextLineCellRendererEditor.this.linesPanel.editNextLine();
                    TextLineCellRendererEditor.this.textPane.setText(TC.get((String)"ConversationLine.DefaultText"));
                }
            }

            @Override
            public void keyReleased(KeyEvent keyEvent) {
            }

            @Override
            public void keyTyped(KeyEvent keyEvent) {
            }
        });
        TalkTextField talkTextField = new TalkTextField(this.textPane);
        talkTextField.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent focusEvent) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        TextLineCellRendererEditor.this.textPane.selectAll();
                        TextLineCellRendererEditor.this.textPane.requestFocusInWindow();
                    }
                });
            }

            @Override
            public void focusLost(FocusEvent focusEvent) {
            }
        });
        return talkTextField;
    }

    @Override
    public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
        ConversationNodeView conversationNodeView = (ConversationNodeView)object;
        Color color = this.getColor(conversationNodeView, n);
        if (bl) {
            JTextPane jTextPane = new JTextPane();
            jTextPane.setText(conversationNodeView.getLineText(n));
            jTextPane.setForeground(color);
            jTextPane.setAutoscrolls(true);
            return jTextPane;
        }
        JLabel jLabel = new JLabel(conversationNodeView.getLineText(n));
        jLabel.setForeground(color);
        return jLabel;
    }

    private Color getColor(ConversationNodeView conversationNodeView, int n) {
        Color color = Controller.generateColor(n);
        if (conversationNodeView.getType() == 0) {
            String string = conversationNodeView.getLineName(n);
            color = Controller.generateColor(0);
            String[] stringArray = Controller.getInstance().getIdentifierSummary().getNPCIds();
            for (int i = 0; i < stringArray.length; ++i) {
                if (!stringArray[i].equals(string)) continue;
                color = Controller.generateColor(i + 1);
            }
        }
        return color;
    }

    private class TextLineFocus
    implements FocusListener {
        private int selectedLine;
        private ConversationNodeView node;

        public TextLineFocus() {
            this.selectedLine = TextLineCellRendererEditor.this.linesPanel.getLineTable().getSelectedRow();
            this.node = TextLineCellRendererEditor.this.linesPanel.getSelectedNode();
        }

        @Override
        public void focusGained(FocusEvent focusEvent) {
        }

        @Override
        public void focusLost(FocusEvent focusEvent) {
            if (this.selectedLine == TextLineCellRendererEditor.this.linesPanel.getLineTable().getSelectedRow()) {
                TextLineCellRendererEditor.this.linesPanel.getLineTable().modifyConversationLineOutTable(TextLineCellRendererEditor.this.value);
            } else if (TextLineCellRendererEditor.this.linesPanel.getLineTable().getSelectedRow() == -1) {
                TextLineCellRendererEditor.this.linesPanel.getLineTable().modifyConversationLineOutTable(TextLineCellRendererEditor.this.value, this.node, this.selectedLine);
            }
        }
    }
}

