/*
 * Decompiled with CFR 0.152.
 */
package es.eucm.eadventure.editor.gui.elementpanels.conversation;

import com.sun.speech.freetts.Voice;
import com.sun.speech.freetts.VoiceManager;
import es.eucm.eadventure.common.data.chapter.conversation.node.ConversationNodeView;
import es.eucm.eadventure.common.gui.TC;
import es.eucm.eadventure.editor.control.Controller;
import es.eucm.eadventure.editor.control.controllers.character.NPCDataControl;
import es.eucm.eadventure.editor.control.controllers.character.PlayerDataControl;
import es.eucm.eadventure.editor.control.tools.generic.ChangeBooleanValueTool;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractCellEditor;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;

public class SynthesizeCellRendererEditor
extends AbstractCellEditor
implements TableCellEditor,
TableCellRenderer {
    private static final long serialVersionUID = 8128260157985286632L;
    private ConversationNodeView value;
    private String voiceName;

    @Override
    public Object getCellEditorValue() {
        return this.value;
    }

    @Override
    public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
        if (object == null) {
            return null;
        }
        this.value = (ConversationNodeView)object;
        return this.createPanel(n, bl, jTable);
    }

    @Override
    public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
        if (object == null) {
            return null;
        }
        this.value = (ConversationNodeView)object;
        if (!bl) {
            JCheckBox jCheckBox = new JCheckBox(TC.get((String)"Conversations.Synthesize"));
            jCheckBox.setSelected(this.value.getConversationLine(n).getSynthesizerVoice());
            jCheckBox.setEnabled(bl && this.canSynthesize(n));
            jCheckBox.setOpaque(false);
            return jCheckBox;
        }
        return this.createPanel(n, bl, jTable);
    }

    private JPanel createPanel(int n, boolean bl, JTable jTable) {
        final int n2 = n;
        JPanel jPanel = new JPanel();
        if (!bl) {
            jPanel.setBackground(jTable.getBackground());
        } else {
            jPanel.setBackground(jTable.getSelectionBackground());
        }
        jPanel.setLayout(new GridLayout(2, 1));
        JCheckBox jCheckBox = new JCheckBox(TC.get((String)"Conversations.Synthesize"));
        jCheckBox.setSelected(this.value.getConversationLine(n).getSynthesizerVoice());
        jCheckBox.setEnabled(bl && this.canSynthesize(n));
        jCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Controller.getInstance().addTool(new ChangeBooleanValueTool(SynthesizeCellRendererEditor.this.value.getConversationLine(n2), ((JCheckBox)actionEvent.getSource()).isSelected(), "getSynthesizerVoice", "setSynthesizerVoice"));
            }
        });
        jCheckBox.setOpaque(false);
        jPanel.add(jCheckBox);
        JButton jButton = new JButton(TC.get((String)"Conversations.Listen"));
        jButton.setFocusable(false);
        jButton.setEnabled(bl && this.canSynthesize(n));
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                VoiceManager voiceManager = VoiceManager.getInstance();
                Voice voice = voiceManager.getVoice(SynthesizeCellRendererEditor.this.voiceName);
                voice.allocate();
                voice.speak(SynthesizeCellRendererEditor.this.value.getLineText(n2));
            }
        });
        jButton.setOpaque(false);
        jPanel.add(jButton);
        return jPanel;
    }

    private boolean canSynthesize(int n) {
        Controller controller = Controller.getInstance();
        boolean bl = false;
        NPCDataControl nPCDataControl = null;
        String string = this.value.getLineName(n);
        if (!string.equals("")) {
            if (string.equals("Player")) {
                nPCDataControl = controller.getSelectedChapterDataControl().getPlayer();
                bl = true;
            } else {
                for (NPCDataControl nPCDataControl2 : controller.getSelectedChapterDataControl().getNPCsList().getNPCs()) {
                    if (!string.equals(nPCDataControl2.getId())) continue;
                    nPCDataControl = nPCDataControl2;
                    break;
                }
            }
        }
        if (nPCDataControl != null) {
            if (bl) {
                if (((PlayerDataControl)nPCDataControl).getVoice() == null || nPCDataControl.getVoice().equals("")) {
                    return false;
                }
                this.voiceName = nPCDataControl.getVoice();
                return true;
            }
            if (((NPCDataControl)nPCDataControl).getVoice() == null || ((NPCDataControl)nPCDataControl).getVoice().equals("")) {
                return false;
            }
            this.voiceName = ((NPCDataControl)nPCDataControl).getVoice();
            return true;
        }
        return false;
    }
}

