/*
 * Decompiled with CFR 0.152.
 */
package es.eucm.eadventure.editor.gui.elementpanels.conversation;

import java.awt.Dimension;
import java.awt.Insets;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.BevelBorder;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;

public class StatusBar
extends JPanel {
    private static final long serialVersionUID = 1L;
    private static final int HEIGHT = 20;
    private int areasCount;
    private JLabel[] areas;
    private Border areaBorder;

    public StatusBar() {
        this(1);
    }

    public StatusBar(String string) {
        this(1);
        this.setText(string);
    }

    public StatusBar(String[] stringArray) {
        this(stringArray.length);
        for (int i = 0; i < this.areasCount; ++i) {
            this.setText(i, stringArray[i]);
        }
    }

    public StatusBar(int n) {
        this.areasCount = n;
        this.areas = new JLabel[n];
        this.areaBorder = new CompoundBorder(new EmptyBorder(new Insets(0, 1, 0, 1)), new BevelBorder(1));
        this.setPreferredSize(new Dimension(0, 20));
        BoxLayout boxLayout = new BoxLayout(this, 0);
        this.setLayout(boxLayout);
        for (int i = 0; i < n; ++i) {
            this.areas[i] = new JLabel();
            this.areas[i].setBorder(this.areaBorder);
            this.areas[i].setMaximumSize(new Dimension(Short.MAX_VALUE, 20));
            this.areas[i].setPreferredSize(new Dimension(20, 20));
            this.add(this.areas[i]);
            if (i >= n - 1) continue;
            this.add(Box.createRigidArea(new Dimension(2, 20)));
        }
    }

    public void setAreaWidth(int n, int n2) {
        this.areas[n].setMaximumSize(new Dimension(n2, 20));
        this.areas[n].setPreferredSize(new Dimension(n2, 20));
    }

    public void resetAreaWidth(int n) {
        this.areas[n].setMaximumSize(new Dimension(Short.MAX_VALUE, 20));
        this.areas[n].setPreferredSize(new Dimension(20, 20));
    }

    public void setText(int n, String string) {
        this.areas[n].setText(string);
    }

    public void setText(String string) {
        this.setText(0, string);
    }
}

