/*
 * Decompiled with CFR 0.152.
 */
package es.eucm.eadventure.editor.gui.elementpanels.conversation;

import es.eucm.eadventure.editor.control.config.ConversationConfigData;
import es.eucm.eadventure.editor.control.controllers.conversation.ConversationDataControl;
import es.eucm.eadventure.editor.control.controllers.conversation.GraphConversationDataControl;
import es.eucm.eadventure.editor.gui.elementpanels.conversation.ConversationEditionPanel;
import es.eucm.eadventure.editor.gui.elementpanels.conversation.ConversationPanelMouseListener;
import es.eucm.eadventure.editor.gui.elementpanels.conversation.MenuPanel;
import es.eucm.eadventure.editor.gui.elementpanels.conversation.representation.GraphicRepresentation;
import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import javax.swing.ImageIcon;
import javax.swing.JPanel;

class RepresentationPanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    public static final int NORMAL = 0;
    public static final int WAITING_SECOND_NODE_TO_MOVE = 1;
    public static final int WAITING_SECOND_NODE_TO_LINK = 2;
    private int state = 0;
    private ConversationDataControl conversationDataControl;
    private GraphicRepresentation conversationRepresentation;
    private ConversationEditionPanel conversationPanel;
    private MenuPanel menuPanel;

    public RepresentationPanel(ConversationEditionPanel conversationEditionPanel, ConversationDataControl conversationDataControl) {
        this.conversationPanel = conversationEditionPanel;
        this.conversationDataControl = conversationDataControl;
        this.conversationRepresentation = new GraphicRepresentation((GraphConversationDataControl)conversationDataControl, this.getSize());
        this.setLayout(null);
        this.menuPanel = new MenuPanel(conversationDataControl, this.conversationPanel);
        this.add(this.menuPanel);
        ConversationPanelMouseListener conversationPanelMouseListener = new ConversationPanelMouseListener(this.conversationRepresentation, conversationDataControl, this.conversationPanel, this);
        this.addMouseListener(conversationPanelMouseListener);
        this.addMouseMotionListener(conversationPanelMouseListener);
        this.addComponentListener(new ConversationPanelComponentListener());
        this.setPreferredSize(this.conversationRepresentation.getConversationSize());
        this.revalidate();
    }

    public void updateRepresentation() {
        this.conversationRepresentation.update();
        this.setPreferredSize(this.conversationRepresentation.getConversationSize());
        this.revalidate();
        this.repaint();
    }

    @Override
    public void paintComponent(Graphics graphics) {
        Point point;
        super.paintComponent(graphics);
        if (this.conversationRepresentation != null) {
            this.conversationRepresentation.setSelectedNode(this.conversationPanel.getSelectedNode());
            this.conversationRepresentation.setSelectedChildNode(this.conversationPanel.getSelectedChild());
            this.conversationRepresentation.drawConversation(graphics);
        }
        if ((point = this.conversationRepresentation.getSelectedNodePosition()) == null) {
            this.menuPanel.setVisible(false);
        } else {
            int n = (int)(point.getX() + (double)(40.0f * this.conversationRepresentation.getScale()));
            int n2 = (int)(point.getY() + (double)(40.0f * this.conversationRepresentation.getScale() / 2.0f));
            if ((double)n + this.menuPanel.getSize().getWidth() > (double)this.conversationPanel.getScrollXValue() + this.conversationPanel.getScrollSize().getWidth()) {
                n = (int)(point.getX() - (double)(40.0f * this.conversationRepresentation.getScale()) - (double)this.menuPanel.getWidth());
            }
            if ((double)n2 + this.menuPanel.getSize().getHeight() > (double)this.conversationPanel.getScrollYValue() + this.conversationPanel.getScrollSize().getHeight()) {
                n2 = (int)(point.getY() - (double)(40.0f * this.conversationRepresentation.getScale()) - (double)this.menuPanel.getHeight());
            }
            this.menuPanel.setLocation(n, n2);
            if (this.state == 2) {
                this.menuPanel.setVisible(false);
            } else {
                this.menuPanel.setVisible(true);
            }
        }
        this.menuPanel.repaint();
    }

    public void changeState(int n) {
        this.state = n;
        switch (this.state) {
            case 0: {
                this.conversationPanel.setCursor(null);
                break;
            }
            case 1: {
                this.conversationPanel.setCursor(null);
                break;
            }
            case 2: {
                ImageIcon imageIcon = new ImageIcon("img/linkNodeCursor.png");
                Cursor cursor = Toolkit.getDefaultToolkit().createCustomCursor(imageIcon.getImage(), new Point(31, 31), "img");
                this.conversationPanel.setCursor(cursor);
            }
        }
    }

    public int getState() {
        return this.state;
    }

    public void setScale(float f) {
        this.conversationRepresentation.setScale(f);
    }

    public MenuPanel getMenuPanel() {
        return this.menuPanel;
    }

    private class ConversationPanelComponentListener
    extends ComponentAdapter {
        private ConversationPanelComponentListener() {
        }

        @Override
        public void componentResized(ComponentEvent componentEvent) {
            boolean bl = ConversationConfigData.isConversationConfig(RepresentationPanel.this.conversationDataControl.getId());
            if (!bl) {
                RepresentationPanel.this.conversationRepresentation.setContainerSize(RepresentationPanel.this.getSize());
            }
            RepresentationPanel.this.repaint();
        }
    }
}

