/*
 * Decompiled with CFR 0.152.
 */
package es.eucm.eadventure.editor.gui.elementpanels.conversation;

import es.eucm.eadventure.common.data.chapter.conversation.node.ConversationNodeView;
import es.eucm.eadventure.common.gui.TC;
import es.eucm.eadventure.editor.control.controllers.conversation.ConversationDataControl;
import es.eucm.eadventure.editor.control.controllers.conversation.GraphConversationDataControl;
import es.eucm.eadventure.editor.gui.elementpanels.conversation.ConversationEditionPanel;
import java.awt.AlphaComposite;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JPanel;

public class MenuPanel
extends JPanel {
    private static final long serialVersionUID = 5188735838478736939L;
    private JButton editEffectButton;
    private JButton addOptionButton;
    private JButton addDialogButton;
    private JButton addNewOptionButton;
    private JButton deleteNodeButton;
    private JButton deleteLinkButton;
    private JButton linkToButton;
    private ConversationDataControl conversationDataControl;
    private ConversationEditionPanel conversationPanel;
    private BufferedImage tempImage;

    public MenuPanel(ConversationDataControl conversationDataControl, ConversationEditionPanel conversationEditionPanel) {
        this.conversationDataControl = conversationDataControl;
        this.conversationPanel = conversationEditionPanel;
        this.setOpaque(false);
        this.setVisible(false);
        ImageIcon imageIcon = new ImageIcon("img/icons/dialogNode.png");
        this.addDialogButton = new JButton(TC.get((String)"Conversation.OptionAddDialogueNode"), imageIcon);
        this.addDialogButton.addActionListener(new AddChildActionListener(0));
        this.addNewOptionButton = new JButton(TC.get((String)"Conversation.OptionAddNewOption"), imageIcon);
        this.addNewOptionButton.addActionListener(new AddChildActionListener(0));
        ImageIcon imageIcon2 = new ImageIcon("img/icons/optionNode.png");
        this.addOptionButton = new JButton(TC.get((String)"Conversation.OptionAddOptionNode"), imageIcon2);
        this.addOptionButton.addActionListener(new AddChildActionListener(1));
        ImageIcon imageIcon3 = new ImageIcon("img/icons/deleteNode.png");
        this.deleteNodeButton = new JButton(TC.get((String)"Conversation.OptionDeleteNode"), imageIcon3);
        this.deleteNodeButton.addActionListener(new DeleteNodeActionListener());
        ImageIcon imageIcon4 = new ImageIcon("img/icons/linkNode.png");
        this.linkToButton = new JButton(TC.get((String)"Conversation.OptionLinkNode"), imageIcon4);
        this.linkToButton.addActionListener(new LinkNodeActionListener());
        ImageIcon imageIcon5 = new ImageIcon("img/icons/deleteNodeLink.png");
        this.deleteLinkButton = new JButton(TC.get((String)"Conversation.OperationDeleteLink"), imageIcon5);
        this.deleteLinkButton.addActionListener(new DeleteLinkActionListener());
        this.editEffectButton = new JButton(TC.get((String)"Conversations.EditEffect"));
        this.editEffectButton.addActionListener(new ListenerButtonEditEffect());
    }

    public void setDialoguePanel() {
        this.removeAll();
        this.setLayout(new GridLayout(0, 1));
        this.editEffectButton.setEnabled(true);
        this.add(this.editEffectButton);
        this.add(this.addDialogButton);
        this.addDialogButton.setEnabled(this.conversationDataControl.canAddChild(this.conversationPanel.getSelectedNode(), 0));
        this.add(this.addOptionButton);
        this.addOptionButton.setEnabled(this.conversationDataControl.canAddChild(this.conversationPanel.getSelectedNode(), 1));
        this.setVisible(true);
        this.add(this.deleteNodeButton);
        this.deleteNodeButton.setEnabled(this.conversationDataControl.canDeleteNode(this.conversationPanel.getSelectedNode()));
        this.add(this.linkToButton);
        this.linkToButton.setEnabled(this.conversationDataControl.canLinkNode(this.conversationPanel.getSelectedNode()));
        this.add(this.deleteLinkButton);
        this.deleteLinkButton.setEnabled(this.conversationDataControl.canDeleteLink(this.conversationPanel.getSelectedNode()));
        this.setSize(200, 100);
    }

    public void setOptionPanel() {
        this.removeAll();
        this.setLayout(new GridLayout(0, 1));
        this.add(this.editEffectButton);
        this.add(this.addNewOptionButton);
        this.addNewOptionButton.setEnabled(this.conversationDataControl.canAddChild(this.conversationPanel.getSelectedNode(), 0));
        this.add(this.deleteNodeButton);
        this.deleteNodeButton.setEnabled(this.conversationDataControl.canDeleteNode(this.conversationPanel.getSelectedNode()));
        this.add(this.linkToButton);
        this.linkToButton.setEnabled(this.conversationDataControl.canLinkNode(this.conversationPanel.getSelectedNode()));
        this.setSize(200, 80);
    }

    public void reloadOptions() {
        ConversationNodeView conversationNodeView = this.conversationPanel.getSelectedNode();
        if (conversationNodeView.getType() == 0) {
            this.editEffectButton.setEnabled(true);
            this.addDialogButton.setEnabled(this.conversationDataControl.canAddChild(this.conversationPanel.getSelectedNode(), 0));
            this.addOptionButton.setEnabled(this.conversationDataControl.canAddChild(this.conversationPanel.getSelectedNode(), 1));
            this.linkToButton.setEnabled(this.conversationDataControl.canLinkNode(this.conversationPanel.getSelectedNode()));
            this.deleteLinkButton.setEnabled(this.conversationDataControl.canDeleteLink(this.conversationPanel.getSelectedNode()));
        }
    }

    @Override
    public void paint(Graphics graphics) {
        if (this.getMousePosition() == null && this.tempImage == null) {
            this.tempImage = new BufferedImage(this.getWidth(), this.getHeight(), 6);
            Graphics graphics2 = this.tempImage.getGraphics();
            AlphaComposite alphaComposite = AlphaComposite.getInstance(3, 0.3f);
            ((Graphics2D)graphics2).setComposite(alphaComposite);
            this.paintComponents(graphics2);
        }
        if (this.getMousePosition() == null && this.tempImage != null) {
            graphics.drawImage(this.tempImage, 0, 0, null);
        } else {
            super.paint(graphics);
        }
    }

    private class LinkNodeActionListener
    implements ActionListener {
        private LinkNodeActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (MenuPanel.this.conversationPanel.getState() == 0) {
                MenuPanel.this.conversationPanel.changeState(2);
            }
            MenuPanel.this.conversationPanel.updateRepresentation();
        }
    }

    private class DeleteLinkActionListener
    implements ActionListener {
        private DeleteLinkActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (MenuPanel.this.conversationDataControl.deleteNodeLink(MenuPanel.this.conversationPanel.getSelectedNode())) {
                MenuPanel.this.conversationPanel.setSelectedNode(null);
                MenuPanel.this.conversationPanel.changeState(0);
                MenuPanel.this.conversationPanel.updateRepresentation();
            }
        }
    }

    private class DeleteNodeActionListener
    implements ActionListener {
        private DeleteNodeActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (MenuPanel.this.conversationDataControl.deleteNode(MenuPanel.this.conversationPanel.getSelectedNode())) {
                MenuPanel.this.conversationPanel.setSelectedNode(null);
                MenuPanel.this.conversationPanel.changeState(0);
                MenuPanel.this.conversationPanel.updateRepresentation();
            }
        }
    }

    private class AddChildActionListener
    implements ActionListener {
        private int nodeType;

        public AddChildActionListener(int n) {
            this.nodeType = n;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (MenuPanel.this.conversationDataControl.addChild(MenuPanel.this.conversationPanel.getSelectedNode(), this.nodeType, ((GraphConversationDataControl)MenuPanel.this.conversationDataControl).getAllConditions())) {
                MenuPanel.this.conversationPanel.changeState(0);
                MenuPanel.this.reloadOptions();
                MenuPanel.this.conversationPanel.updateRepresentation();
                MenuPanel.this.addDialogButton.setEnabled(MenuPanel.this.conversationDataControl.canAddChild(MenuPanel.this.conversationPanel.getSelectedNode(), 0));
                MenuPanel.this.addOptionButton.setEnabled(MenuPanel.this.conversationDataControl.canAddChild(MenuPanel.this.conversationPanel.getSelectedNode(), 1));
                MenuPanel.this.linkToButton.setEnabled(MenuPanel.this.conversationDataControl.canLinkNode(MenuPanel.this.conversationPanel.getSelectedNode()));
                MenuPanel.this.deleteLinkButton.setEnabled(MenuPanel.this.conversationDataControl.canDeleteLink(MenuPanel.this.conversationPanel.getSelectedNode()));
            }
        }
    }

    private class ListenerButtonEditEffect
    implements ActionListener {
        private ListenerButtonEditEffect() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            ConversationNodeView conversationNodeView = MenuPanel.this.conversationPanel.getSelectedNode();
            MenuPanel.this.conversationDataControl.editNodeEffects(conversationNodeView);
            MenuPanel.this.conversationPanel.repaint();
        }
    }
}

