/*
 * Decompiled with CFR 0.152.
 */
package es.eucm.eadventure.editor.gui.elementpanels.conversation;

import es.eucm.eadventure.common.data.chapter.conversation.node.ConversationNodeView;
import es.eucm.eadventure.common.gui.TC;
import es.eucm.eadventure.editor.control.Controller;
import es.eucm.eadventure.editor.control.controllers.conversation.ConversationDataControl;
import es.eucm.eadventure.editor.control.controllers.conversation.GraphConversationDataControl;
import es.eucm.eadventure.editor.gui.elementpanels.conversation.AudioCellRendererEditor;
import es.eucm.eadventure.editor.gui.elementpanels.conversation.LinesPanel;
import es.eucm.eadventure.editor.gui.elementpanels.conversation.SynthesizeCellRendererEditor;
import es.eucm.eadventure.editor.gui.elementpanels.conversation.TextLineCellRendererEditor;
import es.eucm.eadventure.editor.gui.elementpanels.general.tables.ConditionsCellRendererEditor;
import java.awt.Dimension;
import java.util.ArrayList;
import javax.swing.DefaultCellEditor;
import javax.swing.JComboBox;
import javax.swing.JTable;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;

public class LinesTable
extends JTable {
    private static final long serialVersionUID = -6962666312669657936L;
    public static final int TEXT_COLUMN = 1;
    private ConversationDataControl conversationDataControl;
    private int lastSelectedConversationLine;
    private ConversationNodeView lastSelectedNode;

    public LinesTable(ConversationDataControl conversationDataControl, LinesPanel linesPanel) {
        String[] stringArray;
        this.conversationDataControl = conversationDataControl;
        this.lastSelectedNode = null;
        this.putClientProperty("terminateEditOnFocusLost", Boolean.TRUE);
        this.setModel(new NodeTableModel(null));
        this.setAutoCreateColumnsFromModel(false);
        this.getColumnModel().getColumn(0).setMaxWidth(90);
        this.getColumnModel().getColumn(1).setCellEditor(new TextLineCellRendererEditor(linesPanel));
        this.getColumnModel().getColumn(1).setCellRenderer(new TextLineCellRendererEditor(linesPanel));
        this.getColumnModel().getColumn(2).setMaxWidth(90);
        this.getColumnModel().getColumn(2).setMinWidth(90);
        this.getColumnModel().getColumn(2).setWidth(90);
        this.getColumnModel().getColumn(2).setCellEditor(new AudioCellRendererEditor());
        this.getColumnModel().getColumn(2).setCellRenderer(new AudioCellRendererEditor());
        this.getColumnModel().getColumn(3).setMaxWidth(90);
        this.getColumnModel().getColumn(3).setMinWidth(90);
        this.getColumnModel().getColumn(3).setWidth(90);
        this.getColumnModel().getColumn(3).setCellEditor(new SynthesizeCellRendererEditor());
        this.getColumnModel().getColumn(3).setCellRenderer(new SynthesizeCellRendererEditor());
        this.getColumnModel().getColumn(4).setMaxWidth(40);
        this.getColumnModel().getColumn(4).setMinWidth(40);
        this.getColumnModel().getColumn(4).setWidth(120);
        this.getColumnModel().getColumn(4).setCellRenderer(new ConditionsCellRendererEditor());
        this.getColumnModel().getColumn(4).setCellEditor(new ConditionsCellRendererEditor());
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(TC.get((String)"ConversationLine.PlayerName"));
        for (String string : stringArray = Controller.getInstance().getIdentifierSummary().getNPCIds()) {
            arrayList.add(string);
        }
        stringArray = arrayList.toArray(new String[0]);
        JComboBox<String> jComboBox = new JComboBox<String>(stringArray);
        this.getColumnModel().getColumn(0).setCellEditor(new DefaultCellEditor(jComboBox));
        this.setSelectionMode(0);
        this.setCellSelectionEnabled(false);
        this.setColumnSelectionAllowed(false);
        this.setRowSelectionAllowed(true);
        this.setTableHeader(null);
        this.setIntercellSpacing(new Dimension(1, 1));
        this.setRowHeight(20);
        this.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                LinesTable.this.setRowHeight(20);
                if (LinesTable.this.getSelectedRow() != -1) {
                    LinesTable.this.setRowHeight(LinesTable.this.getSelectedRow(), 48);
                    LinesTable.this.lastSelectedConversationLine = LinesTable.this.getSelectedRow();
                }
            }
        });
    }

    public void newSelectedNode(ConversationNodeView conversationNodeView) {
        this.setModel(new NodeTableModel(conversationNodeView));
        if (conversationNodeView != null) {
            this.lastSelectedNode = conversationNodeView;
        }
        if (this.isEditing()) {
            this.getCellEditor().cancelCellEditing();
        }
    }

    public void modifyConversationLineOutTable(String string) {
        this.conversationDataControl.setNodeLineText(this.lastSelectedNode, this.lastSelectedConversationLine, string);
    }

    public void modifyConversationLineOutTable(String string, ConversationNodeView conversationNodeView, int n) {
        this.conversationDataControl.setNodeLineText(conversationNodeView, n, string);
    }

    private class NodeTableModel
    extends AbstractTableModel {
        private static final long serialVersionUID = 1L;
        private ConversationNodeView node;

        public NodeTableModel(ConversationNodeView conversationNodeView) {
            this.node = conversationNodeView;
        }

        @Override
        public int getRowCount() {
            int n = 0;
            if (this.node != null) {
                n = this.node.getLineCount();
            }
            return n;
        }

        @Override
        public int getColumnCount() {
            return 5;
        }

        @Override
        public Class<?> getColumnClass(int n) {
            return this.getValueAt(0, n).getClass();
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            boolean bl = false;
            if (this.node.getType() == 0) {
                bl = true;
            } else if (this.node.getType() == 1) {
                bl = n2 != 0;
            }
            return bl && n == LinesTable.this.getSelectedRow();
        }

        @Override
        public void setValueAt(Object object, int n, int n2) {
            if (!object.toString().trim().equals("")) {
                if (n2 == 0) {
                    if (object.toString().equals(TC.get((String)"ConversationLine.PlayerName"))) {
                        LinesTable.this.conversationDataControl.setNodeLineName(this.node, n, "Player");
                    } else {
                        LinesTable.this.conversationDataControl.setNodeLineName(this.node, n, object.toString());
                    }
                }
                if (n2 == 1) {
                    LinesTable.this.conversationDataControl.setNodeLineText(this.node, n, object.toString());
                }
                this.fireTableCellUpdated(n, n2);
            }
        }

        @Override
        public Object getValueAt(int n, int n2) {
            Object object = null;
            if (this.node != null) {
                switch (n2) {
                    case 0: {
                        if (this.node.isPlayerLine(n)) {
                            object = TC.get((String)"ConversationLine.PlayerName");
                            break;
                        }
                        object = this.node.getLineName(n);
                        break;
                    }
                    case 1: {
                        object = this.node;
                        break;
                    }
                    case 2: {
                        object = this.node;
                        break;
                    }
                    case 3: {
                        object = this.node;
                        break;
                    }
                    case 4: {
                        object = ((GraphConversationDataControl)LinesTable.this.conversationDataControl).getLineConditionController(this.node, n);
                    }
                }
            }
            return object;
        }
    }
}

