/*
 * Decompiled with CFR 0.152.
 */
package es.eucm.eadventure.editor.gui.elementpanels.conversation;

import es.eucm.eadventure.common.data.chapter.conversation.node.ConversationNodeView;
import es.eucm.eadventure.common.gui.TC;
import es.eucm.eadventure.editor.control.Controller;
import es.eucm.eadventure.editor.control.controllers.Searchable;
import es.eucm.eadventure.editor.control.controllers.conversation.ConversationDataControl;
import es.eucm.eadventure.editor.control.controllers.conversation.ConversationLine;
import es.eucm.eadventure.editor.control.controllers.conversation.GraphConversationDataControl;
import es.eucm.eadventure.editor.gui.DataControlsPanel;
import es.eucm.eadventure.editor.gui.auxiliar.components.JFiller;
import es.eucm.eadventure.editor.gui.elementpanels.conversation.ConversationEditionPanel;
import es.eucm.eadventure.editor.gui.elementpanels.conversation.LinesTable;
import es.eucm.eadventure.editor.gui.elementpanels.general.TableScrollPane;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.ListSelectionModel;
import javax.swing.SwingUtilities;
import javax.swing.border.TitledBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

class LinesPanel
extends JPanel
implements DataControlsPanel {
    private static final long serialVersionUID = 1L;
    private ConversationDataControl conversationDataControl;
    private ConversationEditionPanel conversationPanel;
    private TitledBorder border;
    private LinesTable lineTable;
    private TableScrollPane tableScrollPanel;
    private JButton moveLineUpButton;
    private JButton moveLineDownButton;
    private JButton insertLineButton;
    private JButton deleteLineButton;
    private JButton deleteOptionButton;
    private JButton insertOptionButton;

    public LinesPanel(ConversationEditionPanel conversationEditionPanel, ConversationDataControl conversationDataControl) {
        this.conversationPanel = conversationEditionPanel;
        this.conversationDataControl = conversationDataControl;
        this.border = BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(1), TC.get((String)"LinesPanel.NoNodeSelected"), 2, 2);
        this.setBorder(this.border);
        this.setLayout(new GridBagLayout());
        this.lineTable = new LinesTable(conversationDataControl, this);
        this.lineTable.getSelectionModel().addListSelectionListener(new NodeTableSelectionListener());
        this.tableScrollPanel = new TableScrollPane(this.lineTable, 22, 31);
        this.moveLineUpButton = new JButton(new ImageIcon("img/icons/moveNodeUp.png"));
        this.moveLineUpButton.setContentAreaFilled(false);
        this.moveLineUpButton.setMargin(new Insets(0, 0, 0, 0));
        this.moveLineUpButton.setBorder(BorderFactory.createEmptyBorder());
        this.moveLineUpButton.setFocusable(false);
        this.moveLineUpButton.setToolTipText(TC.get((String)"Conversations.MoveLineUp"));
        this.moveLineUpButton.addActionListener(new ListenerButtonMoveLineUp());
        this.moveLineDownButton = new JButton(new ImageIcon("img/icons/moveNodeDown.png"));
        this.moveLineDownButton.setContentAreaFilled(false);
        this.moveLineDownButton.setMargin(new Insets(0, 0, 0, 0));
        this.moveLineDownButton.setBorder(BorderFactory.createEmptyBorder());
        this.moveLineDownButton.setFocusable(false);
        this.moveLineDownButton.setToolTipText(TC.get((String)"Conversations.MoveLineDown"));
        this.moveLineDownButton.addActionListener(new ListenerButtonMoveLineDown());
        this.insertLineButton = new JButton(new ImageIcon("img/icons/addNode.png"));
        this.insertLineButton.setContentAreaFilled(false);
        this.insertLineButton.setMargin(new Insets(0, 0, 0, 0));
        this.insertLineButton.setBorder(BorderFactory.createEmptyBorder());
        this.insertLineButton.setFocusable(false);
        this.insertLineButton.setToolTipText(TC.get((String)"Conversations.InsertLine"));
        this.insertLineButton.addActionListener(new ListenerButtonInsertLine());
        this.deleteLineButton = new JButton(new ImageIcon("img/icons/deleteNode.png"));
        this.deleteLineButton.setContentAreaFilled(false);
        this.deleteLineButton.setMargin(new Insets(0, 0, 0, 0));
        this.deleteLineButton.setBorder(BorderFactory.createEmptyBorder());
        this.deleteLineButton.setToolTipText(TC.get((String)"Conversations.DeleteLine"));
        this.deleteLineButton.addActionListener(new ListenerButtonDeleteLine());
        this.deleteOptionButton = new JButton(new ImageIcon("img/icons/deleteNode.png"));
        this.deleteOptionButton.setContentAreaFilled(false);
        this.deleteOptionButton.setMargin(new Insets(0, 0, 0, 0));
        this.deleteOptionButton.setBorder(BorderFactory.createEmptyBorder());
        this.deleteOptionButton.setToolTipText(TC.get((String)"Conversations.DeleteOption"));
        this.deleteOptionButton.addActionListener(new ListenerButtonDeleteOption());
        this.insertOptionButton = new JButton(new ImageIcon("img/icons/addNode.png"));
        this.insertOptionButton.setContentAreaFilled(false);
        this.insertOptionButton.setMargin(new Insets(0, 0, 0, 0));
        this.insertOptionButton.setBorder(BorderFactory.createEmptyBorder());
        this.insertOptionButton.setFocusable(false);
        this.insertOptionButton.setToolTipText(TC.get((String)"Conversations.InsertLine"));
        this.insertOptionButton.addActionListener(new ListenerButtonInsertOption());
    }

    private void setDialoguePanel() {
        this.removeAll();
        this.moveLineUpButton.setEnabled(false);
        this.moveLineDownButton.setEnabled(false);
        this.deleteLineButton.setEnabled(false);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        jPanel.add((Component)this.insertLineButton, gridBagConstraints);
        gridBagConstraints.gridy = 1;
        jPanel.add((Component)this.moveLineUpButton, gridBagConstraints);
        gridBagConstraints.gridy = 2;
        jPanel.add((Component)this.moveLineDownButton, gridBagConstraints);
        gridBagConstraints.gridy = 4;
        jPanel.add((Component)this.deleteLineButton, gridBagConstraints);
        gridBagConstraints.gridy = 3;
        gridBagConstraints.weighty = 2.0;
        gridBagConstraints.fill = 3;
        jPanel.add((Component)new JFiller(), gridBagConstraints);
        this.setLayout(new BorderLayout());
        if (!Controller.getInstance().isKeepShowing()) {
            JCheckBox jCheckBox = new JCheckBox(TC.get((String)"Conversation.WaitUserInteraction"), this.conversationDataControl.isKeepShowingDialogueActivate(this.conversationPanel.getSelectedNode()));
            jCheckBox.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    LinesPanel.this.conversationDataControl.setKeepShowingDialogueOptions(LinesPanel.this.conversationPanel.getSelectedNode());
                }
            });
            this.add((Component)jCheckBox, "North");
        }
        this.add((Component)jPanel, "East");
        this.add((Component)this.tableScrollPanel, "Center");
    }

    private void setOptionPanel() {
        this.removeAll();
        this.moveLineUpButton.setEnabled(false);
        this.moveLineDownButton.setEnabled(false);
        this.deleteOptionButton.setEnabled(false);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        jPanel.add((Component)this.insertOptionButton, gridBagConstraints);
        ++gridBagConstraints.gridy;
        jPanel.add((Component)this.deleteOptionButton, gridBagConstraints);
        gridBagConstraints.anchor = 15;
        ++gridBagConstraints.gridy;
        jPanel.add((Component)this.moveLineUpButton, gridBagConstraints);
        ++gridBagConstraints.gridy;
        jPanel.add((Component)this.moveLineDownButton, gridBagConstraints);
        JCheckBox jCheckBox = new JCheckBox(TC.get((String)"Conversation.OptionRandomly"), this.conversationDataControl.isRandomActivate(this.conversationPanel.getSelectedNode()));
        jCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                LinesPanel.this.conversationDataControl.setRandomlyOptions(LinesPanel.this.conversationPanel.getSelectedNode());
            }
        });
        JCheckBox jCheckBox2 = new JCheckBox(TC.get((String)"Conversation.ShowUserOption"), this.conversationDataControl.isShowUserOptionActivate(this.conversationPanel.getSelectedNode()));
        jCheckBox2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                LinesPanel.this.conversationDataControl.setShowUserOptionOptions(LinesPanel.this.conversationPanel.getSelectedNode());
            }
        });
        JCheckBox jCheckBox3 = new JCheckBox(TC.get((String)"Conversation.PreListening"), this.conversationDataControl.isPreListeningActivate(this.conversationPanel.getSelectedNode()));
        jCheckBox3.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                LinesPanel.this.conversationDataControl.setPreListeningOptions(LinesPanel.this.conversationPanel.getSelectedNode());
            }
        });
        JPanel jPanel2 = new JPanel();
        jPanel2.add(jCheckBox);
        JCheckBox jCheckBox4 = new JCheckBox(TC.get((String)"Conversation.KeepShowing"), this.conversationDataControl.isKeepShowingOptionsNodeActivate(this.conversationPanel.getSelectedNode()));
        jCheckBox4.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                LinesPanel.this.conversationDataControl.setKeepShowingOptionNodeOptions(LinesPanel.this.conversationPanel.getSelectedNode());
            }
        });
        jPanel2.add(jCheckBox4);
        jPanel2.add(jCheckBox2);
        jPanel2.add(jCheckBox3);
        this.setLayout(new BorderLayout());
        this.add((Component)jPanel, "East");
        this.add((Component)this.tableScrollPanel, "Center");
        this.add((Component)jPanel2, "North");
    }

    public ConversationNodeView getSelectedNode() {
        return this.conversationPanel.getSelectedNode();
    }

    public void newSelectedNode() {
        ConversationNodeView conversationNodeView = this.conversationPanel.getSelectedNode();
        this.lineTable.newSelectedNode(conversationNodeView);
        if (conversationNodeView == null) {
            this.border.setTitle(TC.get((String)"LinesPanel.NoNodeSelected"));
            this.removeAll();
            this.conversationPanel.getMenuPanel().setVisible(false);
        } else if (conversationNodeView.getType() == 0) {
            this.border.setTitle(TC.get((String)"LinesPanel.DialogueNode"));
            this.conversationPanel.getMenuPanel().setDialoguePanel();
            this.setDialoguePanel();
        } else if (conversationNodeView.getType() == 1) {
            this.border.setTitle(TC.get((String)"LinesPanel.OptionNode"));
            this.conversationPanel.getMenuPanel().setOptionPanel();
            this.setOptionPanel();
        }
        this.repaint();
    }

    public void reloadOptions() {
        this.lineTable.revalidate();
    }

    public void editNextLine() {
        final int n = this.lineTable.getSelectedRow();
        if (n == this.lineTable.getRowCount() - 1) {
            ConversationNodeView conversationNodeView = this.conversationPanel.getSelectedNode();
            if (conversationNodeView.getType() == 0) {
                String string = conversationNodeView.getLineName(n);
                this.conversationDataControl.addNodeLine(conversationNodeView, n + 1, string, ((GraphConversationDataControl)this.conversationDataControl).getAllConditions().get(conversationNodeView));
            } else {
                this.conversationDataControl.addChild(conversationNodeView, 0, ((GraphConversationDataControl)this.conversationDataControl).getAllConditions());
            }
        }
        this.lineTable.changeSelection(n + 1, n + 1, false, false);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (LinesPanel.this.lineTable.editCellAt(n + 1, 1)) {
                    ((JScrollPane)LinesPanel.this.lineTable.getEditorComponent()).requestFocusInWindow();
                }
            }
        });
    }

    @Override
    public void setSelectedItem(List<Searchable> list) {
        if (list.size() > 0 && list.get(list.size() - 1) instanceof ConversationLine) {
            ConversationLine conversationLine = (ConversationLine)list.get(list.size() - 1);
            this.lineTable.changeSelection(conversationLine.getLine(), 0, false, false);
        }
    }

    public LinesTable getLineTable() {
        return this.lineTable;
    }

    private class NodeTableSelectionListener
    implements ListSelectionListener {
        private NodeTableSelectionListener() {
        }

        @Override
        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            ListSelectionModel listSelectionModel = (ListSelectionModel)listSelectionEvent.getSource();
            if (listSelectionModel.isSelectionEmpty()) {
                LinesPanel.this.moveLineUpButton.setEnabled(false);
                LinesPanel.this.moveLineDownButton.setEnabled(false);
                LinesPanel.this.deleteOptionButton.setEnabled(false);
                LinesPanel.this.deleteLineButton.setEnabled(false);
            } else {
                LinesPanel.this.moveLineUpButton.setEnabled(true);
                LinesPanel.this.moveLineDownButton.setEnabled(true);
                LinesPanel.this.deleteOptionButton.setEnabled(true);
                LinesPanel.this.deleteLineButton.setEnabled(true);
                if (LinesPanel.this.conversationPanel.getSelectedNode().getType() == 1) {
                    int n = listSelectionModel.getMinSelectionIndex();
                    LinesPanel.this.conversationPanel.updateRepresentation();
                    ConversationNodeView conversationNodeView = LinesPanel.this.conversationPanel.getSelectedNode().getChildView(n);
                    LinesPanel.this.conversationPanel.setSelectedChild(conversationNodeView);
                }
            }
        }
    }

    private class ListenerButtonDeleteOption
    implements ActionListener {
        private ListenerButtonDeleteOption() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            int n = LinesPanel.this.lineTable.getSelectedRow();
            ConversationNodeView conversationNodeView = LinesPanel.this.conversationPanel.getSelectedNode();
            if (LinesPanel.this.conversationDataControl.deleteNodeOption(conversationNodeView, n)) {
                if (conversationNodeView.getChildCount() == 0) {
                    LinesPanel.this.lineTable.clearSelection();
                } else if (conversationNodeView.getChildCount() == n) {
                    LinesPanel.this.lineTable.setRowSelectionInterval(n - 1, n - 1);
                }
                if (LinesPanel.this.lineTable.getSelectedRow() >= 0) {
                    LinesPanel.this.conversationPanel.setSelectedChild(LinesPanel.this.conversationPanel.getSelectedNode().getChildView(LinesPanel.this.lineTable.getSelectedRow()));
                } else {
                    LinesPanel.this.conversationPanel.setSelectedChild(null);
                }
                LinesPanel.this.conversationPanel.changePerformedInNode();
                LinesPanel.this.lineTable.revalidate();
            }
        }
    }

    private class ListenerButtonDeleteLine
    implements ActionListener {
        private ListenerButtonDeleteLine() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            int n = LinesPanel.this.lineTable.getSelectedRow();
            ConversationNodeView conversationNodeView = LinesPanel.this.conversationPanel.getSelectedNode();
            LinesPanel.this.conversationDataControl.deleteNodeLine(conversationNodeView, n, ((GraphConversationDataControl)LinesPanel.this.conversationDataControl).getAllConditions().get(conversationNodeView));
            if (conversationNodeView.getLineCount() == 0) {
                LinesPanel.this.lineTable.clearSelection();
                LinesPanel.this.tableScrollPanel.updateUI();
            } else if (conversationNodeView.getLineCount() == n) {
                LinesPanel.this.lineTable.setRowSelectionInterval(n - 1, n - 1);
            }
            LinesPanel.this.lineTable.revalidate();
        }
    }

    private class ListenerButtonInsertOption
    implements ActionListener {
        private ListenerButtonInsertOption() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            int n = LinesPanel.this.lineTable.getSelectedRow();
            ConversationNodeView conversationNodeView = LinesPanel.this.conversationPanel.getSelectedNode();
            if (n == -1) {
                n = LinesPanel.this.lineTable.getRowCount() - 1;
            }
            LinesPanel.this.conversationDataControl.addChild(conversationNodeView, 0, ((GraphConversationDataControl)LinesPanel.this.conversationDataControl).getAllConditions());
            LinesPanel.this.conversationPanel.reloadOptions();
            LinesPanel.this.conversationPanel.updateRepresentation();
            LinesPanel.this.lineTable.setRowSelectionInterval(n + 1, n + 1);
            LinesPanel.this.lineTable.scrollRectToVisible(LinesPanel.this.lineTable.getCellRect(n + 1, 0, true));
            LinesPanel.this.lineTable.revalidate();
        }
    }

    private class ListenerButtonInsertLine
    implements ActionListener {
        private ListenerButtonInsertLine() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            int n = LinesPanel.this.lineTable.getSelectedRow();
            ConversationNodeView conversationNodeView = LinesPanel.this.conversationPanel.getSelectedNode();
            String string = "Player";
            if (n == -1) {
                n = LinesPanel.this.lineTable.getRowCount() - 1;
            } else {
                string = conversationNodeView.getLineName(n);
            }
            LinesPanel.this.conversationDataControl.addNodeLine(conversationNodeView, n + 1, string, ((GraphConversationDataControl)LinesPanel.this.conversationDataControl).getAllConditions().get(conversationNodeView));
            LinesPanel.this.lineTable.setRowSelectionInterval(n + 1, n + 1);
            LinesPanel.this.lineTable.scrollRectToVisible(LinesPanel.this.lineTable.getCellRect(n + 1, 0, true));
            LinesPanel.this.lineTable.revalidate();
        }
    }

    private class ListenerButtonMoveLineDown
    implements ActionListener {
        private ListenerButtonMoveLineDown() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            int n = LinesPanel.this.lineTable.getSelectedRow();
            ConversationNodeView conversationNodeView = LinesPanel.this.conversationPanel.getSelectedNode();
            if (LinesPanel.this.conversationDataControl.moveNodeLineDown(conversationNodeView, n)) {
                LinesPanel.this.lineTable.setRowSelectionInterval(n + 1, n + 1);
                LinesPanel.this.lineTable.scrollRectToVisible(LinesPanel.this.lineTable.getCellRect(n + 1, 0, true));
                LinesPanel.this.conversationDataControl.updateAllConditions();
                if (conversationNodeView.getType() == 1) {
                    LinesPanel.this.conversationPanel.changePerformedInNode();
                }
            }
        }
    }

    private class ListenerButtonMoveLineUp
    implements ActionListener {
        private ListenerButtonMoveLineUp() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            int n = LinesPanel.this.lineTable.getSelectedRow();
            ConversationNodeView conversationNodeView = LinesPanel.this.conversationPanel.getSelectedNode();
            if (LinesPanel.this.conversationDataControl.moveNodeLineUp(conversationNodeView, n)) {
                LinesPanel.this.lineTable.setRowSelectionInterval(n - 1, n - 1);
                LinesPanel.this.lineTable.scrollRectToVisible(LinesPanel.this.lineTable.getCellRect(n - 1, 0, true));
                LinesPanel.this.conversationDataControl.updateAllConditions();
                if (conversationNodeView.getType() == 1) {
                    LinesPanel.this.conversationPanel.changePerformedInNode();
                }
            }
        }
    }
}

