/*
 * Decompiled with CFR 0.152.
 */
package es.eucm.eadventure.editor.gui.elementpanels.conversation;

import es.eucm.eadventure.common.data.chapter.conversation.node.ConversationNodeView;
import es.eucm.eadventure.common.gui.TC;
import es.eucm.eadventure.editor.control.controllers.conversation.ConversationDataControl;
import es.eucm.eadventure.editor.gui.displaydialogs.ConversationDialog;
import es.eucm.eadventure.editor.gui.elementpanels.conversation.ConversationEditionPanel;
import es.eucm.eadventure.editor.gui.elementpanels.conversation.RepresentationPanel;
import es.eucm.eadventure.editor.gui.elementpanels.conversation.representation.GraphicRepresentation;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;

public class ConversationPanelMouseListener
implements MouseListener,
MouseMotionListener {
    private GraphicRepresentation conversationRepresentation;
    private ConversationDataControl conversationDataControl;
    private ConversationEditionPanel conversationPanel;
    private RepresentationPanel representationPanel;

    public ConversationPanelMouseListener(GraphicRepresentation graphicRepresentation, ConversationDataControl conversationDataControl, ConversationEditionPanel conversationEditionPanel, RepresentationPanel representationPanel) {
        this.conversationRepresentation = graphicRepresentation;
        this.conversationDataControl = conversationDataControl;
        this.conversationPanel = conversationEditionPanel;
        this.representationPanel = representationPanel;
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
        ConversationNodeView conversationNodeView = this.conversationRepresentation.getNodeInPosition(mouseEvent.getPoint());
        if (this.representationPanel.getState() == 0) {
            this.conversationPanel.setSelectedNode(conversationNodeView);
            if ((conversationNodeView == null || mouseEvent.getButton() != 3) && mouseEvent.getButton() == 3) {
                JPopupMenu jPopupMenu = new JPopupMenu();
                JMenuItem jMenuItem = new JMenuItem(TC.get((String)"Conversation.OptionPreviewConversation"));
                jMenuItem.addActionListener(new PreviewConversationActionListener(true));
                jPopupMenu.add(jMenuItem);
                jPopupMenu.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
            }
        } else if (this.representationPanel.getState() == 1) {
            if (conversationNodeView != null && this.conversationDataControl.moveNode(this.conversationPanel.getSelectedNode(), conversationNodeView)) {
                this.representationPanel.updateRepresentation();
            }
            this.representationPanel.changeState(0);
        } else if (this.representationPanel.getState() == 2) {
            if (conversationNodeView != null && this.conversationDataControl.linkNode(this.conversationPanel.getSelectedNode(), conversationNodeView)) {
                this.conversationPanel.reloadOptions();
                this.representationPanel.updateRepresentation();
            }
            this.representationPanel.changeState(0);
        }
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        this.conversationRepresentation.mousePressed(mouseEvent.getPoint());
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
        if (this.conversationRepresentation.mouseReleased()) {
            this.representationPanel.setPreferredSize(this.conversationRepresentation.getConversationSize());
            this.conversationPanel.reloadScroll();
            this.conversationPanel.repaint();
        }
    }

    @Override
    public void mouseDragged(MouseEvent mouseEvent) {
        int n;
        int n2;
        if (this.conversationRepresentation.mouseDragged(mouseEvent.getPoint())) {
            this.representationPanel.repaint();
        }
        if (mouseEvent.getPoint().x - (n2 = this.conversationPanel.getScrollXValue()) < 20) {
            this.conversationPanel.changeScrollX(-20);
        }
        if (mouseEvent.getPoint().x - n2 > this.conversationPanel.getScrollSize().width - 30) {
            this.conversationPanel.changeScrollX(20);
        }
        if (mouseEvent.getPoint().y - (n = this.conversationPanel.getScrollYValue()) < 20) {
            this.conversationPanel.changeScrollY(-20);
        }
        if (mouseEvent.getPoint().y - n > this.conversationPanel.getScrollSize().height - 30) {
            this.conversationPanel.changeScrollY(20);
        }
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseMoved(MouseEvent mouseEvent) {
    }

    private class PreviewConversationActionListener
    implements ActionListener {
        private boolean completePreview;

        public PreviewConversationActionListener(boolean bl) {
            this.completePreview = bl;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (this.completePreview) {
                new ConversationDialog(ConversationPanelMouseListener.this.conversationDataControl, ConversationPanelMouseListener.this.conversationDataControl.getRootNode());
            } else {
                new ConversationDialog(ConversationPanelMouseListener.this.conversationDataControl, ConversationPanelMouseListener.this.conversationPanel.getSelectedNode());
            }
        }
    }
}

