/*
 * Decompiled with CFR 0.152.
 */
package es.eucm.eadventure.editor.gui.elementpanels.conversation;

import es.eucm.eadventure.common.data.chapter.conversation.node.ConversationNodeView;
import es.eucm.eadventure.common.gui.TC;
import es.eucm.eadventure.editor.control.controllers.Searchable;
import es.eucm.eadventure.editor.control.controllers.conversation.ConversationDataControl;
import es.eucm.eadventure.editor.control.controllers.conversation.SearchableNode;
import es.eucm.eadventure.editor.gui.DataControlsPanel;
import es.eucm.eadventure.editor.gui.Updateable;
import es.eucm.eadventure.editor.gui.displaydialogs.ConversationDialog;
import es.eucm.eadventure.editor.gui.elementpanels.conversation.LinesPanel;
import es.eucm.eadventure.editor.gui.elementpanels.conversation.MenuPanel;
import es.eucm.eadventure.editor.gui.elementpanels.conversation.RepresentationPanel;
import es.eucm.eadventure.editor.gui.elementpanels.conversation.RepresentationZoomPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;

public class ConversationEditionPanel
extends JPanel
implements Updateable,
DataControlsPanel {
    private static final long serialVersionUID = 1L;
    public static final int DEFAULT_SPLIT = 200;
    private JScrollPane scrollPanel;
    private RepresentationPanel representationPanel;
    private LinesPanel linesPanel;
    private ConversationNodeView selectedNode = null;
    private ConversationNodeView selectedChild = null;
    private JButton previewFromNode;
    private ConversationDataControl conversationDataControl;
    private JSplitPane linesSplit;

    public ConversationEditionPanel(ConversationDataControl conversationDataControl) {
        this.conversationDataControl = conversationDataControl;
        this.representationPanel = new RepresentationPanel(this, conversationDataControl);
        this.linesPanel = new LinesPanel(this, conversationDataControl);
        RepresentationZoomPanel representationZoomPanel = new RepresentationZoomPanel(this.representationPanel);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        jPanel.add((Component)representationZoomPanel, gridBagConstraints);
        JButton jButton = new JButton(TC.get((String)"Conversation.OptionPreviewConversation"));
        jButton.addActionListener(new PreviewConversationActionListener(true));
        this.previewFromNode = new JButton(TC.get((String)"Conversation.OptionPreviewPartialConversation"));
        this.previewFromNode.addActionListener(new PreviewConversationActionListener(false));
        this.previewFromNode.setEnabled(false);
        ++gridBagConstraints.gridx;
        jPanel.add((Component)jButton, gridBagConstraints);
        ++gridBagConstraints.gridx;
        jPanel.add((Component)this.previewFromNode, gridBagConstraints);
        JPanel jPanel2 = new JPanel();
        jPanel2.setPreferredSize(new Dimension(0, 200));
        jPanel2.setLayout(new BorderLayout());
        jPanel2.add((Component)this.linesPanel, "Center");
        this.scrollPanel = new JScrollPane(this.representationPanel, 22, 32);
        this.setLayout(new BorderLayout());
        this.add((Component)jPanel, "North");
        this.linesSplit = new JSplitPane(0, this.scrollPanel, jPanel2);
        this.linesSplit.setDividerLocation(Integer.MAX_VALUE);
        this.linesSplit.setResizeWeight(1.0);
        this.linesSplit.setDividerSize(10);
        this.add((Component)this.linesSplit, "Center");
        if (conversationDataControl.getRootNode().getChildCount() == 0) {
            this.setSelectedNode(conversationDataControl.getRootNode());
        }
    }

    public void changePerformedInNode() {
        this.representationPanel.updateRepresentation();
    }

    public void reloadOptions() {
        this.representationPanel.getMenuPanel().reloadOptions();
        this.linesPanel.reloadOptions();
    }

    public void reloadScroll() {
        this.scrollPanel.getViewport().revalidate();
    }

    public void setSelectedNode(ConversationNodeView conversationNodeView) {
        this.selectedNode = conversationNodeView;
        this.selectedChild = null;
        if (conversationNodeView != null) {
            this.linesSplit.setDividerLocation(-200);
        } else {
            this.linesSplit.setDividerLocation(Integer.MAX_VALUE);
        }
        this.previewFromNode.setEnabled(conversationNodeView != null);
        this.linesPanel.newSelectedNode();
        this.representationPanel.repaint();
        this.revalidate();
    }

    public ConversationNodeView getSelectedNode() {
        return this.selectedNode;
    }

    public void setSelectedChild(ConversationNodeView conversationNodeView) {
        this.selectedChild = conversationNodeView;
        this.representationPanel.repaint();
    }

    public ConversationNodeView getSelectedChild() {
        return this.selectedChild;
    }

    public void changeScrollX(int n) {
        int n2;
        int n3 = this.scrollPanel.getHorizontalScrollBar().getValue();
        n = n3 + n;
        if (n > (n2 = this.scrollPanel.getHorizontalScrollBar().getMaximum())) {
            n = n2;
        }
        if (n < 0) {
            n = 0;
        }
        this.scrollPanel.getHorizontalScrollBar().setValue(n);
        this.reloadScroll();
    }

    public void changeScrollY(int n) {
        int n2;
        int n3 = this.scrollPanel.getVerticalScrollBar().getValue();
        n = n3 + n;
        if (n > (n2 = this.scrollPanel.getVerticalScrollBar().getMaximum())) {
            n = n2;
        }
        if (n < 0) {
            n = 0;
        }
        this.scrollPanel.getVerticalScrollBar().setValue(n);
        this.reloadScroll();
    }

    public Dimension getScrollSize() {
        return this.scrollPanel.getSize();
    }

    public int getScrollXValue() {
        return this.scrollPanel.getHorizontalScrollBar().getValue();
    }

    public int getScrollYValue() {
        return this.scrollPanel.getVerticalScrollBar().getValue();
    }

    public void changeScale(float f) {
    }

    @Override
    public boolean updateFields() {
        if (this.getSelectedNode() != null && !this.conversationDataControl.getAllNodes().contains(this.getSelectedNode())) {
            this.setSelectedNode(null);
            this.setSelectedChild(null);
        } else if (this.getSelectedChild() != null && !this.conversationDataControl.getAllNodes().contains(this.getSelectedChild())) {
            this.setSelectedChild(null);
        } else {
            this.setSelectedNode(this.getSelectedNode());
            this.setSelectedChild(this.getSelectedChild());
        }
        this.representationPanel.updateRepresentation();
        this.representationPanel.repaint();
        return true;
    }

    public void updateRepresentation() {
        this.representationPanel.updateRepresentation();
    }

    public MenuPanel getMenuPanel() {
        return this.representationPanel.getMenuPanel();
    }

    public void changeState(int n) {
        this.representationPanel.changeState(n);
    }

    public int getState() {
        return this.representationPanel.getState();
    }

    @Override
    public void setSelectedItem(List<Searchable> list) {
        if (list.size() > 0 && list.get(list.size() - 1) instanceof SearchableNode) {
            this.setSelectedNode(((SearchableNode)list.get(list.size() - 1)).getConversationNodeView());
            list.remove(list.size() - 1);
            if (this.linesPanel != null) {
                this.linesPanel.setSelectedItem(list);
            }
        }
    }

    private class PreviewConversationActionListener
    implements ActionListener {
        private boolean completePreview;

        public PreviewConversationActionListener(boolean bl) {
            this.completePreview = bl;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (this.completePreview) {
                new ConversationDialog(ConversationEditionPanel.this.conversationDataControl, ConversationEditionPanel.this.conversationDataControl.getRootNode());
            } else {
                new ConversationDialog(ConversationEditionPanel.this.conversationDataControl, ConversationEditionPanel.this.getSelectedNode());
            }
        }
    }
}

