/*
 * Decompiled with CFR 0.152.
 */
package es.eucm.eadventure.editor.gui.elementpanels.conversation;

import es.eucm.eadventure.common.auxiliar.ReportDialog;
import es.eucm.eadventure.common.data.chapter.conversation.node.ConversationNodeView;
import es.eucm.eadventure.common.gui.TC;
import es.eucm.eadventure.editor.control.Controller;
import es.eucm.eadventure.editor.control.tools.conversation.DeleteLineAudioPathTool;
import es.eucm.eadventure.editor.control.tools.conversation.SelectLineAudioPathTool;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.accessibility.Accessible;
import javax.swing.AbstractCellEditor;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;

public class AudioCellRendererEditor
extends AbstractCellEditor
implements TableCellEditor,
TableCellRenderer {
    private static final long serialVersionUID = 8128260157985286632L;
    private ConversationNodeView value;
    private JButton deleteButton;
    private JLabel label;
    private JPanel panel;

    @Override
    public Object getCellEditorValue() {
        return this.value;
    }

    @Override
    public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
        if (object == null) {
            return null;
        }
        this.value = (ConversationNodeView)object;
        return this.createPanel(n, bl, jTable);
    }

    @Override
    public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
        if (object == null) {
            return null;
        }
        this.value = (ConversationNodeView)object;
        if (!bl) {
            JLabel jLabel;
            if (this.value.hasAudioPath(n)) {
                ImageIcon imageIcon = new ImageIcon("img/icons/audio.png");
                String[] stringArray = this.value.getAudioPath(n).split("/");
                jLabel = new JLabel(stringArray[stringArray.length - 1], imageIcon, 2);
            } else {
                ImageIcon imageIcon = new ImageIcon("img/icons/noAudio.png");
                jLabel = new JLabel(TC.get((String)"Conversations.NoAudio"), imageIcon, 2);
            }
            return jLabel;
        }
        return this.createPanel(n, bl, jTable);
    }

    private JPanel createPanel(int n, boolean bl, JTable jTable) {
        Object object;
        Accessible accessible;
        final int n2 = n;
        this.panel = new JPanel();
        if (!bl) {
            this.panel.setBackground(jTable.getBackground());
        } else {
            this.panel.setBackground(jTable.getSelectionBackground());
        }
        this.panel.setLayout(new GridLayout(2, 1));
        if (this.value.hasAudioPath(n)) {
            accessible = new ImageIcon("img/icons/audio.png");
            object = this.value.getAudioPath(n).split("/");
            this.label = new JLabel(object[((String[])object).length - 1], (Icon)((Object)accessible), 2);
        } else {
            accessible = new ImageIcon("img/icons/noAudio.png");
            this.label = new JLabel(TC.get((String)"Conversations.NoAudio"), (Icon)((Object)accessible), 2);
        }
        this.label.setOpaque(false);
        this.panel.add(this.label);
        accessible = new JPanel();
        ((Container)((Object)accessible)).setLayout(new GridBagLayout());
        object = new GridBagConstraints();
        object.gridx = 0;
        object.gridy = 0;
        object.weightx = 2.0;
        JButton jButton = new JButton(TC.get((String)"Conversations.Select"));
        jButton.setFocusable(false);
        jButton.setEnabled(bl);
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    Controller.getInstance().addTool(new SelectLineAudioPathTool(AudioCellRendererEditor.this.value.getConversationLine(n2)));
                    AudioCellRendererEditor.this.updateTable(n2);
                }
                catch (CloneNotSupportedException cloneNotSupportedException) {
                    ReportDialog.GenerateErrorReport((Exception)new Exception("Could not clone resources"), (boolean)false, (String)TC.get((String)"Error.Title"));
                }
            }
        });
        jButton.setOpaque(false);
        ((Container)((Object)accessible)).add(jButton, object);
        object.gridx = 1;
        object.weightx = 0.2;
        this.deleteButton = new JButton(new ImageIcon("img/icons/deleteContent.png"));
        this.deleteButton.setToolTipText(TC.get((String)"Conversations.DeleteAudio"));
        this.deleteButton.setContentAreaFilled(false);
        this.deleteButton.setMargin(new Insets(0, 0, 0, 0));
        this.deleteButton.setFocusable(false);
        this.deleteButton.setEnabled(bl && this.value.hasAudioPath(n2));
        this.deleteButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Controller.getInstance().addTool(new DeleteLineAudioPathTool(AudioCellRendererEditor.this.value.getConversationLine(n2)));
                AudioCellRendererEditor.this.updateTable(n2);
            }
        });
        this.deleteButton.setOpaque(false);
        ((Container)((Object)accessible)).add(this.deleteButton, object);
        ((JComponent)((Object)accessible)).setOpaque(false);
        this.panel.add((Component)((Object)accessible));
        return this.panel;
    }

    private void updateTable(int n) {
        this.deleteButton.setEnabled(this.value.hasAudioPath(n));
        if (this.value.hasAudioPath(n)) {
            ImageIcon imageIcon = new ImageIcon("img/icons/audio.png");
            String[] stringArray = this.value.getAudioPath(n).split("/");
            this.label.setText(stringArray[stringArray.length - 1]);
            this.label.setIcon(imageIcon);
        } else {
            ImageIcon imageIcon = new ImageIcon("img/icons/noAudio.png");
            this.label.setText(TC.get((String)"Conversations.NoAudio"));
            this.label.setIcon(imageIcon);
        }
        this.panel.updateUI();
    }
}

