/*
 * Decompiled with CFR 0.152.
 */
package es.eucm.eadventure.editor.gui.elementpanels.condition;

import es.eucm.eadventure.editor.gui.elementpanels.condition.ConditionsPanelController;
import es.eucm.eadventure.editor.gui.elementpanels.condition.CurvedBorder;
import es.eucm.eadventure.editor.gui.elementpanels.condition.LeftLineBorder;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.IllegalComponentStateException;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.BoxLayout;
import javax.swing.JPanel;
import javax.swing.Timer;
import javax.swing.border.Border;

public abstract class EditablePanel
extends JPanel {
    private static final long serialVersionUID = 6829039739384766833L;
    public static final int NO_SELECTED = 1;
    public static final int OVER = 2;
    public static final int SELECTED = 3;
    protected int state;
    protected int index1;
    protected ConditionsPanelController controller;
    protected Border borderSelected = new CurvedBorder(40, Color.DARK_GRAY);
    protected Border borderOver = new CurvedBorder(40, Color.DARK_GRAY);
    protected Border borderNone = null;
    private ButtonsPanel buttonsPanel;
    protected AlphaEffectTimer timer;
    protected AlphaComposite alphaComposite;
    protected float alpha = 0.0f;
    protected boolean useAlphaEffect;
    protected boolean useButtons;

    public EditablePanel(ConditionsPanelController conditionsPanelController, int n) {
        this(conditionsPanelController, n, true, true);
    }

    public EditablePanel(ConditionsPanelController conditionsPanelController, int n, boolean bl, boolean bl2) {
        this.controller = conditionsPanelController;
        this.index1 = n;
        this.useAlphaEffect = bl2;
        this.useButtons = bl;
        if (bl2) {
            this.timer = new AlphaEffectTimer();
        }
        if (bl) {
            this.buttonsPanel = this.createButtonsPanel();
        }
        this.borderOver = this.borderSelected = new CurvedBorder(40, Color.DARK_GRAY);
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent mouseEvent) {
                if (EditablePanel.this.state == 1) {
                    EditablePanel.this.setState(2);
                }
            }

            private boolean isMouseInPanel(MouseEvent mouseEvent) {
                try {
                    int n = mouseEvent.getLocationOnScreen().x;
                    int n2 = mouseEvent.getLocationOnScreen().y;
                    int n3 = EditablePanel.this.getWidth();
                    int n4 = EditablePanel.this.getHeight();
                    int n5 = EditablePanel.this.getLocationOnScreen().x;
                    int n6 = EditablePanel.this.getLocationOnScreen().y;
                    boolean bl = n >= n5 && n <= n5 + n3;
                    boolean bl2 = n2 >= n6 && n2 <= n6 + n4;
                    return bl && bl2;
                }
                catch (IllegalComponentStateException illegalComponentStateException) {
                    return false;
                }
            }

            @Override
            public void mouseExited(MouseEvent mouseEvent) {
                if (!this.isMouseInPanel(mouseEvent) && EditablePanel.this.state == 2) {
                    EditablePanel.this.setState(1);
                }
            }

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                if (EditablePanel.this.state == 2) {
                    EditablePanel.this.setState(3);
                }
            }
        });
    }

    public void deselect() {
        this.setState(1, false);
    }

    protected void setState(int n) {
        this.setState(n, true);
    }

    protected void setState(int n, boolean bl) {
        boolean bl2 = false;
        int n2 = this.state;
        if (this.state != n) {
            this.state = n;
            if (this.state == 1) {
                this.setBorder(this.borderNone);
                this.removeAll();
                this.updateTimerButtonsComponents(1);
                this.updateUI();
                bl2 = true;
            } else if (this.state == 2) {
                this.setBorder(this.borderOver);
                this.removeAll();
                this.updateTimerButtonsComponents(2);
                this.updateUI();
                bl2 = true;
            } else if (this.state == 3) {
                this.setBorder(this.borderSelected);
                this.removeAll();
                this.updateTimerButtonsComponents(3);
                this.updateUI();
                bl2 = true;
            }
        }
        if (bl2 && bl) {
            this.controller.evalEditablePanelSelectionEvent(this, n2, n);
        }
    }

    private void updateTimerButtonsComponents(int n) {
        if (this.useAlphaEffect) {
            if (n != 1) {
                this.timer.start();
            } else if (this.timer != null && this.timer.isRunning()) {
                this.timer.stop();
            }
        }
        this.addComponents(n);
        if (this.useButtons) {
            this.add(this.buttonsPanel);
            this.buttonsPanel.setVisible(this.state != 1);
            if (this.state != 1) {
                this.buttonsPanel.repaint();
            }
        }
    }

    protected abstract void addComponents(int var1);

    protected abstract ButtonsPanel createButtonsPanel();

    protected abstract class ButtonsPanel
    extends JPanel {
        private static final long serialVersionUID = 1L;

        protected abstract void createAddButtons();

        public ButtonsPanel() {
            this.setLayout(new BoxLayout(this, 3));
            this.setBorder(new LeftLineBorder());
            this.setOpaque(false);
            this.createAddButtons();
            this.setVisible(false);
        }

        @Override
        public void paint(Graphics graphics) {
            if (EditablePanel.this.useAlphaEffect && EditablePanel.this.alphaComposite != null) {
                ((Graphics2D)graphics).setComposite(EditablePanel.this.alphaComposite);
            }
            super.paint(graphics);
        }
    }

    public class AlphaEffectTimer
    extends Timer {
        private static final long serialVersionUID = 1349344660294956997L;
        private static final int INC_PERIOD = 10;
        private static final float INCREMENT = 0.015f;

        @Override
        public void start() {
            EditablePanel.this.alpha = 0.0f;
            EditablePanel.this.alphaComposite = AlphaComposite.getInstance(3, EditablePanel.this.alpha);
            ((CurvedBorder)EditablePanel.this.borderOver).setAlphaComposite(EditablePanel.this.alphaComposite);
            EditablePanel.this.repaint();
            super.start();
        }

        public AlphaEffectTimer() {
            super(10, new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    EditablePanel.this.alpha = EditablePanel.this.alpha <= 0.985f ? (EditablePanel.this.alpha += 0.015f) : 1.0f;
                    EditablePanel.this.alphaComposite = AlphaComposite.getInstance(3, EditablePanel.this.alpha);
                    ((CurvedBorder)EditablePanel.this.borderOver).setAlphaComposite(EditablePanel.this.alphaComposite);
                    EditablePanel.this.repaint();
                    if (EditablePanel.this.alpha >= 1.0f) {
                        EditablePanel.this.alpha = 1.0f;
                        EditablePanel.this.alphaComposite = AlphaComposite.getInstance(3, EditablePanel.this.alpha);
                        ((CurvedBorder)EditablePanel.this.borderOver).setAlphaComposite(EditablePanel.this.alphaComposite);
                        EditablePanel.this.repaint();
                        ((AlphaEffectTimer)actionEvent.getSource()).stop();
                    }
                    if (EditablePanel.this.useButtons) {
                        EditablePanel.this.buttonsPanel.repaint();
                    }
                }
            });
        }
    }
}

