/*
 * Decompiled with CFR 0.152.
 */
package es.eucm.eadventure.editor.gui.elementpanels.condition;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.io.IOException;
import java.io.ObjectInputStream;

public class CustomFlowLayout
implements LayoutManager {
    private Component skip;
    private int xSkip;
    private int ySkip;
    public static final int LEFT = 0;
    public static final int CENTER = 1;
    public static final int RIGHT = 2;
    public static final int LEADING = 3;
    public static final int TRAILING = 4;
    int align;
    int newAlign;
    int hgap;
    int vgap;
    private boolean alignOnBaseline;
    private static final long serialVersionUID = -7262534875583282631L;
    private static final int currentSerialVersion = 1;
    private int serialVersionOnStream = 1;

    public CustomFlowLayout(Component component, int n, int n2) {
        this(1, 5, 5);
        this.skip = component;
        this.xSkip = n;
        this.ySkip = n2;
    }

    public CustomFlowLayout(int n) {
        this(n, 5, 5);
    }

    public CustomFlowLayout(int n, int n2, int n3) {
        this.hgap = n2;
        this.vgap = n3;
        this.setAlignment(n);
    }

    public int getAlignment() {
        return this.newAlign;
    }

    public void setAlignment(int n) {
        this.newAlign = n;
        switch (n) {
            case 3: {
                this.align = 0;
                break;
            }
            case 4: {
                this.align = 2;
                break;
            }
            default: {
                this.align = n;
            }
        }
    }

    public int getHgap() {
        return this.hgap;
    }

    public void setHgap(int n) {
        this.hgap = n;
    }

    public int getVgap() {
        return this.vgap;
    }

    public void setVgap(int n) {
        this.vgap = n;
    }

    public void setAlignOnBaseline(boolean bl) {
        this.alignOnBaseline = bl;
    }

    public boolean getAlignOnBaseline() {
        return this.alignOnBaseline;
    }

    @Override
    public void addLayoutComponent(String string, Component component) {
    }

    @Override
    public void removeLayoutComponent(Component component) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Dimension preferredLayoutSize(Container container) {
        Object object = container.getTreeLock();
        synchronized (object) {
            Dimension dimension = new Dimension(0, 0);
            int n = container.getComponentCount();
            boolean bl = true;
            boolean bl2 = this.getAlignOnBaseline();
            int n2 = 0;
            int n3 = 0;
            for (int i = 0; i < n; ++i) {
                int n4;
                Component component = container.getComponent(i);
                if (component == this.skip || !component.isVisible()) continue;
                Dimension dimension2 = component.getPreferredSize();
                dimension.height = Math.max(dimension.height, dimension2.height);
                if (bl) {
                    bl = false;
                } else {
                    dimension.width += this.hgap;
                }
                dimension.width += dimension2.width;
                if (!bl2 || (n4 = component.getBaseline(dimension2.width, dimension2.height)) < 0) continue;
                n2 = Math.max(n2, n4);
                n3 = Math.max(n3, dimension2.height - n4);
            }
            if (bl2) {
                dimension.height = Math.max(n2 + n3, dimension.height);
            }
            Insets insets = container.getInsets();
            dimension.width += insets.left + insets.right + this.hgap * 2;
            dimension.height += insets.top + insets.bottom + this.vgap * 2;
            return dimension;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Dimension minimumLayoutSize(Container container) {
        Object object = container.getTreeLock();
        synchronized (object) {
            boolean bl = this.getAlignOnBaseline();
            Dimension dimension = new Dimension(0, 0);
            int n = container.getComponentCount();
            int n2 = 0;
            int n3 = 0;
            boolean bl2 = true;
            for (int i = 0; i < n; ++i) {
                int n4;
                Component component = container.getComponent(i);
                if (component == this.skip || !component.isVisible()) continue;
                Dimension dimension2 = component.getMinimumSize();
                dimension.height = Math.max(dimension.height, dimension2.height);
                if (bl2) {
                    bl2 = false;
                } else {
                    dimension.width += this.hgap;
                }
                dimension.width += dimension2.width;
                if (!bl || (n4 = component.getBaseline(dimension2.width, dimension2.height)) < 0) continue;
                n2 = Math.max(n2, n4);
                n3 = Math.max(n3, dimension.height - n4);
            }
            if (bl) {
                dimension.height = Math.max(n2 + n3, dimension.height);
            }
            Insets insets = container.getInsets();
            dimension.width += insets.left + insets.right + this.hgap * 2;
            dimension.height += insets.top + insets.bottom + this.vgap * 2;
            return dimension;
        }
    }

    private int moveComponents(Container container, int n, int n2, int n3, int n4, int n5, int n6, boolean bl, boolean bl2, int[] nArray, int[] nArray2) {
        int n7;
        switch (this.newAlign) {
            case 0: {
                n += bl ? 0 : n3;
                break;
            }
            case 1: {
                n += n3 / 2;
                break;
            }
            case 2: {
                n += bl ? n3 : 0;
                break;
            }
            case 3: {
                break;
            }
            case 4: {
                n += n3;
            }
        }
        int n8 = 0;
        int n9 = 0;
        int n10 = 0;
        if (bl2) {
            n7 = 0;
            for (int i = n5; i < n6; ++i) {
                Component component = container.getComponent(i);
                if (component == this.skip || !component.isVisible()) continue;
                if (nArray[i] >= 0) {
                    n8 = Math.max(n8, nArray[i]);
                    n7 = Math.max(n7, nArray2[i]);
                    continue;
                }
                n9 = Math.max(component.getHeight(), n9);
            }
            n4 = Math.max(n8 + n7, n9);
            n10 = (n4 - n8 - n7) / 2;
        }
        for (n7 = n5; n7 < n6; ++n7) {
            Component component = container.getComponent(n7);
            if (component != this.skip && component.isVisible()) {
                int n11 = bl2 && nArray[n7] >= 0 ? n2 + n10 + n8 - nArray[n7] : n2 + (n4 - component.getHeight()) / 2;
                if (bl) {
                    component.setLocation(n, n11);
                } else {
                    component.setLocation(container.getWidth() - n - component.getWidth(), n11);
                }
                n += component.getWidth() + this.hgap;
                continue;
            }
            if (component != this.skip) continue;
            this.skip.setLocation(container.getWidth() / 2 - this.skip.getWidth() + this.xSkip, this.ySkip);
            System.out.println("x=" + (container.getWidth() / 2 - this.skip.getWidth() + this.xSkip));
            System.out.println("y=" + this.ySkip);
        }
        return n4;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void layoutContainer(Container container) {
        Object object = container.getTreeLock();
        synchronized (object) {
            Insets insets = container.getInsets();
            int n = container.getWidth() - (insets.left + insets.right + this.hgap * 2);
            int n2 = container.getComponentCount();
            int n3 = 0;
            int n4 = insets.top + this.vgap;
            int n5 = 0;
            int n6 = 0;
            boolean bl = container.getComponentOrientation().isLeftToRight();
            boolean bl2 = this.getAlignOnBaseline();
            int[] nArray = null;
            int[] nArray2 = null;
            if (bl2) {
                nArray = new int[n2];
                nArray2 = new int[n2];
            }
            for (int i = 0; i < n2; ++i) {
                Component component = container.getComponent(i);
                if (!component.isVisible() || component == this.skip) continue;
                Dimension dimension = component.getPreferredSize();
                component.setSize(dimension.width, dimension.height);
                if (bl2) {
                    int n7 = component.getBaseline(dimension.width, dimension.height);
                    if (n7 >= 0) {
                        nArray[i] = n7;
                        nArray2[i] = dimension.height - n7;
                    } else {
                        nArray[i] = -1;
                    }
                }
                if (n3 == 0 || n3 + dimension.width <= n) {
                    if (n3 > 0) {
                        n3 += this.hgap;
                    }
                    n3 += dimension.width;
                    n5 = Math.max(n5, dimension.height);
                    continue;
                }
                n5 = this.moveComponents(container, insets.left + this.hgap, n4, n - n3, n5, n6, i, bl, bl2, nArray, nArray2);
                n3 = dimension.width;
                n4 += this.vgap + n5;
                n5 = dimension.height;
                n6 = i;
            }
            this.moveComponents(container, insets.left + this.hgap, n4, n - n3, n5, n6, n2, bl, bl2, nArray, nArray2);
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        if (this.serialVersionOnStream < 1) {
            this.setAlignment(this.align);
        }
        this.serialVersionOnStream = 1;
    }

    public String toString() {
        String string = "";
        switch (this.align) {
            case 0: {
                string = ",align=left";
                break;
            }
            case 1: {
                string = ",align=center";
                break;
            }
            case 2: {
                string = ",align=right";
                break;
            }
            case 3: {
                string = ",align=leading";
                break;
            }
            case 4: {
                string = ",align=trailing";
            }
        }
        return this.getClass().getName() + "[hgap=" + this.hgap + ",vgap=" + this.vgap + string + "]";
    }
}

