/*
 * Decompiled with CFR 0.152.
 */
package es.eucm.eadventure.editor.gui.elementpanels.condition;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import javax.swing.border.AbstractBorder;

public class CurvedBorder
extends AbstractBorder {
    private Color wallColor = Color.gray;
    private Color bgColor = new Color(255, 255, 20, 100);
    private int sinkLevel = 10;
    private AlphaComposite alphaComposite;

    public void setAlphaComposite(AlphaComposite alphaComposite) {
        this.alphaComposite = alphaComposite;
    }

    public CurvedBorder() {
    }

    public CurvedBorder(int n) {
        this.sinkLevel = n;
    }

    public CurvedBorder(Color color) {
        this.wallColor = color;
    }

    public CurvedBorder(int n, Color color) {
        this.sinkLevel = n;
        this.wallColor = color;
    }

    public CurvedBorder(int n, Color color, Color color2) {
        this.sinkLevel = n;
        this.wallColor = color;
        this.bgColor = color2;
    }

    @Override
    public void paintBorder(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
        if (this.alphaComposite != null) {
            ((Graphics2D)graphics).setComposite(this.alphaComposite);
        }
        if (this.bgColor != null) {
            graphics.setColor(this.bgColor);
            graphics.fillRoundRect(n, n2, n3 - 1, n4 - 1, this.sinkLevel, this.sinkLevel);
        }
        graphics.setColor(this.getWallColor());
        graphics.drawRoundRect(n, n2, n3 - 1, n4 - 1, this.sinkLevel, this.sinkLevel);
        ((Graphics2D)graphics).setComposite(AlphaComposite.getInstance(3, 1.0f));
    }

    @Override
    public Insets getBorderInsets(Component component) {
        return new Insets(0, 0, 0, 0);
    }

    @Override
    public Insets getBorderInsets(Component component, Insets insets) {
        insets.top = 10;
        insets.bottom = 10;
        insets.right = 10;
        insets.left = 10;
        return insets;
    }

    @Override
    public boolean isBorderOpaque() {
        return true;
    }

    public int getSinkLevel() {
        return this.sinkLevel;
    }

    public Color getWallColor() {
        return this.wallColor;
    }
}

