/*
 * Decompiled with CFR 0.152.
 */
package es.eucm.eadventure.editor.gui.elementpanels.condition;

import es.eucm.eadventure.common.gui.TC;
import es.eucm.eadventure.editor.control.controllers.ConditionsController;
import es.eucm.eadventure.editor.gui.Updateable;
import es.eucm.eadventure.editor.gui.editdialogs.ConditionDialog;
import es.eucm.eadventure.editor.gui.editdialogs.ConditionsDialog;
import es.eucm.eadventure.editor.gui.editdialogs.HelpDialog;
import es.eucm.eadventure.editor.gui.elementpanels.condition.CompositeConditionPanel;
import es.eucm.eadventure.editor.gui.elementpanels.condition.ConditionsPanelController;
import es.eucm.eadventure.editor.gui.elementpanels.condition.EditablePanel;
import es.eucm.eadventure.editor.gui.elementpanels.condition.EvalFunctionPanel;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JEditorPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;

public class ConditionsPanel
extends JPanel
implements Updateable,
ConditionsPanelController {
    private static final long serialVersionUID = -3452049823030669523L;
    public static final Color FLAG_COLOR = new Color(220, 5, 5, 50);
    public static final Color VAR_COLOR = new Color(5, 5, 220, 50);
    private static Color topPanelLineColor = Color.black;
    private static Color centralPanelLineColor = Color.black;
    private static Color buttonsPanelLineColor = Color.black;
    private ConditionsController conditionsController;
    private List<EditablePanel> panels;
    private EditablePanel selectedPanel = null;
    private JPanel topPanel;
    private JEditorPane textPane;
    private JPanel centralPanel;
    private JPanel buttonsPanel;
    private JButton addConditionButton;
    private JButton okButton;

    public ConditionsPanel(ConditionsController conditionsController) {
        this.setLayout(new BorderLayout());
        this.conditionsController = conditionsController;
        this.topPanel = this.createTopPanel();
        this.add((Component)this.topPanel, "North");
        this.createButtonsPanel();
        this.add((Component)this.buttonsPanel, "South");
        this.createCentralPanel();
    }

    public void update() {
        this.textPane.setContentType("text/html");
        this.textPane.setText(this.getHTMLTopText());
        this.updateCentralPanel();
    }

    private JPanel createTopPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        jPanel.setBorder(BorderFactory.createLineBorder(topPanelLineColor));
        this.textPane = new JEditorPane("text/html", this.getHTMLTopText());
        this.textPane.setEditable(false);
        this.textPane.setOpaque(false);
        jPanel.add((Component)this.textPane, "Center");
        return jPanel;
    }

    private String getHTMLTopText() {
        String string = "<html>\n\t<head>\n\t</head>\n\t<body>\n\t\t<p align=center>";
        HashMap<String, ConditionsController.ConditionContextProperty> hashMap = this.conditionsController.getContext();
        if (hashMap.containsKey(ConditionsController.CONDITION_OWNER)) {
            ConditionsController.ConditionOwner conditionOwner = (ConditionsController.ConditionOwner)hashMap.get(ConditionsController.CONDITION_OWNER);
            if (!hashMap.containsKey(ConditionsController.CONDITION_CUSTOM_MESSAGE)) {
                String string2 = TC.getElement((int)conditionOwner.getOwnerType());
                string = string + TC.get((String)"Conditions.Context.Sentence1") + "<i>" + string2 + "</i>" + " <b>\"" + conditionOwner.getOwnerName() + "\" </b>";
                ConditionsController.ConditionOwner conditionOwner2 = conditionOwner.getParent();
                if (conditionOwner2 != null) {
                    string = string + " (";
                }
                while (conditionOwner2 != null) {
                    string = string + TC.getElement((int)conditionOwner2.getOwnerType()) + " " + conditionOwner2.getOwnerName();
                    if ((conditionOwner2 = conditionOwner2.getParent()) != null) {
                        string = string + ", ";
                        continue;
                    }
                    string = string + ")";
                }
                string = !this.conditionsController.isEmpty() ? string + TC.get((String)"Conditions.Context.Sentence2a") : string + TC.get((String)"Conditions.Context.Sentence2b");
            } else {
                if (conditionOwner.getOwnerType() != 44 && conditionOwner.getOwnerType() != 49) {
                    hashMap = ConditionsController.createContextFromOwner(conditionOwner.getOwnerType(), conditionOwner.getOwnerName());
                }
                ConditionsController.ConditionCustomMessage conditionCustomMessage = (ConditionsController.ConditionCustomMessage)hashMap.get(ConditionsController.CONDITION_CUSTOM_MESSAGE);
                string = !this.conditionsController.isEmpty() ? string + conditionCustomMessage.getFormattedSentence(conditionOwner) : string + conditionCustomMessage.getNoConditionFormattedSentence(conditionOwner);
            }
        } else {
            string = string + TC.get((String)"Conditions.Context.NoOwner");
        }
        string = string + "\n\t\t</p>\n";
        string = string + "\t</body>\n";
        string = string + "</html>";
        return string;
    }

    private void createButtonsPanel() {
        this.buttonsPanel = new JPanel();
        this.addConditionButton = new JButton(new ImageIcon("img/icons/addNode.png"));
        this.addConditionButton.setText(TC.get((String)"Conditions.AddCondition"));
        this.addConditionButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ConditionsPanel.this.addCondition();
            }
        });
        this.buttonsPanel.add(this.addConditionButton);
        ConditionsController.ConditionOwner conditionOwner = (ConditionsController.ConditionOwner)this.conditionsController.getContext().get(ConditionsController.CONDITION_OWNER);
        if (conditionOwner != null && conditionOwner.getOwnerType() != 54) {
            this.okButton = new JButton(TC.get((String)"GeneralText.OK"));
            this.okButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    int n;
                    Container container = ConditionsPanel.this.getParent();
                    for (n = 0; n < 10 && !(container instanceof ConditionsDialog); ++n) {
                        container = container.getParent();
                    }
                    if (n < 10) {
                        ((ConditionsDialog)container).setVisible(false);
                    }
                }
            });
            this.buttonsPanel.add(this.okButton);
        }
        JButton jButton = new JButton(new ImageIcon("img/icons/information.png"));
        jButton.setContentAreaFilled(false);
        jButton.setMargin(new Insets(0, 0, 0, 0));
        jButton.setFocusable(false);
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                new HelpDialog("general/Conditions_Panel.html");
            }
        });
        this.buttonsPanel.add(jButton);
        this.buttonsPanel.setBorder(BorderFactory.createLineBorder(buttonsPanelLineColor));
    }

    private JPanel createCentralPanel() {
        this.centralPanel = new JPanel();
        this.centralPanel.setBorder(BorderFactory.createLineBorder(centralPanelLineColor));
        this.centralPanel.setLayout(new BoxLayout(this.centralPanel, 3));
        JScrollPane jScrollPane = new JScrollPane(this.centralPanel, 20, 30);
        this.add((Component)jScrollPane, "Center");
        this.updateCentralPanel();
        return this.centralPanel;
    }

    private void updateCentralPanel() {
        this.centralPanel.removeAll();
        this.panels = new ArrayList<EditablePanel>();
        for (int i = 0; i < this.conditionsController.getBlocksCount(); ++i) {
            EditablePanel editablePanel;
            if (i > 0) {
                editablePanel = new EvalFunctionPanel((ConditionsPanelController)this, i - 1, -1, 0);
                JPanel jPanel = new JPanel();
                jPanel.add(editablePanel);
                this.panels.add(editablePanel);
                this.centralPanel.add(jPanel);
            }
            editablePanel = null;
            editablePanel = new CompositeConditionPanel(this, i);
            this.panels.add(editablePanel);
            this.centralPanel.add(editablePanel);
        }
        this.centralPanel.repaint();
    }

    @Override
    public boolean updateFields() {
        this.update();
        return true;
    }

    @Override
    public void evalEditablePanelSelectionEvent(EditablePanel editablePanel, int n, int n2) {
        if (n2 != 1 && this.selectedPanel != null && this.selectedPanel != editablePanel) {
            this.selectedPanel.deselect();
        }
        if (n2 != 1) {
            this.selectedPanel = editablePanel;
        }
    }

    @Override
    public void evalFunctionChanged(EvalFunctionPanel evalFunctionPanel, int n, int n2, int n3, int n4) {
        if (this.conditionsController.setEvalFunction(n, n2, n4)) {
            this.update();
        }
    }

    @Override
    public HashMap<String, String> getCondition(int n, int n2) {
        return this.conditionsController.getCondition(n, n2);
    }

    @Override
    public int getConditionCount(int n) {
        return this.conditionsController.getConditionCount(n);
    }

    @Override
    public void addCondition(int n, int n2) {
        ConditionDialog conditionDialog = new ConditionDialog(TC.get((String)"Conditions.AddCondition"));
        if (conditionDialog.wasPressedOKButton() && this.conditionsController.addCondition(n, n2, conditionDialog.getSelectedType(), conditionDialog.getSelectedId(), conditionDialog.getSelectedState(), conditionDialog.getSelectedValue())) {
            this.update();
        }
    }

    @Override
    public void addCondition() {
        this.addCondition(this.conditionsController.getBlocksCount(), -1);
    }

    @Override
    public void deleteCondition(int n, int n2) {
        if (this.conditionsController.deleteCondition(n, n2)) {
            this.update();
        }
    }

    @Override
    public void duplicateCondition(int n, int n2) {
        if (this.conditionsController.duplicateCondition(n, n2)) {
            this.update();
        }
    }

    @Override
    public void editCondition(int n, int n2) {
        HashMap<String, String> hashMap = this.getCondition(n, n2);
        String string = hashMap.get("condition-id");
        String string2 = hashMap.get("condition-id");
        String string3 = hashMap.get("condition-id");
        String string4 = hashMap.get("condition-state");
        String string5 = hashMap.get("condition-value");
        String string6 = hashMap.get("condition-type");
        if (string6.equals("flag")) {
            string = null;
            string3 = null;
        } else if (string6.equals("var")) {
            string = null;
            string2 = null;
        } else if (string6.equals("global-state")) {
            string3 = null;
            string2 = null;
        }
        ConditionDialog conditionDialog = new ConditionDialog(string6, TC.get((String)"Conditions.EditCondition"), string4, string2, string3, string, string5, this.conditionsController.getContext());
        if (conditionDialog.wasPressedOKButton()) {
            hashMap.clear();
            hashMap.put("condition-id", conditionDialog.getSelectedId());
            hashMap.put("condition-state", conditionDialog.getSelectedState());
            hashMap.put("condition-value", conditionDialog.getSelectedValue());
            hashMap.put("condition-type", conditionDialog.getSelectedType());
            if (this.conditionsController.setCondition(n, n2, hashMap)) {
                this.update();
            }
        }
    }
}

