/*
 * Decompiled with CFR 0.152.
 */
package es.eucm.eadventure.editor.gui.elementpanels.condition;

import es.eucm.eadventure.editor.gui.elementpanels.condition.AtomicConditionPanel;
import es.eucm.eadventure.editor.gui.elementpanels.condition.ConditionsPanelController;
import es.eucm.eadventure.editor.gui.elementpanels.condition.EditablePanel;
import es.eucm.eadventure.editor.gui.elementpanels.condition.EvalFunctionPanel;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import javax.swing.JPanel;

public class CompositeConditionPanel
extends EditablePanel {
    private static final long serialVersionUID = -4472061217945559110L;

    public CompositeConditionPanel(ConditionsPanelController conditionsPanelController, int n) {
        super(conditionsPanelController, n, false, false);
        this.borderOver = null;
        this.borderSelected = null;
        this.state = 3;
        this.setState(1);
    }

    @Override
    protected void addComponents(int n) {
        if (this.controller.getConditionCount(this.index1) > 1) {
            BracketPanel bracketPanel = new BracketPanel(true);
            this.add(bracketPanel);
        }
        for (int i = 0; i < this.controller.getConditionCount(this.index1); ++i) {
            AtomicConditionPanel atomicConditionPanel = new AtomicConditionPanel(this.controller, this.index1, i);
            this.add(atomicConditionPanel);
            if (i >= this.controller.getConditionCount(this.index1) - 1) continue;
            this.add(new EvalFunctionPanel(this.controller, this.index1, i, 1));
        }
        if (this.controller.getConditionCount(this.index1) > 1) {
            BracketPanel bracketPanel = new BracketPanel(false);
            this.add(bracketPanel);
        }
    }

    @Override
    protected EditablePanel.ButtonsPanel createButtonsPanel() {
        return null;
    }

    private class BracketPanel
    extends JPanel {
        private static final long serialVersionUID = -5089559898788716264L;
        private boolean isLeft;

        public BracketPanel(boolean bl) {
            this.isLeft = bl;
            this.setMinimumSize(new Dimension(32, 32));
            this.setPreferredSize(new Dimension(32, 32));
        }

        @Override
        public void paint(Graphics graphics) {
            graphics.setColor(Color.black);
            int n = this.getWidth();
            int n2 = this.getHeight();
            if (this.isLeft) {
                graphics.drawArc(0, 0, 2 * n / 3, n2, 90, 180);
            } else {
                graphics.drawArc(0, 0, 2 * n / 3, n2, 90, -180);
            }
        }
    }
}

