/*
 * Decompiled with CFR 0.152.
 */
package es.eucm.eadventure.editor.gui.elementpanels.condition;

import es.eucm.eadventure.common.gui.TC;
import es.eucm.eadventure.editor.gui.elementpanels.condition.ConditionsPanelController;
import es.eucm.eadventure.editor.gui.elementpanels.condition.EditablePanel;
import java.awt.Component;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;

public class AtomicConditionPanel
extends EditablePanel {
    private static final long serialVersionUID = -7026686497412446434L;
    private JLabel iconLabel;
    private List<Component> renderComponents;
    private JButton deleteButton;
    private JButton duplicateButton;
    private JButton editButton;
    private int index2;

    public AtomicConditionPanel(ConditionsPanelController conditionsPanelController, int n, int n2) {
        super(conditionsPanelController, n);
        Component component;
        Component component2;
        this.index2 = n2;
        HashMap<String, String> hashMap = conditionsPanelController.getCondition(n, n2);
        String string = hashMap.get("condition-type");
        String string2 = hashMap.get("condition-id");
        String string3 = hashMap.get("condition-value");
        String string4 = hashMap.get("condition-state");
        this.iconLabel = new JLabel(this.getIcon(string));
        this.renderComponents = new ArrayList<Component>();
        Component component3 = this.getSubjectRender(string2);
        if (component3 != null) {
            this.renderComponents.add(component3);
        }
        if ((component2 = this.getVerbRender(string, string4)) != null) {
            this.renderComponents.add(component2);
        }
        if ((component = this.getDirectComplementRender(string, string3)) != null) {
            this.renderComponents.add(component);
        }
        this.setState(1);
    }

    @Override
    protected void addComponents(int n) {
        this.add(this.iconLabel);
        for (Component component : this.renderComponents) {
            this.add(component);
        }
    }

    private Icon getIcon(String string) {
        ImageIcon imageIcon = null;
        if (string.equals("flag")) {
            imageIcon = new ImageIcon("img/icons/flag16.png");
        } else if (string.equals("var")) {
            imageIcon = new ImageIcon("img/icons/var16.png");
        } else if (string.equals("global-state")) {
            imageIcon = new ImageIcon("img/icons/group16.png");
        }
        return imageIcon;
    }

    private Component getSubjectRender(String string) {
        JLabel jLabel = new JLabel(string);
        return jLabel;
    }

    private Component getVerbRender(String string, String string2) {
        if (string.equals("flag")) {
            return new JLabel(TC.get((String)"GeneralText.Is.Singular"));
        }
        if (string.equals("var")) {
            if (string2.equals(Integer.toString(4))) {
                return new JLabel("=");
            }
            if (string2.equals(Integer.toString(3))) {
                return new JLabel(">=");
            }
            if (string2.equals(Integer.toString(2))) {
                return new JLabel(">");
            }
            if (string2.equals(Integer.toString(5))) {
                return new JLabel("<=");
            }
            if (string2.equals(Integer.toString(6))) {
                return new JLabel("<");
            }
        } else if (string.equals("global-state")) {
            if (string2.equals(Integer.toString(7))) {
                return new JLabel(TC.get((String)"Conditions.ConditionGroup.Satisfied"));
            }
            if (string2.equals(Integer.toString(8))) {
                return new JLabel(TC.get((String)"Conditions.ConditionGroup.NotSatisfied"));
            }
        }
        return null;
    }

    private Component getDirectComplementRender(String string, String string2) {
        if (string.equals("flag")) {
            if (string2.equals(Integer.toString(0))) {
                return new JLabel(TC.get((String)"Conditions.Flag.Active"));
            }
            if (string2.equals(Integer.toString(1))) {
                return new JLabel(TC.get((String)"Conditions.Flag.Inactive"));
            }
        } else {
            if (string.equals("var")) {
                return new JLabel(string2);
            }
            if (string.equals("global-state")) {
                return null;
            }
        }
        return null;
    }

    @Override
    protected EditablePanel.ButtonsPanel createButtonsPanel() {
        return new AtomicConditionButtonsPanel();
    }

    private class AtomicConditionButtonsPanel
    extends EditablePanel.ButtonsPanel {
        private static final long serialVersionUID = -4384802457254649642L;

        private AtomicConditionButtonsPanel() {
            super(AtomicConditionPanel.this);
        }

        @Override
        protected void createAddButtons() {
            AtomicConditionPanel.this.deleteButton = new JButton(new ImageIcon("img/icons/deleteNode.png"));
            AtomicConditionPanel.this.deleteButton.setMargin(new Insets(0, 0, 0, 0));
            AtomicConditionPanel.this.deleteButton.setContentAreaFilled(false);
            AtomicConditionPanel.this.deleteButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    AtomicConditionPanel.this.controller.deleteCondition(AtomicConditionPanel.this.index1, AtomicConditionPanel.this.index2);
                }
            });
            AtomicConditionPanel.this.duplicateButton = new JButton(new ImageIcon("img/icons/duplicateNode.png"));
            AtomicConditionPanel.this.duplicateButton.setMargin(new Insets(0, 0, 0, 0));
            AtomicConditionPanel.this.duplicateButton.setContentAreaFilled(false);
            AtomicConditionPanel.this.duplicateButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    AtomicConditionPanel.this.controller.duplicateCondition(AtomicConditionPanel.this.index1, AtomicConditionPanel.this.index2);
                }
            });
            AtomicConditionPanel.this.editButton = new JButton(new ImageIcon("img/icons/edit.png"));
            AtomicConditionPanel.this.editButton.setMargin(new Insets(0, 0, 0, 0));
            AtomicConditionPanel.this.editButton.setContentAreaFilled(false);
            AtomicConditionPanel.this.editButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    AtomicConditionPanel.this.controller.editCondition(AtomicConditionPanel.this.index1, AtomicConditionPanel.this.index2);
                }
            });
            this.add(AtomicConditionPanel.this.deleteButton);
            this.add(AtomicConditionPanel.this.duplicateButton);
            this.add(AtomicConditionPanel.this.editButton);
        }
    }
}

