/*
 * Decompiled with CFR 0.152.
 */
package es.eucm.eadventure.editor.gui.elementpanels.character;

import es.eucm.eadventure.common.gui.TC;
import es.eucm.eadventure.editor.control.controllers.character.NPCDataControl;
import es.eucm.eadventure.editor.control.controllers.character.PlayerDataControl;
import es.eucm.eadventure.editor.gui.elementpanels.ElementPanel;
import es.eucm.eadventure.editor.gui.elementpanels.PanelTab;
import es.eucm.eadventure.editor.gui.elementpanels.character.NPCDialogPanel;
import es.eucm.eadventure.editor.gui.elementpanels.character.NPCDocPanel;
import es.eucm.eadventure.editor.gui.elementpanels.character.NPCLooksPanel;
import javax.swing.JComponent;

public class PlayerPanel
extends ElementPanel {
    private static final long serialVersionUID = 1L;

    public PlayerPanel(PlayerDataControl playerDataControl) {
        if (playerDataControl.buildResourcesTab()) {
            this.addTab(new LooksPanelTab(playerDataControl));
        }
        this.addTab(new DialogPanelTab(playerDataControl));
        this.addTab(new DocPanelTab(playerDataControl));
    }

    private class DialogPanelTab
    extends PanelTab {
        private NPCDataControl dataControl;

        public DialogPanelTab(NPCDataControl nPCDataControl) {
            super(TC.get((String)"NPC.DialogPanelTitle"), nPCDataControl);
            this.setToolTipText(TC.get((String)"NPC.DialogPanelTip"));
            this.dataControl = nPCDataControl;
        }

        @Override
        protected JComponent getTabComponent() {
            return new NPCDialogPanel(this.dataControl);
        }
    }

    private class LooksPanelTab
    extends PanelTab {
        private NPCDataControl dataControl;

        public LooksPanelTab(NPCDataControl nPCDataControl) {
            super(TC.get((String)"NPC.LookPanelTitle"), nPCDataControl);
            this.dataControl = nPCDataControl;
        }

        @Override
        protected JComponent getTabComponent() {
            return new NPCLooksPanel(this.dataControl);
        }
    }

    private class DocPanelTab
    extends PanelTab {
        private NPCDataControl dataControl;

        public DocPanelTab(NPCDataControl nPCDataControl) {
            super(TC.get((String)"NPC.DocPanelTitle"), nPCDataControl);
            this.dataControl = nPCDataControl;
        }

        @Override
        protected JComponent getTabComponent() {
            return new NPCDocPanel(this.dataControl);
        }
    }
}

