/*
 * Decompiled with CFR 0.152.
 */
package es.eucm.eadventure.editor.gui.elementpanels.character;

import es.eucm.eadventure.common.gui.TC;
import es.eucm.eadventure.editor.control.controllers.character.NPCDataControl;
import es.eucm.eadventure.editor.gui.elementpanels.ElementPanel;
import es.eucm.eadventure.editor.gui.elementpanels.PanelTab;
import es.eucm.eadventure.editor.gui.elementpanels.character.NPCDialogPanel;
import es.eucm.eadventure.editor.gui.elementpanels.character.NPCDocPanel;
import es.eucm.eadventure.editor.gui.elementpanels.character.NPCLooksPanel;
import es.eucm.eadventure.editor.gui.elementpanels.general.ActionsListPanel;
import javax.swing.JComponent;

public class NPCPanel
extends ElementPanel {
    private static final long serialVersionUID = 1L;

    public NPCPanel(NPCDataControl nPCDataControl) {
        this.addTab(new LooksPanelTab(nPCDataControl));
        this.addTab(new DocPanelTab(nPCDataControl));
        this.addTab(new DialogPanelTab(nPCDataControl));
        this.addTab(new ActionsPanelTab(nPCDataControl));
    }

    private class ActionsPanelTab
    extends PanelTab {
        private NPCDataControl dataControl;

        public ActionsPanelTab(NPCDataControl nPCDataControl) {
            super(TC.get((String)"NPC.ActionsPanelTitle"), nPCDataControl.getActionsList());
            this.setToolTipText(TC.get((String)"NPC.ActionsPanelTip"));
            this.dataControl = nPCDataControl;
        }

        @Override
        protected JComponent getTabComponent() {
            return new ActionsListPanel(this.dataControl.getActionsList());
        }
    }

    private class DialogPanelTab
    extends PanelTab {
        private NPCDataControl dataControl;

        public DialogPanelTab(NPCDataControl nPCDataControl) {
            super(TC.get((String)"NPC.DialogPanelTitle"), nPCDataControl);
            this.setToolTipText(TC.get((String)"NPC.DialogPanelTip"));
            this.dataControl = nPCDataControl;
        }

        @Override
        protected JComponent getTabComponent() {
            return new NPCDialogPanel(this.dataControl);
        }
    }

    private class LooksPanelTab
    extends PanelTab {
        private NPCDataControl dataControl;

        public LooksPanelTab(NPCDataControl nPCDataControl) {
            super(TC.get((String)"NPC.LookPanelTitle"), nPCDataControl);
            this.dataControl = nPCDataControl;
        }

        @Override
        protected JComponent getTabComponent() {
            return new NPCLooksPanel(this.dataControl);
        }
    }

    private class DocPanelTab
    extends PanelTab {
        private NPCDataControl dataControl;

        public DocPanelTab(NPCDataControl nPCDataControl) {
            super(TC.get((String)"NPC.DocPanelTitle"), nPCDataControl);
            this.dataControl = nPCDataControl;
        }

        @Override
        protected JComponent getTabComponent() {
            return new NPCDocPanel(this.dataControl);
        }
    }
}

